https://www.jqueryscript.net/table/Collapsible-Data-Grid-Plugin-With-jQuery-Treegrid.html
function treeGrid_initial(o) {


    var $table = $(o),
        rows = $table.find('tr');

    rows.each(function (index, row) {

        var $row = $(row),
            level = $row.data('level'),
            id = $row.data('id'),
            $columnName = $row.find('td[data-column="name"]'),
            children = $table.find('tr[data-parent="' + id + '"]');

        $row.addClass('tr-node');
        if (children.length) {
            var expander = $columnName.prepend('<span class="treegrid-expander glyphicon glyphicon-chevron-down"></span>');

            children.show();//children.hide();

            expander.find('.treegrid-expander').on('click', function (e) {
                var $target = $(e.target).closest('td').find('.treegrid-expander');
                if ($target.hasClass('glyphicon-chevron-left')) {
                    $target
                        .removeClass('glyphicon-chevron-left')
                        .addClass('glyphicon-chevron-down');

                    children.show();
                } else {
                    $target
                        .removeClass('glyphicon-chevron-down')
                        .addClass('glyphicon-chevron-left');

                    reverseHide($table, $row);
                }
            });
        }

        $columnName.prepend('<span class="treegrid-indent" style="width:' + 25 * level + 'px"></span>');

    });

    // Reverse hide all elements
    reverseHide = function (table, element) {
        var
            $element = $(element),
            id = $element.data('id'),
            children = table.find('tr[data-parent="' + id + '"]');

        if (children.length) {
            children.each(function (i, e) {
                reverseHide(table, e);
            });

            $element
                .find('.glyphicon-chevron-down')
                .removeClass('glyphicon-chevron-down')
                .addClass('glyphicon-chevron-left');

            children.hide();
        }
    };


}