﻿
<%@ WebHandler Language="C#" Class="cameraUploader" %>
using System;
using System.Web;
using System.IO;
using System.Globalization;
using System.Web.Script.Serialization;
using System.Drawing;
public class cameraUploader : IHttpHandler
{
    public void ProcessRequest(HttpContext context)
    {
        context.Response.ContentType = "text/plain";
        try
        {
            string pic_id = context.Request.Form["id"];
            string data_pic = context.Request.Form["file"];
            string file_location = context.Request.Form["location"];
            string dirFullPath = HttpContext.Current.Server.MapPath("~/files/" + file_location + "/");
            if (!System.IO.Directory.Exists(dirFullPath))
                System.IO.Directory.CreateDirectory(dirFullPath);
            string file_name = pic_id + "_" + (DateTime.UtcNow.ToFileTimeUtc() - 125911584000000000).ToString() + ".png";
            var bytess = Convert.FromBase64String(data_pic.Split(',')[1]);
            using (var imageFile = new FileStream(dirFullPath + file_name, FileMode.Create))
            {
                imageFile.Write(bytess, 0, bytess.Length);
                imageFile.Flush();
                //SaveThumbnailImage(data_pic.Split(',')[1], dirFullPath + file_name + "_thumb.png");
            }
            context.Response.Write(new JavaScriptSerializer().Serialize(new { message = "ok", path = "../../files/" + file_location + "/" + file_name }));
        }
        catch (Exception ex)
        {
            context.Response.Write(new JavaScriptSerializer().Serialize(new { message = ex.Message }));
        }
    }

    private void SaveThumbnailImage(string base64String, string fullOutputPath)
    {
        byte[] bytes = Convert.FromBase64String(base64String);
        //Image image;
        using (MemoryStream ms = new MemoryStream(bytes))
        {
            Image image = Image.FromStream(ms, true, true);
            Image thumb = image.GetThumbnailImage(320, 240, () => false, IntPtr.Zero);
            thumb.Save(fullOutputPath);
        }
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
}