﻿function handleFileSelect(evt) {
    var files = evt.target.files; // FileList object
    var xl2json = new ExcelToJSON();
    xl2json.parseExcel(files[0]);
    $(evt.target).val('');
}
var ExcelToJSON = function () {
    this.parseExcel = function (file) {
        var reader = new FileReader();
        var tbl = "excel";
        reader.onload = function (e) {
            var data = e.target.result;
            var workbook = XLSX.read(data, {
                type: 'binary'
            });
            var headers = [];
            var header_list = [];
            headers.push("<thead><tr>");
            headers.push("<th style=\"width:5px;min-width:5px;max-width:25px; \"><input type=\"checkbox\"  onclick=\"checkAll('#tbl_" + tbl + "',this);\"/></th>");
            var sheet_name_list = workbook.SheetNames;
            for (var sheetIndex = 0; sheetIndex < sheet_name_list.length; sheetIndex++) {
                var worksheet = workbook.Sheets[sheet_name_list[sheetIndex]];
                for (let key in worksheet) {
                    let regEx = new RegExp("^\([A-Z])\([A-Z])\(1){1}$");
                    let regEx2 = new RegExp("^\([A-Z])\(1){1}$");
                    if (regEx.test(key) == true || regEx2.test(key) == true) {
                        headers.push('<th name="' + worksheet[key].v +'">' + worksheet[key].v + '</th>');
                        header_list.push(worksheet[key].v);
                    }
                }
            }
            headers.push("</tr></thead>");
            workbook.SheetNames.forEach(function (sheetName) {

                var XL_row_object = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[sheetName]);
                var productList = JSON.parse(JSON.stringify(XL_row_object));

                /// var headers = [];
                var rows = [];
                // console.log(productList)
                rows.push("<tbody>");
                for (i = 0; i < productList.length; i++) {
                    var row = Object.values(productList[i])
                    var column = Object.entries(productList[i])
                    //if (i == 0) {
                    //    headers.push("<thead><tr>");
                    //    headers.push("<th style=\"width:5px;min-width:5px;max-width:25px; \"><input type=\"checkbox\"  onclick=\"checkAll('#tbl_" + tbl + "',this);\"/></th>");
                    //    for (j = 0; j < column.length; j++) {
                    //        headers.push('<th>' + column[j][0] + '</th>');
                    //    }
                    //    headers.push("</tr></thead>");
                    //}
                    rows.push('<tr code="' + (i + 1) + '">');
                    rows.push("<td><input name='chb' type='checkbox' class='checkbox' /></td>");
                    for (j = 0; j < header_list.length; j++) {
                        var tt = '';
                        for (k = 0; k < column.length; k++) {

                            if (column[k][0] == header_list[j]) {
                                tt = column[k][1];
                                break;
                            }
                        }
                        rows.push('<td name="' + header_list[j]+'">' + tt + '</td>');

                    }
                    rows.push('</tr>');
                }
                rows.push("</tbody>");
                var top = "<table id=\"tbl_" + tbl + "\" class='dgv  tableFixHead  table-striped table-bordered'>";
                var bottom = "</table>";
                $('#div_' + tbl).html(top + headers.join("") + rows.join("") + bottom);
            });

        };
        reader.onerror = function (ex) {
            console.log(ex);
        };

        reader.readAsBinaryString(file);
    };
};
