
let sanacoName = "sanacoCookie";

function setCookie(name, value, daysToLive) {
    let cookie = name.trim() + "=" + encodeURIComponent(value);    // delete semicolons, commas, and whitespace ('g;h_1 2,32'=>'g%3Bh_1%202%2C32')

    if (typeof daysToLive === "number") {
        cookie += "; max-age=" + (daysToLive * 86400) + ";";   // convert day to seconds (24h * 60m * 60s)
        //cookie += "path=/; domain=sanacosoft.com" //  uncomment for the availability of cookie on all pages of my site
        document.cookie = cookie;
    }
}

function getCookie(name) {

    let cookieArr = document.cookie.split(";");
    for (let item of cookieArr) {
        let cookiePair = item.split('=');

        if (name.trim() === cookiePair[0].trim()) {
            return decodeURIComponent(cookiePair[1]);   // return cookie value with semicolons, commas, and whitespace ('g%3Bh_1%202%2C32'=>'g;h_1 2,32')
        }
    }
    
    return null;    // return null if not found
}

function clearIdentity() {

    let value = getCookie(sanacoName);
    if (value) {
        setCookie(sanacoName, "", 0);
    }
}

function setIdentity(encryptedId) {

    if (encryptedId) {
        clearIdentity();
        setCookie(sanacoName, encryptedId, 30);
    }
}

window.addEventListener('load', (e) => {
    let encryptedId = getCookie(sanacoName);
    if (!encryptedId) {
        encryptedId = null;
    }
    //window.todoWhenLoaded(encryptedId);
})

/////////////////////////////////////////////////////////////////////
//      cut and use this block to your program
/////////////////////////////////////////////////////////////////////
//    window.todoWhenLoaded = function(encryptedId){
//        // you have browser encryptedId, add your logic here
//        // Commands that should be done after loading
//        // If encryptedId is null, User must login
//    }
// -----------------------------------------------------------------   
//    setIdentity(encryptedId);       // set cookie for auto login
// -----------------------------------------------------------------  
//    clearIdentity();                // clear login cookie
/////////////////////////////////////////////////////////////////////