﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_workgroup_shift.aspx.cs" Inherits="TimeWork.page_workgroup_shift" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link href="../../Style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../Style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../Style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../Style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../Style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../Style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script> 
        $(document).ready(function () {
            initial_page(1000, 600);
            load();
        });
        function load() {
            reqsvr("load", "",
                function (data) {
                    load_tbl_btn(data.d, "workgroup");
                    tbl_add_copy_btn("workgroup");
                    $("#tbl_workgroup tbody tr:first").addClass("selectedtr");
                    change_workgroup();
                    $("#tbl_workgroup").addClass("w-full");
                    $("#tbl_workgroup tr td").click(function () {
                        change_workgroup($(this).closest("tr").attr('code'));
                    });
                });
        }
        function refresh_workgroup() {
            refresh();
            change_workgroup(tbl_cur_row("#tbl_workgroup"));
        }

        function change_workgroup(code) {
            if (code == undefined) {
                code = tbl_cur_row("#tbl_workgroup");
            }
            reqsvr("load_workgroup", "code:" + code,
                function (data) {
                    load_tbl_btn(data.d[1], "shift");
                    tbl_add_copy_btn("shift");
                    load_tbl_btn(data.d[2], "rotatory");
                    tbl_add_copy_btn("rotatory");
                    load_tbl_btn(data.d[3], "combine"); 

                });
        }
        function new_workgroup() {
            open_form_("../../page/workgroup_shift/page_workgroup.aspx", "گروه کاری", "-1", 'load()');
        };
        function edit_workgroup(o) {
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;
            open_form_("../../page/workgroup_shift/page_workgroup.aspx", "گروه کاری", code, 'load()');
        };
        function delete_workgroup(o) {
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;
            confirm_alert(function () {
                reqsvr("delete_workgroup", "code:" + code,
                    function (data) {
                        if (data.d == "ok") {
                            load();
                            refresh();
                            alert_message("حذف انجام شد");
                        }
                        else
                            alert_error(data.d);
                    });
            });
        }
        function copy_workgroup(o) {
            var code = tbl_cur_row("#tbl_workgroup");
            if (code == "" || code == undefined) { alert_error("لطفا یک مورد انتخاب نمائید"); return; }
            show_input_alert('عنوان جدید', '',
                function (v) {
                    reqsvr("copy_workgroup", "code:" + code + ",name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {
                                load();
                            }
                            else
                                alert_error(data.d);
                        });
                });
             
        }
        function new_rotatory() {

            var workgroup_id = tbl_cur_row('#tbl_workgroup');
            if (workgroup_id == "") return;
            open_form_("../../page/workgroup_shift/page_rotatory.aspx", "برنامه چرخشی", + "-1" + "&" + workgroup_id, 'refresh_workgroup');
        };
        function edit_rotatory(o) {
            var workgroup_id = tbl_cur_row('#tbl_workgroup');
            if (workgroup_id == "") return;
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;
            open_form_("../../page/workgroup_shift/page_rotatory.aspx", "برنامه چرخشی", + code + "&" + workgroup_id, 'refresh_workgroup');
        }
        function delete_rotatory(o) {
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;
            confirm_alert(function () {
                reqsvr("delete_rotatory", "code:" + code,
                    function (data) {
                        if (data.d == "ok") {
                            refresh_workgroup();
                            refresh();
                            alert_message("حذف انجام شد");
                        }
                        else
                            alert_error(data.d);
                    });
            });
        }
        function copy_rotatory(o) {


            var code = tbl_cur_row("#tbl_rotatory");
            if (code == "" || code == undefined) { alert_error("لطفا یک مورد انتخاب نمائید"); return; }
            show_input_alert('عنوان جدید', '',
                function (v) {
                    reqsvr("copy_rotatory", "code:" + code + ",name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {
                                load();
                            }
                            else
                                alert_error(data.d);
                        });
                });

        }

        function new_shift() {
            var workgroup_id = tbl_cur_row('#tbl_workgroup');
            if (workgroup_id == "") return;
            open_form_("../../page/workgroup_shift/page_shift.aspx", "شیفت جدید", "-1" + "&" + workgroup_id, 'refresh_workgroup');

        };
        function edit_shift(o) {
            var workgroup_id = tbl_cur_row('#tbl_workgroup');
            if (workgroup_id == "") return;
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;
            open_form_("../../page/workgroup_shift/page_shift.aspx", "ویرایش شیفت", + code + "&" + workgroup_id, 'refresh_workgroup');
        }
        function delete_shift(o) {
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;
            confirm_alert(function () {
                reqsvr("delete_shift", "code:" + code,
                    function (data) {
                        if (data.d == "ok") {
                            refresh_workgroup();
                            refresh();
                            alert_message("حذف انجام شد");
                        }
                        else
                            alert_error(data.d);
                    });
            });

        }
        function copy_shift(o) {
            var code = tbl_cur_row("#tbl_shift");
            if (code == "" || code == undefined) { alert_error("لطفا یک مورد انتخاب نمائید"); return; }
            show_input_alert('عنوان جدید', '',
                function (v) {
                    reqsvr("copy_shift", "code:" + code + ",name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {
                                load();
                            }
                            else
                                alert_error(data.d);
                        });
                });
        }

        function new_combine() {
            var workgroup_id = tbl_cur_row('#tbl_workgroup');
            if (workgroup_id == "") return;
            open_form_("../../page/workgroup_shift/page_shift_combine.aspx", "ایجاد ترکیب", "-1" + "&" + workgroup_id, "refresh_workgroup");

        }
        function edit_combine(o) {
            var workgroup_id = tbl_cur_row('#tbl_workgroup');
            if (workgroup_id == "") return;
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;
            open_form_("../../page/workgroup_shift/page_shift_combine.aspx", "ویرایش ترکیب", code + "&" + workgroup_id, "refresh_workgroup");

        }
        function delete_combine(o) {


            var code = $(o).closest('tr').attr("code");
            if (code == "") return;
            confirm_alert(function () {
                reqsvr("delete_combine", "code:" + code, function (data) {
                    if (data.d == "ok") {
                        refresh_workgroup();
                        refresh();
                        alert_message("حذف انجام شد");
                    }
                    else
                        alert_error(data.d);
                });
            });

        }

    </script>
</head>
<body>
    <form>
        <div class="row">
            <div class="col-xs-5">

                <div id="div_workgroup" class="panel auto-height">
                </div>
            </div>


            <div class="col-xs-7 panel  ">
                <ul id="tab_control" class="nav nav-tabs">
                    <li class="active"><a data-toggle="tab" href="#div_shift"><span class="glyphicon glyphicon-list-alt">&nbsp;</span>شیفت ها</a></li>
                    <li><a data-toggle="tab" href="#div_rotatory"><span class="glyphicon glyphicon-list-alt">&nbsp;</span>برنامه چرخشی</a></li>
                    <li><a data-toggle="tab" href="#div_combine"><span class="glyphicon glyphicon-list-alt">&nbsp;</span>ترکیب شیفت</a></li>
                </ul>
                <div class="tab-content start-offset">

                    <div id="div_shift" class="tab-pane fade  in active  auto-height">
                    </div>
                    <div id="div_rotatory" class="tab-pane fade  auto-height ">
                    </div>
                    <div id="div_combine" class="tab-pane fade  auto-height ">
                    </div>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
