﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_rotatory_manage.aspx.cs" Inherits="TimeWork.page_rotatory_manage" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/Treeview/Treeview.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/Treeview/Treeview.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>

    <script> 
        $(document).ready(function () {
            initial_tab();
            load();
        });

        function load() {

            reqsvr("load", " ",
                function (data) {
                    load_cb('#cb_workgroup', data.d);
                    load_rotatory();

                    $("#cb_workgroup").on('change',
                        function (e ) {
                            
                            load_rotatory();
                        }

                    );
                }
            );

        }

        function load_rotatory() {

            reqsvr("load_rotatory", "workgroup_id:" + $("#cb_workgroup").val(),
                function (data) {
                    load_tbl_btn_copy(data.d, 'rotatory');
                    $("#tbl_rotatory tbody tr:first").addClass("selectedtr");

                    refresh_();
                    $("#tbl_rotatory tr td").click(function () {
                        refresh_($(this).closest("tr").attr('code'));
                    });

                }); 
        }

        function refresh_(code) {
            if ($("#tbl_rotatory tbody tr").length > 0) {

                if (code == undefined) {
                    code = tbl_cur_row("#tbl_rotatory");
                }
            } else
                code = "";

            load_personel(code);
        }
        function load_personel(id) {


            var ch = $("#chb_all")[0].checked ? 1 : 0;
            reqsvr("load_personel", "code:'" + id + "',all:" + ch,
                function (data) {
                    load_tbl_chb(data.d, 'personel');
                    //satus(data.d);
                });


        }
        function new_rotatory() {
            open_form_("../../page/workgroup_shift/page_rotatory.aspx", "ایجاد برنامه چرخشی", "-1&-1", 'load');
        };
        function edit_rotatory(o) {
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;
            open_form_("../../page/workgroup_shift/page_rotatory.aspx", "ویرایش برنامه چرخشی", code + "&-1", 'load');


        }
        function delete_rotatory(o) {
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;
            confirm_alert(function () {
                reqsvr("delete", "code:" + code,
                    function (data) {
                        if (data.d == "ok") {
                            load();
                            alert_message("حذف انجام شد");
                        }
                        else
                            alert_error(data.d);
                    });
            });
        }

        function copy_rotatory(o) {
            var code = $(selected_tr).attr("code");
            if (code == "" || code == undefined) { alert_error("لطفا یک مورد انتخاب نمائید"); return; }
            show_input_alert('عنوان جدید', '',
                function (v) {
                    reqsvr("copy", "code:" + code + ",name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {
                                load();
                            }
                            else
                                alert_error(data.d);
                        });
                });

        }

        function add_personel() {

            var code = tbl_cur_row("#tbl_rotatory", "code");
            if (code == "") return;

            open_form_('../../page/personnel/page_personnel_rotatory_add.aspx', 'اضافه کردن افراد  ', code, "refresh_");

        }

        function change_personel() {

            var row = get_checked('#tbl_personel');
            if (row == null) return;
            var code = tbl_cur_row("#tbl_rotatory", "code");
            if (code == "") return;


            open_form_('../../page/personnel/page_personnel_rotatory_add.aspx', 'جابجایی افراد', code + "&" + row, "refresh_");

        }
        function del_personel() {
            var row = get_checked('#tbl_personel');
            if (row == null || row == "") return;


            confirm_alert(function () {
                reqsvr("delete_personel",
                    "row:'" + row + "'",
                    function (data) {
                        if (data.d == "ok") {

                            refresh_();
                        }
                        else
                            alert_error(data.d);
                    });
            });
        }
    </script>
</head>
<body>
    <form>
        <div class="btn-group bg-menu">
            <a href="#" class="btn btn-default glyphicon glyphicon-refresh" onclick="load()"></a>&nbsp;&nbsp;&nbsp;
            <label class="w-100">گروه کاری :</label><select id="cb_workgroup" class="form-control w-300"></select>
        </div>
        <div class="row  auto-height no-scroll">
            <div class="col-xs-5">
                <div id="div_rotatory" class=" panel auto-height " style="overflow-y: scroll; border: 1px solid gray;">
                </div>
            </div>
            <div class="col-xs-6">
                <div class="btn-group w-full bg-menu">
                    <button onclick="add_personel()" type="button" class="btn btn-info "><span class="glyphicon glyphicon-plus">&nbsp;</span>اضافه نمودن افراد</button>
                    <button onclick="del_personel()" type="button" class="btn btn-danger "><span class="glyphicon glyphicon-trash">&nbsp;</span>حذف پرسنل</button>
                    <button onclick="change_personel()" type="button" class="btn btn-primary "><span class="glyphicon glyphicon-retweet">&nbsp;</span>جابجایی افراد</button>
                    &nbsp;<input id="chb_all" name="all" type="checkbox" class="form-control" value="همه افراد " onchange="refresh_()" />&nbsp;<span>نمایش افراد قطع کار شده</span>

                </div>
                <div id="div_personel" class="auto-height"></div>
            </div>
        </div>
    </form>

</body>
</html>
