﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_rotatory.aspx.cs" Inherits="TimeWork.page_rotatory" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../Style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../Style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../Style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../Style/contextMenu/bootstrap-contextmenu.css" rel="stylesheet" />
    <link href="../../Style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../Style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../Style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../Style/mask/jquery.mask.min.js" type="text/javascript"></script>
    <script src="../../Style/contextMenu/bootstrap-contextmenu.js" type="text/javascript"></script>
    <script src="../../script/FncDate.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script> 
        var code;
        var wgid;
        $(document).ready(function () {
             initial_date_ok = true;
            var array = initial_page(800, 600);
            code = array[0];
            wgid = array[1];
            if (wgid == undefined) {
                wgid = "-1";
            }
            var objCal1 = new PesianDate.persianCalendar('sdate', {
                onchange: function (pdate) {
                    if (pdate) {
                        refresh_date();

                    } else {
                        //alert('تاریخ ابتدا وارد شده نادرست است');
                    }
                }
            });
            load();


            $("#priod").focusout(function () {
                var max = parseInt($(this).attr('max'));
                var min = parseInt($(this).attr('min'));
                if ($(this).val() > max) {
                    $(this).val(max);
                }
                else if ($(this).val() < min) {
                    $(this).val(min);
                }
            });
        });
        var cur_cell;
        function load() {
            reqsvr("load", "code:" + code + ",wgid:" + wgid,
                function (data) {
                   load_cb("[name='nobatkari']", data.d[5]);
                    if (code == -1) {
                        $("[name='name']").val(data.d[0]);
                        $("[name='start_date']").val(data.d[1]);
                    }
                    else {
                        set_XML_div("#main", data.d[2]);
                    }
                    $("#tbl_rotatory tbody").html(data.d[3]);
                   load_cb('#cb_workgroup', data.d[6]);

                    if (wgid == "-1") {
                        wgid = data.d[7];
                        $("#cb_workgroup").val(wgid);
                        $("#cb_workgroup").on('change',
                            function () {
                                reqsvr("get_shift_workgroup", "code:" + this.value, function (data) {
                                    load_context_menu('#menu_shift', data.d);
                                });
                            });
                    }
                    else {
                        $("#cb_workgroup").val(wgid);
                        $("#cb_workgroup").prop("disabled", "true");
                    }

                    rowCount = $('#tbl_rotatory tbody tr').length;
                    $("#priod").val(rowCount);

                    $("#tbl_rotatory .cmenu").contextmenu({
                        left_click: true,
                        target: '#div_context_shift',
                        onItem: contextmenu_onitem,
                        before: contextmenu_before

                    });
                    load_context_menu('#menu_shift', data.d[4]);
                });
        }

        function load_context_menu(o, data) {
            wgid = $("#cb_workgroup").val();
            d = $(data).find("mytable");
            $(o).empty();
            d.each(function () {
                var mn = $(this).find('mininame').text();
                if (mn !== "") mn = "  (" + mn + ")";
                if ($(this).find('disable').text().toLowerCase() == "false")
                    $(o).append($('<a class="next-td" tabindex="-1" wgid="' + $(this).find('workgroupid').text() + '" shmname="' + $(this).find('mininame').text() + '" val="' + $(this).find('code').text() + '" herf="#">' + $(this).find('name').text() +   mn + '</li>'));
            });
        }

        function set_shift(shid) {
            reqsvr("get_shift_name", "code:" + shid, function (data) {
                $(cur_cell).text(data.d);
                $(cur_cell).attr("shid", shid);
            });
        }

        function add_row() {
            var shift = 'تعطیل';
            var tr;
            if ($('#tbl_rotatory tbody tr').length == 0) {
                date = $('#sdate').val();
                shift = '<a href="#"  class="shift w-full" shid="0">تعطیل</a>';
                tr = '<tr>'
                    + '<td name="date">' + date + '</td>'
                    + '<td>...</td><td class="cmenu">' + shift + '</td>'
                    + '<td class="cmenu"><a href="#"  class="shift_0 w-full" shid="-1">-</a></td>'
                    + '<td class="cmenu"><a href="#"  class="shift_1 w-full" shid="-1">-</a></td>'
                    + '<td class="cmenu"><a href="#"  class="shift_2 w-full" shid="-1">-</a></td>'
                    + '<td class="cmenu"><a href="#"  class="shift_3 w-full" shid="-1">-</a></td>'
                    + '<td class="cmenu"><a href="#"  class="shift_4 w-full" shid="-1">-</a></td>'
                    + '<td class="cmenu"><a href="#"  class="shift_5 w-full" shid="-1">-</a></td>'
                    + '<td class="cmenu"><a href="#"  class="shift_6 w-full" shid="-1">-</a></td>'
                    + '<td class="cmenu"><a href="#"  class="shift_7 w-full" shid="-1">-</a></td>'
                    + '</tr> ';
            }
            else {
                tr = $('#tbl_rotatory tbody tr:last').clone();
            }
            $('#tbl_rotatory tbody').append(tr);
            $("#tbl_rotatory tbody tr:last .cmenu").contextmenu({
                left_click: true,
                target: '#div_context_shift',
                onItem: contextmenu_onitem,
                before: contextmenu_before
            });
        }

        function contextmenu_before(obj, e) {

            if ($(e).find("a").hasClass("shift")) {


                $("#menu_shift").find("a[wgid='-2']").addClass("hide");
            }
            else {
                $("#menu_shift").find("a[wgid='-2']").removeClass("hide");

            }
        }
        function contextmenu_onitem(obj, e) {

            cur_cell = $(obj).find('a');
            if ($(e.target).attr("val") == '-1' && $(e.target).attr("wgid") !== "-2") {
                open_form_("../../page/workgroup_shift/page_shift_list.aspx", "لیست شیفت ها", '', 'set_shift');
                return;
            }
            var item = $(e.target);
            cur_cell.text(item.text());
            cur_cell.attr("shid", item.attr("val"));
        }

        function del_row() {
            $('#tbl_rotatory tbody tr:last').remove();
        }

        function save() {


            $("input").removeClass('red_border');
            var error = 0;
            if ($("#name").val() + '' == "") {
                $("#name").addClass('red_border');
                error = 1;
            }
            if (!IsValidDate($("#sdate").val())) {
                $("#sdate").addClass('red_border');
                error = 1;
            }
            if (error == 1) {
                alert('لطفا قسمت های قرمز رنگ را بطور صحیح وارد نمائید');
                return;
            }
            var cnt = 0;
            var data_all = ",";
            var data_0 = ",";
            var data_1 = ",";
            var data_2 = ",";
            var data_3 = ",";
            var data_4 = ",";
            var data_5 = ",";
            var data_6 = ",";
            var data_7 = ",";
            $('#tbl_rotatory tbody tr').each(function () {
                cnt++;
                var row = $(this);
                data_all = data_all + row.find('.shift').attr('shid') + ",";
                data_0 = data_0 + row.find('.shift_0').attr('shid') + ",";
                data_1 = data_1 + row.find('.shift_1').attr('shid') + ",";
                data_2 = data_2 + row.find('.shift_2').attr('shid') + ",";
                data_3 = data_3 + row.find('.shift_3').attr('shid') + ",";
                data_4 = data_4 + row.find('.shift_4').attr('shid') + ",";
                data_5 = data_5 + row.find('.shift_5').attr('shid') + ",";
                data_6 = data_6 + row.find('.shift_6').attr('shid') + ",";
                data_7 = data_7 + row.find('.shift_7').attr('shid') + ",";

            });

            if (cnt <= 0)
                return;
            var data = get_data_div();

            reqsvr("save",
                "code:'" + code + "',wgid:'" + wgid + "',data:'" + data + "',data_all:'" + data_all + "',data_0:'" + data_0 + "',data_1:'" + data_1 + "',data_2:'" + data_2 + "',data_3:'" + data_3 + "',data_4:'" + data_4 + "',data_5:'" + data_5 + "',data_6:'" + data_6 + "',data_7:'" + data_7 + "'",
                function (data) {
                    if (data.d == "ok") {
                        alert_success("ذخیره شد");
                        call_fnc();
                        close();
                    }
                    else
                        alert_error(data.d);
                });
        };

        function load_grid() {
            var rowCount = $('#tbl_rotatory tbody tr').length;
            var priod = $("#priod").val();
            if (rowCount < priod) {
                for (var i = rowCount; i < priod; i++) {
                    add_row();
                }
            }
            else {
                for (var i = rowCount; i > priod; i--) {
                    del_row();
                }
            }
            rowCount = $('#tbl_rotatory tbody tr').length;
            refresh_date();
            $("#priod").val(rowCount);
        }

        function refresh_date() {
            var date = $('#sdate').val();
            var rowCount = $('#tbl_rotatory tbody tr').length;

            reqsvr("get_freeday", "date:'" + date + "',cnt:" + rowCount, function (data) {

                var xmlDoc = $.parseXML(data.d);

                $('#tbl_rotatory > tbody  > tr').each(function () {

                    $(this).find('td:nth-child(1)').html(date);
                    $(this).find('td:nth-child(2)').html(GetPersianDayName(date));
                    if ($(xmlDoc).find("mytable date:contains('" + date + "')").length > 0 || WeekDayNum(date) == 6)
                        $(this).css("color", "red");
                    else
                        $(this).css("color", "unset");

                    date = ShdAdd(date, 1);
                });
            });

        }
    </script>
</head>
<body>
    <form>
        <div class="panel pad5">
            <div id="main">
                <table class="w-full ">
                    <tr>
                        <td class="w-100">
                            <span>عنوان برنامه :</span>

                        </td>
                        <td colspan="1">
                            <input name="name" force="1" class="form-control w-250" type="text" maxlength="50" value="" />
                        </td>
                        <td class="w-100">
                            <span>گروه کاری :</span>

                        </td>
                        <td colspan="2">
                            <select id="cb_workgroup" class="form-control w-300"></select>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <span>تاریخ شروع :</span>
                        </td>
                        <td class="w-250">
                            <input id="sdate" name="start_date" force="1" class="form-control pdate date" type="text" />
                        </td>

                        <td class="w-100">
                            <span>دوره گردش :</span>
                        </td>
                        <td class="w-250">
                            <input id="priod" name="priod" class="form-control w-50" force="1" type="number" min="1" max="120" value="1" onchange="load_grid()" />

                        </td>
                        <td class="w-250">
                            <span>نوبت کاری :</span>
                            <select name="nobatkari" class="form-control w-100" style="display: inline;">
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td colspan="2">
                            <input name="free_day" class="form-control" type="checkbox" /><span>  تعطیلات رسمی در برنامه تعطیل گردد (بجز جمعه ها)  </span>
                        </td>
                        <td colspan="1">
                            <input name="disable" class="form-control" type="checkbox" /><span>غیر فعال</span>

                        </td>
                    </tr>

                </table>
            </div>
            <div class="auto-height">
                <table style="width: 100%;" id="tbl_rotatory" class="dgv table-bordered table-striped tableFixHead">
                    <thead>
                        <tr>
                            <th class="w-50"><span>تاریخ</span></th>
                            <th class="w-50"><span>ایام هفته</span></th>
                            <th class="w-100"><span>همه روزها</span></th>
                            <th class="w-50"><span>شنبه</span></th>
                            <th class="w-50"><span>یک شنبه</span></th>
                            <th class="w-50"><span>دو شنبه</span></th>
                            <th class="w-50"><span>سه شنبه</span></th>
                            <th class="w-50"><span>چهار شنبه</span></th>
                            <th class="w-50"><span>پنج شنبه</span></th>
                            <th class="w-50"><span>جمعه</span></th>
                            <th class="w-50"><span>تعطیلات رسمی</span></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
        <div class="toolbar-footer">
            <button type="button" onclick="save()" class="btn btn-success  ">ذخیره</button>
        </div>

        <div id="div_context_shift" style="position: absolute; z-index: 9999; top: 123px; left: 322px; min-width: 200px">
            <ul class="dropdown-menu" role="menu" style="">
                <li style="text-align: center; background: #eee;" class="no-action" id="lb_date"></li>
                <li class="divider no-action"></li>
                <li id="menu_shift" style="height: 250px; overflow-y: scroll">
                    <a tabindex="-1">null</a>
                </li>
                <li class="divider no-action"></li>
                <li>
                    <a tabindex="-1" val="-1" href="#">فراخوانی از سایر گروهها</a></li>
            </ul>
        </div>
    </form>
</body>
</html>
