﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_workflow_rull.aspx.cs" Inherits="TimeWork.page_workflow_rull" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <link href="../../style/tagify/tagify.css" rel="stylesheet" />

    <script  src="../../script/jquery.min.js"  type="text/javascript" ></script>
    <script  src="../../style/bootstrap/bootstrap.min.js"  type="text/javascript" ></script>
    <script  src="../../script/fnc.js"  type="text/javascript" ></script>
    <script  src="../../style/tagify/tagify.min.js"  type="text/javascript" ></script>
    <script >

        var detail;
        var field = [];
        var parameter = [];

        $(document).ready(function () {
            var ar = initial_page(700, 500);

            $("#title").val(ar[0]);
            $("#detail").val(ar[1]);

            reqsvr("load", "formul:'" + parent.temp+ "'", function (data) {
                $(data.d[0]).find("mytable").each(function () {
                    field.push({ value: $(this).find('code').text(), text: $(this).find('name').text(), kind: 'f' });
                });  
                //$(data.d[1]).find("mytable").each(function () {
                //    parameter.push({ value: $(this).find('code').text(), text: $(this).find('name').text(), kind: 'p' });
                //});

                $("#formul_xml").val(data.d[2]);
                initial_tagify();
            });
        });

        function initial_tagify() {
            var input = document.querySelector('#formul_xml'),
                tagify = new Tagify(input, {
                    mode: 'mix',  // <--  Enable mixed-content
                    pattern: /@|#/,  // <--  Text starting with @ or # (if single, String can be used here)
                    tagTextProp: 'text',  // <-- the default property (from whitelist item) for the text to be rendered in a tag element.
                    enforceWhitelist: true,
                    whitelist: field.concat(parameter).map(function (item) { return typeof item == 'string' ? { value: item } : item }),
                    keepInvalidTags: 0,
                    duplicates: 1,
                    dropdown: {
                        enabled: 0,
                        maxItems: 1000,
                        position: 'text', // <-- render the suggestions list next to the typed text ("caret")
                        mapValueTo: 'text', // <-- similar to above "tagTextProp" setting, but for the dropdown items
                        highlightFirst: false  // automatically highlights first sugegstion item in the dropdown
                    },
                    transformTag: transformTag
                })
            tagify.on('input', function (e) {
                switch (e.detail.prefix) {
                    case '@': tagify.settings.whitelist = field; break;
                    case '#': tagify.settings.whitelist = parameter; break;
                } 
                if (e.detail != undefined && e.detail.value.length > 1) tagify.dropdown.show.call(tagify, e.detail.value);
            })
            function transformTag(tagData) {
                switch (tagData.kind) {
                    case "f": tagData.style = "--tag-bg:#a3ffb6"; break;
                    case "p": tagData.style = "--tag-bg:#c5d9ff"; break;
                }
            }
        }
        function save() {

            reqsvr("check", "formul_xml:'" + $("#formul_xml").val() + "'",
                function (data) {
                    if (data.d[0] == "ok") { 
                        call_fnc( "'" + $("#title").val() + "'","'" + data.d[1] + "'", "'" + $("#detail").val() + "'");
                        close();
                    }
                    else
                        alert_error(data.d[0]);
                });
        }

    </script>
</head>
<body>
    <div id="div_main" class="row">


        <div class="col-sm-12">
            <span>عنوان : </span>
            <input type="text" id="title" class="w-full" />
        </div>
        <div class="col-sm-12">
            <span>توضیحات : </span>
            <input type="text" id="detail" class="w-full" />
        </div>



        <div class="col-sm-12 ">
            <span>متن شرط : </span>
            <div class="w-full tagify" style="height: 200px; overflow: scroll" dir="ltr">
                <textarea id="formul_xml" class="w-full"> </textarea>
            </div>

        </div>

    </div>

    <div class="toolbar-footer">
        <button type="button" class="btn btn-success  " onclick="save()">ذخیره</button>
    </div>

</body>
</html>
