﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_workflow_new.aspx.cs" Inherits="TimeWork.page_workflow_new" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/gojs/go.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>

    <script>
        var ecode; 
        var model;
        $(document).ready(function () {
            var ar = initial_page(1200, 750);
            ecode = ar[0];

            reqsvr("load", "code:" + ecode,
                function (data) {
                    load_tbl_chb(data.d[0], 'request');
                    if (ecode != "-1") {

                        var this_ = $(data.d[1]);
                        $("#tb_name").val(this_.find("name").text());
                        $("#tb_detail").val(this_.find("detail").text());
                        $("#chb_disable").attr('checked', (this_.find("disable").text() == "1"));
                        model = this_.find("model").text();
                        $("#mySavedModel").val(model);
                        set_check(this_.find("request").text(), '#tbl_request');
                        $('#chb_all').prop('checked', this_.find('assign').text() == '');
                        $('#chb_and_assign').prop('checked', this_.find('and_assign').text() == '1');
                        $('#chb_and_unassign').prop('checked', this_.find('and_unassign').text() == '1');
                        $('#chb_admin').prop('checked', this_.find('admin').text() == '1');
                        $('#chb_not_admin').prop('checked', this_.find('not_admin').text() == '1');
                        load_tbl_chb(data.d[3], "assign");
                        load_tbl_chb(data.d[4], "unassign");
                        $('#tbl_assign tbody').find("input").prop('checked', true);
                        $('#tbl_unassign tbody').find("input").prop('checked', true);

                        initial();
                    }
                });
            unwait_();
        });

        var first = false;
        var cur_node;
        function initial() {
            if (first) return;
            first = true;
            var $ = go.GraphObject.make;  // for conciseness in defining templates
            myDiagram = $(go.Diagram, "myDiagramDiv",  // must name or refer to the DIV HTML element
                {
                    "LinkDrawn": showLinkLabel,  // this DiagramEvent listener is defined below
                    "LinkRelinked": showLinkLabel,
                    "undoManager.isEnabled": true  // enable undo & redo
                });

            function request_click(e, obj) {
                cur_node = obj.part;
                open_form_('../../page/workflow/page_workflow_request.aspx', 'انتخاب درخواست', cur_node.data.text + "&" + cur_node.data.value + "&" + cur_node.data.detail, "set_value");
            }

            function reciver_click(e, obj) {
                cur_node = obj.part;
                open_form_('../../page/workflow/page_workflow_reciver.aspx', 'تائید کننده', cur_node.data.value + "&" + cur_node.data.detail + "&0", "set_value");

            }
            function reciver_ro_click(e, obj) {
                cur_node = obj.part;
                open_form_('../../page/workflow/page_workflow_reciver.aspx', 'جهت اطلاع', cur_node.data.value + "&" + cur_node.data.detail + "&1", "set_value");

            }
            function reciver_sms_click(e, obj) {
                cur_node = obj.part;
                open_form_('../../page/workflow/page_workflow_sms.aspx', 'انتخاب گیرنده', cur_node.data.value + "&" + cur_node.data.detail, "set_value");

            }
            function condition_click(e, obj) {
                cur_node = obj.part;
                parent.temp = cur_node.data.value;
                open_form_('../../page/workflow/page_workflow_rull.aspx', 'تنظیم شرط', cur_node.data.text + "&" + cur_node.data.detail, "set_value");

            }
            //myDiagram.model.setDataProperty(node.data, "text", "salam");
            //var msg = "key: " + node.data.key + "\n";
            //msg += "category: " + node.data.category + "\n";
            //msg += "text: " + node.data.text + "\n";
            //alert(msg);


            //function showProperties(e, obj) {  // executed by ContextMenuButton
            //    var node = obj.part.adornedPart;
            //    var msg = "key: " + node.data.key + "\n";
            //    msg += "category: " + node.data.category + "\n";
            //    msg += "Selection includes:";
            //    myDiagram.selection.each(function (part) {
            //        msg += "  " + part.toString();
            //    });
            //    alert(msg);
            //}
            // when the document is modified, add a "*" to the title and enable the "Save" button
            myDiagram.addDiagramListener("Modified", function (e) {
                //var button = document.getElementById("SaveButton");
                //if (button) button.disabled = !myDiagram.isModified;
                //var idx = document.title.indexOf("*");
                //if (myDiagram.isModified) {
                //    if (idx < 0) document.title += "*";
                //} else {
                //    if (idx >= 0) document.title = document.title.substr(0, idx);
                //}
            });
            // helper definitions for node templates

            function nodeStyle() {
                return [
                    // The Node.location comes from the "loc" property of the node data,
                    // converted by the Point.parse static method.
                    // If the Node.location is changed, it updates the "loc" property of the node data,
                    // converting back using the Point.stringify static method.
                    new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
                    {
                        // the Node.location is at the center of each node
                        locationSpot: go.Spot.Center
                    }
                ];
            }

            // define tooltips for nodes
            var tooltiptemplate =
                $("ToolTip",
                    { "Border.fill": "#FFF8E1", "Border.stroke": "#757575" },
                    $(go.TextBlock,
                        {
                            font: "10pt Shabnam, Tahoma, sans-serif",
                            wrap: go.TextBlock.WrapFit,
                            margin: 5
                        },
                        new go.Binding("text", "", tooltipTextConverter))
                );

            // get tooltip text from the object's data
            function tooltipTextConverter(obj) {
                return obj.detail;
            }


            // Define a function for creating a "port" that is normally transparent.
            // The "name" is used as the GraphObject.portId,
            // the "align" is used to determine where to position the port relative to the body of the node,
            // the "spot" is used to control how links connect with the port and whether the port
            // stretches along the side of the node,
            // and the boolean "output" and "input" arguments control whether the user can draw links from or to the port.
            function makePort(name, align, spot, output, input) {
                var horizontal = align.equals(go.Spot.Top) || align.equals(go.Spot.Bottom);
                // the port is basically just a transparent rectangle that stretches along the side of the node,
                // and becomes colored when the mouse passes over it
                return $(go.Shape,
                    {
                        fill: "transparent",  // changed to a color in the mouseEnter event handler
                        strokeWidth: 0,  // no stroke
                        width: horizontal ? NaN : 8,  // if not stretching horizontally, just 8 wide
                        height: !horizontal ? NaN : 8,  // if not stretching vertically, just 8 tall
                        alignment: align,  // align the port on the main Shape
                        stretch: (horizontal ? go.GraphObject.Horizontal : go.GraphObject.Vertical),
                        portId: name,  // declare this object to be a "port"
                        fromSpot: spot,  // declare where links may connect at this port
                        fromLinkable: output,  // declare whether the user may draw links from here
                        toSpot: spot,  // declare where links may connect at this port
                        toLinkable: input,  // declare whether the user may draw links to here
                        cursor: "pointer",  // show a different cursor to indicate potential link point
                        mouseEnter: function (e, port) {  // the PORT argument will be this Shape
                            if (!e.diagram.isReadOnly)
                                port.fill = "rgba(255,0,255,0.5)";
                        },
                        mouseLeave: function (e, port) {
                            port.fill = "transparent";
                        }
                    });
            }

            function textStyle() {
                return {
                    font: "10pt Shabnam, Tahoma, sans-serif",
                    stroke: "#111",
                    textAlign: "center"

                }
            }
            var greengrad = $(go.Brush, "Linear", { 0: "#fff ", 1: "#1ABC9C" });
            var redgrad = $(go.Brush, "Linear", { 0: "#fff", 1: "#E74C3C " });
            var graygrad = $(go.Brush, "Linear", { 0: "#fff", 1: "#95A5A6" });
            var bluegrad = $(go.Brush, "Linear", { 0: "#fff", 1: "#90CAF9" });
            var bluegrad_ro = $(go.Brush, "Linear", { 0: "#fff", 1: "#ffCAF9" });
            var yellowgrad = $(go.Brush, "Linear", { 0: "#fff", 1: "#F4D03F" });
            var lavgrad = $(go.Brush, "Linear", { 0: "#fff", 1: "#A570AD" });
            var oranggrad = $(go.Brush, "Linear", { 0: "#fff", 1: "#FAD7A0" });

            myDiagram.nodeTemplateMap.add("start",
                $(go.Node, "Table", nodeStyle(),
                    $(go.Panel, "Auto",
                        $(go.Shape, "Circle", { minSize: new go.Size(40, 40), fill: greengrad, stroke: "#777", strokeWidth: 1 }),
                        $(go.TextBlock, "start", textStyle(), new go.Binding("text"))
                    ),
                    // three named ports, one on each side except the top, all output only:
                    makePort("T", go.Spot.Top, go.Spot.Top, false, false),
                    makePort("L", go.Spot.Left, go.Spot.Left, true, false),
                    makePort("R", go.Spot.Right, go.Spot.Right, true, false),
                    makePort("B", go.Spot.Right, go.Spot.Right, true, false),
                    makePort("M", go.Spot.Bottom, go.Spot.Bottom, true, false)

                ));
            myDiagram.nodeTemplateMap.add("sms",
                $(go.Node, "Table",
                    nodeStyle(),
                    { doubleClick: reciver_sms_click },
                    $(go.Panel, "Auto",
                        $(go.Shape, "Border", { minSize: new go.Size(120, 40), fill: graygrad, stroke: "#777", strokeWidth: 1 }),
                        $(go.TextBlock, textStyle(), new go.Binding("text"))
                    ),
                    // three named ports, one on each side except the top, all output only:
                    makePort("T", go.Spot.Top, go.Spot.Top, false, true),
                    makePort("L", go.Spot.Left, go.Spot.Left, false, true),
                    makePort("R", go.Spot.Right, go.Spot.Right, false, true),
                    makePort("B", go.Spot.Bottom, go.Spot.Bottom, false, true),
                    { toolTip: tooltiptemplate }
                ));
            myDiagram.nodeTemplateMap.add("recivers",  // the default category
                $(go.Node, "Table", nodeStyle(), { doubleClick: reciver_click },
                    // the main object is a Panel that surrounds a TextBlock with a rectangular Shape
                    $(go.Panel, "Auto", $(go.Shape, "Rectangle", { minSize: new go.Size(120, 60), fill: bluegrad, stroke: "#777", strokeWidth: 1 }),
                        $(go.TextBlock, "recivers", textStyle(),
                            {

                                margin: 5,
                                maxSize: new go.Size(200, NaN),
                                wrap: go.TextBlock.WrapFit
                            },
                            new go.Binding("text").makeTwoWay())
                    ),
                    // four named ports, one on each side:
                    makePort("T", go.Spot.Top, go.Spot.TopSide, false, true),
                    makePort("L", go.Spot.Left, go.Spot.LeftSide, true, true),
                    makePort("R", go.Spot.Right, go.Spot.RightSide, true, true),
                    makePort("B", go.Spot.Bottom, go.Spot.BottomSide, true, false),
                    { toolTip: tooltiptemplate }
                ));
            myDiagram.nodeTemplateMap.add("recivers_ro",  // the default category
                $(go.Node, "Table", nodeStyle(), { doubleClick: reciver_ro_click },
                    // the main object is a Panel that surrounds a TextBlock with a rectangular Shape
                    $(go.Panel, "Auto", $(go.Shape, "Rectangle", { minSize: new go.Size(120, 60), fill: bluegrad_ro, stroke: "#777", strokeWidth: 1 }),
                        $(go.TextBlock, "recivers_ro", textStyle(),
                            {

                                margin: 5,
                                maxSize: new go.Size(200, NaN),
                                wrap: go.TextBlock.WrapFit
                            },
                            new go.Binding("text").makeTwoWay())
                    ),
                    // four named ports, one on each side:
                    makePort("T", go.Spot.Top, go.Spot.TopSide, false, true),
                    makePort("L", go.Spot.Left, go.Spot.LeftSide, false, true),
                    makePort("R", go.Spot.Right, go.Spot.RightSide, false, true),
                    makePort("B", go.Spot.Bottom, go.Spot.BottomSide, false, true),
                    { toolTip: tooltiptemplate }
                ));

            myDiagram.nodeTemplateMap.add("condition",
                $(go.Node, "Table", nodeStyle(), { doubleClick: condition_click },
                    // the main object is a Panel that surrounds a TextBlock with a rectangular Shape
                    $(go.Panel, "Auto",
                        $(go.Shape, "Diamond", { fill: yellowgrad, stroke: "#777", strokeWidth: 1 }, new go.Binding("figure", "figure")),
                        $(go.TextBlock, textStyle(),
                            {
                                margin: 8,
                                maxSize: new go.Size(160, NaN),
                                wrap: go.TextBlock.WrapFit
                            },
                            new go.Binding("text").makeTwoWay())
                    ),
                    // four named ports, one on each side:
                    makePort("T", go.Spot.Top, go.Spot.Top, false, true),
                    makePort("L", go.Spot.Left, go.Spot.Left, true, true),
                    makePort("R", go.Spot.Right, go.Spot.Right, true, false),
                    makePort("B", go.Spot.Bottom, go.Spot.Bottom, true, false),
                    { toolTip: tooltiptemplate }
                ));


            myDiagram.nodeTemplateMap.add("store",
                $(go.Node, "Table", nodeStyle(),
                    $(go.Panel, "Auto",
                        $(go.Shape, "Ellipse", { minSize: new go.Size(100, 40), fill: oranggrad, stroke: "#777", strokeWidth: 1 }, new go.Binding("figure", "figure")),
                        $(go.TextBlock, "store", textStyle(),
                            new go.Binding("text"))
                    ),
                    // three named ports, one on each side except the top, all output only:
                    makePort("T", go.Spot.Top, go.Spot.Top, false, true),
                    makePort("L", go.Spot.Left, go.Spot.Left, false, true),
                    makePort("R", go.Spot.Right, go.Spot.Right, false, true),
                    makePort("B", go.Spot.Bottom, go.Spot.Bottom, true, false)
                ));

            myDiagram.nodeTemplateMap.add("end",
                $(go.Node, "Table", nodeStyle(),
                    $(go.Panel, "Auto",
                        $(go.Shape, "Circle",
                            { minSize: new go.Size(40, 40), fill: redgrad, stroke: "#777", strokeWidth: 1 }),
                        $(go.TextBlock, "end", textStyle(),
                            new go.Binding("text"))
                    ),
                    // three named ports, one on each side except the bottom, all input only:
                    makePort("T", go.Spot.Top, go.Spot.Top, false, true),
                    makePort("L", go.Spot.Left, go.Spot.Left, false, true),
                    makePort("R", go.Spot.Right, go.Spot.Right, false, true),
                    makePort("B", go.Spot.Bottom, go.Spot.Bottom, false, true)
                ));

            // taken from ../extensions/Figures.js:
            go.Shape.defineFigureGenerator("File", function (shape, w, h) {
                var geo = new go.Geometry();
                var fig = new go.PathFigure(0, 0, true); // starting point
                geo.add(fig);
                fig.add(new go.PathSegment(go.PathSegment.Line, .75 * w, 0));
                fig.add(new go.PathSegment(go.PathSegment.Line, w, .25 * h));
                fig.add(new go.PathSegment(go.PathSegment.Line, w, h));
                fig.add(new go.PathSegment(go.PathSegment.Line, 0, h).close());
                var fig2 = new go.PathFigure(.75 * w, 0, false);
                geo.add(fig2);
                // The Fold
                fig2.add(new go.PathSegment(go.PathSegment.Line, .75 * w, .25 * h));
                fig2.add(new go.PathSegment(go.PathSegment.Line, w, .25 * h));
                geo.spot1 = new go.Spot(0, .25);
                geo.spot2 = go.Spot.BottomRight;
                return geo;
            });

            myDiagram.nodeTemplateMap.add("comment",
                $(go.Node, "Auto", nodeStyle(),
                    $(go.Shape, "File", { fill: "#FFF59D", stroke: "#777", strokeWidth: 1 }),
                    $(go.TextBlock, textStyle(),
                        {
                            margin: 5,
                            maxSize: new go.Size(200, NaN),
                            wrap: go.TextBlock.WrapFit,
                            textAlign: "center",
                            editable: true,
                            font: "10pt shabnam, Arial, sans-serif",
                            stroke: '#222'
                        },
                        new go.Binding("text").makeTwoWay())
                    // no ports, because no links are allowed to connect with a comment
                ));


            // replace the default Link template in the linkTemplateMap
            myDiagram.linkTemplate =
                $(go.Link,  // the whole link panel
                    {
                        routing: go.Link.AvoidsNodes,
                        curve: go.Link.JumpOver,
                        corner: 5, toShortLength: 4,
                        relinkableFrom: true,
                        relinkableTo: true,
                        reshapable: true,
                        resegmentable: true,
                        // mouse-overs subtly highlight links:
                        mouseEnter: function (e, link) { link.findObject("HIGHLIGHT").stroke = "rgba(30,144,255,0.2)"; },
                        mouseLeave: function (e, link) { link.findObject("HIGHLIGHT").stroke = "transparent"; },
                        selectionAdorned: false
                    },
                    new go.Binding("points").makeTwoWay(),
                    $(go.Shape,  // the highlight shape, normally transparent
                        { isPanelMain: true, strokeWidth: 8, stroke: "transparent", name: "HIGHLIGHT" }),
                    $(go.Shape,  // the link path shape
                        { isPanelMain: true, stroke: "gray", strokeWidth: 2 },
                        new go.Binding("stroke", "isSelected", function (sel) { return sel ? "dodgerblue" : "gray"; }).ofObject()),
                    $(go.Shape,  // the arrowhead
                        { toArrow: "standard", strokeWidth: 0, fill: "gray" }),
                    $(go.Panel, "Auto",  // the link label, normally not visible
                        {
                            visible: false,
                            name: "LABEL",
                            segmentIndex: 2,
                            segmentFraction: 0.5
                        },
                        new go.Binding("visible", "visible").makeTwoWay(),
                        $(go.Shape, "RoundedRectangle",  // the label shape
                            {
                                fill: "#01F8F8",
                                strokeWidth: 0.3
                            }),
                        $(go.TextBlock, ".....",  // the label
                            {
                                textAlign: "center",
                                font: "10pt helvetica, arial, sans-serif",
                                stroke: "#ff3333",
                                editable: true
                            },
                            new go.Binding("text").makeTwoWay())
                    )
                );

            // Make link labels visible if coming out of a "conditional" node.
            // This listener is called by the "LinkDrawn" and "LinkRelinked" DiagramEvents.
            function showLinkLabel(e) {
                var label = e.subject.findObject("LABEL");
                if (label !== null) {
                    label.visible = (e.subject.fromNode.data.category === "condition");
                }
            }

            // temporary links used by LinkingTool and RelinkingTool are also orthogonal:
            myDiagram.toolManager.linkingTool.temporaryLink.routing = go.Link.Orthogonal;
            myDiagram.toolManager.relinkingTool.temporaryLink.routing = go.Link.Orthogonal;
            // load an initial diagram from some JSON text
            myDiagram.model = go.Model.fromJson("{\"class\":\"go.GraphLinksModel\",\"linkFromPortIdProperty\":\"fromPort\",\"linkToPortIdProperty\":\"toPort\",\"nodeDataArray\":[],\"linkDataArray\":[]}");


            // initialize the Palette that is on the left side of the page
            myPalette =
                $(go.Palette, "myPaletteDiv",  // must name or refer to the DIV HTML element
                    {
                        nodeTemplateMap: myDiagram.nodeTemplateMap,  // share the templates used by myDiagram
                        model: new go.GraphLinksModel([  // specify the contents of the Palette
                            { category: "start", text: "شروع", value: "", detail: "" },
                            { category: "sms", text: "ارسال پیامک", value: "", detail: "" },
                            { category: "recivers", text: "تائید کننده", value: "", detail: "" },
                            { category: "recivers_ro", text: "جهت اطلاع", value: "", detail: "" },
                            { category: "condition", text: "شرط", value: "", detail: "" },
                            { category: "store", text: "اعمال و پایان", value: "", detail: "" },
                            //{ category: "end", text: "پایان", value: "", detail: "" },
                            { category: "comment", text: "یادداشت", value: "", detail: "" }
                        ])
                    });



            refresh();

        } // end init


        function refresh() {


            myDiagram.model = go.Model.fromJson(model);
        }

        var cur_obj;
        function add_personel(obj) {
            cur_obj = obj;
            open_form_('../../page/personnel/page_personnel_select.aspx', 'انتخاب افراد', "", "add_ok");
        }
        function add_ok(d) {

            if ($('#tbl_' + cur_obj + ' tbody tr').length > 0)
                confirm_alert_msg("آیا مایلید افراد انتخاب شده با لیست فعلی جایگزین گردد", function () { add_to_tbl(true); }, function () { add_to_tbl(false); });
            else
                add_to_tbl(true);


        }
        function add_to_tbl(replace_) {
            reqsvr("load_list", "data:'" + parent.sel_obj + "'", function (data) {
                if (replace_)
                    load_tbl_chb(data.d, cur_obj);
                else
                    append_tbl_chb(data.d, cur_obj);
                tbl_set_check('#tbl_' + cur_obj, true);
                if (cur_obj == "assign")
                    $("#chb_all").prop('checked', false);

            });

        }
        function chb_all_click() {
            if ($("#chb_all")[0].checked)
                $("#chb_admin").prop('checked', false);
        }
        function chb_admin_click() {
            
            if ($("#chb_admin")[0].checked) {
                
                $("#chb_not_admin").prop('checked', false);
            }
        }
        function chb_not_admin_click() {
            if ($("#chb_not_admin")[0].checked) {
                $("#chb_admin").prop('checked', false);
            }
        }

        function set_value(txt, val, det = "") {
            myDiagram.model.setDataProperty(cur_node.data, "text", txt);
            myDiagram.model.setDataProperty(cur_node.data, "value", val);
            myDiagram.model.setDataProperty(cur_node.data, "detail", det);
        }
        var ecode;
        function save() {
            var new_model = myDiagram.model.toJson();
            $("#mySavedModel").val(new_model);
            var assign = get_checked('#tbl_assign');

            reqsvr("save",
                "code:" + ecode +
                ",name:'" + $("#tb_name").val() +
                "',detail:'" + $("#tb_detail").val() +
                "',disable:'" + $("#chb_disable")[0].checked +
                "',model:'" + new_model +
                "',request:'" + get_checked('#tbl_request') +
                "',assign:'" + $("#chb_all").is(':checked') + "☺" + assign + "☺" + $("#chb_and_assign").is(':checked') + "☺" + $("#chb_admin").is(':checked') +
                "',unassign:'" + get_checked('#tbl_unassign') + "☺" + $("#chb_and_unassign").is(':checked') + "☺" + $("#chb_not_admin").is(':checked') +
                "'",
                function (data) {
                    if (data.d == "ok") {
                        alert_message("ذخیره شد");
                        call_fnc();
                        close();
                    }
                    else
                        alert_error(data.d);
                });
            myDiagram.isModified = false;
        }
    </script>
</head>
<body>
    <form>
        <div class="pad5">
            <table class="w-full">
                <tr>
                    <td class="w-100"><span>عنوان :</span></td>
                    <td class="w-300">
                        <input id="tb_name" class="form-control" type="text" />
                    </td>
                    <td>
                        <input id="chb_disable" class="form-control" type="checkbox" /><span>غیر فعال</span>
                    </td>
                </tr>
                <tr>
                    <td><span>توضیحات :</span></td>
                    <td colspan="2">
                        <input id="tb_detail" class="form-control" type="text" /></td>
                </tr>
            </table>
        </div>
        <ul class="nav nav-tabs ">
            <li class="active"><a data-toggle="tab" href="#tab_1" onclick="initial()"><span class="fa fa-cogs">&nbsp;</span>مشاهده روند</a></li>
            <li><a data-toggle="tab" href="#tab_2"><span class="fa fa-envelope">&nbsp;</span>انتخاب درخواست ها</a></li>
            <li><a data-toggle="tab" href="#tab_3"><span class="fa fa-users">&nbsp;</span>انتصاب به افراد</a></li>

        </ul>
        <div class="tab-content">
            <div id="tab_1" class="tab-pane fade in active pad5">
                <div class="row auto-height" dir="ltr" style="width: 100%; display: flex; justify-content: space-between">
                    <div id="myPaletteDiv" style="height: 100%; width: 150px; margin-left: 2px; background-color: #eee; border: solid 1px black"></div>
                    <div id="myDiagramDiv" style="height: 100%; flex-grow: 1; border: solid 1px black"></div>
                </div>
            </div>
            <div id="tab_2" class="tab-pane fade pad5">

                <div id="div_request" class="panel auto-height">
                </div>
            </div>
            <div id="tab_3" class="tab-pane fade pad5">
                <table class="w-full">
                    <tr>
                        <td colspan="2" class="w-half bgr"><span>لیست منتخب</span></td>
                        <td colspan="2" class="w-half bgg"><span>باستثناء</span></td>
                    </tr>
                    <tr>
                        <td class="bgr">
                            <input id="chb_all" type="checkbox" class="form-control" value="همه پرسنل" onchange="chb_all_click()" />&nbsp;<span>همه پرسنل</span>
                        </td>
                        <td class="bgr">
                            <input id="chb_admin" type="checkbox" class="form-control" value="فقط مسئولین" onchange="chb_admin_click()" />&nbsp;<span>فقط مسئولین</span>
                        </td>
                        <td class="bgg">
                            <input id="chb_not_admin" type="checkbox" class="form-control" value="مسئولین" onchange="chb_not_admin_click()" />&nbsp;<span>مسئولین</span>
                        </td>

                        <td class="bgg"></td>
                    </tr>
                    <tr>
                        <td class="w-quarter bgr">
                            <button onclick="add_personel('assign')" type="button" class="btn btn-primary "><span class="glyphicon glyphicon-user"></span>&nbsp;انتخاب پرسنل</button>

                        </td>
                        <td class="w-quarter bgr">
                            <input id="chb_and_assign" type="checkbox" class="form-control hide" value="گروهها با هم AND شوند" />&nbsp;<span>گروهها با هم AND شوند</span></td>
                        <td class="w-quarter bgg">
                            <button onclick="add_personel('unassign')" type="button" class="btn btn-primary "><span class="glyphicon glyphicon-user"></span>&nbsp;انتخاب پرسنل</button>
                        </td>
                        <td class="w-quarter bgg">
                            <input id="chb_and_unassign" type="checkbox" class="form-control hide" value="گروهها با هم AND شوند" />&nbsp;<span>گروهها با هم AND شوند</span></td>
                    </tr>
                    <tr>
                        <td colspan="2" class="bgr">
                            <div id="div_assign" class="auto-height bg-green-light">
                            </div>
                        </td>
                        <td colspan="2" class="bgg">
                            <div id="div_unassign" class="auto-height bg-red-light">
                            </div>
                        </td>
                    </tr>
                </table>
            </div>

        </div>

        <textarea id="mySavedModel" class="hide" dir="ltr" style="width: 100%; height: 300px"> </textarea>

        <div class="toolbar-footer">
            <button type="button" onclick="save()" class="btn btn-success  ">ذخیره</button>
        </div>
    </form>
</body>
</html>
