﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_user_reciver.aspx.cs" Inherits="TimeWork.page_user_reciver" EnableSessionState="True" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script type="text/javascript" src="../../script/jquery-ui.min.js"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>

    <script> 
        $(document).ready(function () {
            var array = initial_tab();
            initial_cb_personel("#cb_personel");
            load_personel();
            $("#cb_personel").on('changed.bs.select',
                function (e, clickedIndex, newValue, oldValue) {
                    load_personel($(e.currentTarget).val());
                });
            load();
        });
        function load() {
            reqsvr("load", "", function (data) {
                load_cb("#cb_reciver", data.d[0]);
                load_sender();
                if (data.d[1] == "1") {
                    alert_message("در حال حاضر ماژول گردش کار فعال است و این صفحه فقط نمایشی است");
                }
                $("#cb_reciver").on('changed.bs.select',
                    function (e, clickedIndex, newValue, oldValue) {
                        load_sender($(e.currentTarget).val());
                    });
            });


        }

        function load_personel(id) {
            if (id == undefined) id = $("#cb_personel").val();
            if (id == null) return;

            reqsvr("load_reciver", "code:" + id,
                function (data) {

                    load_tbl_btn(data.d, 'reciver');


                });
        }
        function load_sender(id) {
            if (id == undefined) id = $("#cb_reciver").val();
            if (id == null) return;
            reqsvr("load_sender", "code:" + id,
                function (data) {
                    for (var i = 0; i < 6; i++) {
                        if (data.d[i] == "0") data.d[i] = "";
                        else data.d[i] = "(" + data.d[i] + ")";

                        btn_by_chb = true;
                        $("[href='#tab_level" + + (i + 1).toString() + "'] span").html(data.d[i]);

                        load_tbl_btn(data.d[6 + i], 'level' + (i + 1).toString());
                        //set_datatable("#tbl_level" + (i + 1).toString());
                    }

                });
        }
        var cur_level = 0;
        function delete_level1(e) { delete_sender(e); }
        function delete_level2(e) { delete_sender(e); }
        function delete_level3(e) { delete_sender(e); }
        function delete_level4(e) { delete_sender(e); }
        function delete_level5(e) { delete_sender(e); }
        function delete_level6(e) { delete_sender(e); }
        function delete_multi_level1(e) { delete_multi_sender(e); }
        function delete_multi_level2(e) { delete_multi_sender(e); }
        function delete_multi_level3(e) { delete_multi_sender(e); }
        function delete_multi_level4(e) { delete_multi_sender(e); }
        function delete_multi_level5(e) { delete_multi_sender(e); }
        function delete_multi_level6(e) { delete_multi_sender(e); }
        function new_level1() { new_sender( ); }
        function new_level2() { new_sender( ); }
        function new_level3() { new_sender( ); }
        function new_level4() { new_sender( ); }
        function new_level5() { new_sender( ); }
        function new_level6() { new_sender( ); }
        function edit_level1(e) { edit_sender(e); }
        function edit_level2(e) { edit_sender(e); }
        function edit_level3(e) { edit_sender(e); }
        function edit_level4(e) { edit_sender(e); }
        function edit_level5(e) { edit_sender(e); }
        function edit_level6(e) { edit_sender(e); }

        function new_() {

            open_form_('../../page/user/page_user_sender_new.aspx', 'تعیین مسئول جدید', '-1&-1&' + $("#ul_tab .active").attr("value"), "load");
        }
        function change_() {
            open_form_('../../page/user/page_user_change_reciver.aspx', 'تغییر مسئول', $("#cb_reciver").val(), "load");
        }
        function new_sender() {
             open_form_('../../page/user/page_user_sender_new.aspx', 'تعیین تائید شونده جدید برای ' + $("#cb_reciver option:selected").text(), $("#cb_reciver").val() + '&-1&' + $("#ul_tab .active").attr("value"), "load_sender");
        }
        function edit_sender(e) {
            open_form_('../../page/user/page_user_sender_new.aspx', 'ویرایش تائید شونده برای ' + $("#cb_reciver option:selected").text(), $("#cb_reciver").val() + '&' + $(e).closest('tr').attr("code") + '&' + $("#ul_tab .active").attr("value"), "load_sender");
        }
        function new_reciver() {
            open_form_('../../page/user/page_user_reciver_new.aspx', 'تعیین تائید کننده جدید برای ' + $("#cb_personel option:selected").text(), $("#cb_personel").val() + '&-1', "load_personel");
        }

        function edit_reciver(e) {
            open_form_('../../page/user/page_user_reciver_new.aspx', 'ویرایش تائید کننده برای ' + $("#cb_personel option:selected").text(), $("#cb_personel").val() + '&' + $(e).closest('tr').attr("code"), "load_personel");
        }

        function delete_sender(e) {
            confirm_alert(function () {
                reqsvr("delete_sender",
                    "code:" + $(e).closest('tr').attr("code"),
                    function (data) {
                        if (data.d == "ok") {
                            load_sender();
                        }
                        else
                            alert_message(data.d);
                    });
            });
        }
        function delete_multi_sender(e) {
            var id_ = $(e).closest('.dataTables_scrollHead').next('.dataTables_scrollBody').children('table').attr('id');

            var code = get_checked("#" + id_);
            if (code == "") {
                alert_error("هیچ شخصی انتخاب نشده است");
                return;
            }
            confirm_alert(function () {
                reqsvr("delete_sender", "code:'" + code + "'",
                    function (data) {
                        if (data.d == "ok") {
                            load_sender();
                        }
                        else
                            alert_message(data.d);
                    });
            });
        }

        function delete_reciver(e) {
            confirm_alert(function () {
                reqsvr("delete_reciver",
                    "code:" + $(e).closest('tr').attr("code"),
                    function (data) {
                        if (data.d == "ok") {
                            load_personel();
                        }
                        else
                            alert_message(data.d);
                    });
            });
        }
    </script>

</head>
<body>
    <form>

        <div id="tabs1" class=" auto_size_tab">
            <ul class="nav nav-tabs ">
                <li class="active"><a data-toggle="tab" href="#tab_o"><span class="glyphicon glyphicon-import">&nbsp;</span>لیست افراد تائید کننده</a></li>
                <li><a data-toggle="tab" href="#tab_i"><span class="glyphicon glyphicon-export">&nbsp;</span>لیست افراد تائید شونده</a></li>

            </ul>
            <div class="tab-content">
                <div id="tab_o" class="tab-pane fade  in active">
                    <div class="pad5 bg-menu">
                        <span>انتخاب مسئول(مدیر) : </span>
                        <select id="cb_reciver" class="selectpicker" data-width="300px" data-size="10" data-live-search="true">
                        </select>
                        <button type="button" title="مسئول جدید" class="btn btn-primary" onclick="new_()">
                            <span class=" glyphicon glyphicon-plus"></span>
                            مسئول جدید
                        </button>
                        <button type="button" title="تغییر مسئول" class="btn btn-primary" onclick="change_()">
                            <span class=" glyphicon glyphicon-refresh"></span>
                            تغییر مسئول
                        </button>
                    </div>
                    <div id="tabs2" class="auto-height auto_size_tab no-scroll">
                        <ul id="ul_tab" class="nav nav-tabs ">
                            <li value="1" class="active"><a data-toggle="tab" href="#tab_level1">سطح اول <span></span></a></li>
                            <li value="2"><a data-toggle="tab" href="#tab_level2">سطح دوم  <span></span></a></li>
                            <li value="3"><a data-toggle="tab" href="#tab_level3">سطح سوم  <span></span></a></li>
                            <li value="4"><a data-toggle="tab" href="#tab_level4">سطح چهارم  <span></span></a></li>
                            <li value="5"><a data-toggle="tab" href="#tab_level5">سطح پنجم  <span></span></a></li>
                            <li value="6"><a data-toggle="tab" href="#tab_level6">نهایی (جهت اطلاع)  <span></span></a></li>

                        </ul>

                        <div class="tab-content">
                            <div id="tab_level1" class="tab-pane fade in active">
                                <div id="div_level1" class="auto-height no-scroll">
                                </div>
                            </div>
                            <div id="tab_level2" class="tab-pane fade ">
                                <div id="div_level2" class="auto-height no-scroll">
                                </div>
                            </div>
                            <div id="tab_level3" class="tab-pane fade ">
                                <div id="div_level3" class="auto-height no-scroll">
                                </div>
                            </div>
                            <div id="tab_level4" class="tab-pane fade ">
                                <div id="div_level4" class="auto-height no-scroll">
                                </div>
                            </div>
                            <div id="tab_level5" class="tab-pane fade ">
                                <div id="div_level5" class="auto-height no-scroll">
                                </div>
                            </div>
                            <div id="tab_level6" class="tab-pane fade ">
                                <div id="div_level6" class="auto-height no-scroll">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="tab_i" class="tab-pane fade">
                    <div class="bg-menu pad5">
                        <div id="personel_list" class="btn-group-div">
                            <span>انتخاب پرسنل : </span>

                            <button type="button" title="نفر قبلی" class="btn glyphicon glyphicon-chevron-right" style="margin-left: -2px; margin-top: -3px; border-bottom-left-radius: 0; border-top-left-radius: 0;"
                                onclick="prev_person()">
                            </button>
                            <select id="cb_personel" class="selectpicker  " data-width="300px" data-size="10" data-live-search="true">
                            </select>
                            <button type="button" title="نفر بعدی" class="btn glyphicon glyphicon-chevron-left" style="margin-right: -3px; margin-top: -3px; border-bottom-right-radius: 0; border-top-right-radius: 0;"
                                onclick="next_person()">
                            </button>
                        </div>
                    </div>
                    <div id="div_reciver" class="auto-height  no-scroll  ">
                    </div>

                </div>
            </div>
        </div>
    </form>
</body>
</html>
