﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_time_day.aspx.cs" Inherits="TimeWork.page_time_day"
    EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>

    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/contextMenu/bootstrap-contextmenu.css" rel="stylesheet" />
    <link href="../../style/timepicker/bootstrap-clockpicker.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script  src="../../script/jquery.min.js"  type="text/javascript" ></script>
    <script  src="../../style/bootstrap/bootstrap.min.js"  type="text/javascript" ></script>
    <script  src="../../style/select/bootstrap-select.js"  type="text/javascript" ></script>
    <script  src="../../style/calendar/js-persian-cal.min.js"  type="text/javascript" ></script>
     
    <script  src="../../style/mask/jquery.mask.min.js"  type="text/javascript" ></script>
    <script  src="../../style/contextMenu/bootstrap-contextmenu.js"  type="text/javascript" ></script>
    <script  src="../../script/fnc.js"  type="text/javascript" ></script>
    <script > 
        $(document).ready(function () {
             initial_date_ok = true;
            var ar = initial_tab();
            initial_date_mask();
            var objCal1 = new PesianDate.persianCalendar('tb_date', {
                onchange: function (e) {
                    if ($('#tb_date').val() == "") return;
                    load_day(0);
                }
            });
            reqsvr("load", "", function (data) {
                $("#tb_date").val(data.d);
                load_day(0);
            });
            unwait_();
        });

        function load_day(np) {
            reqsvr("load_day", "date:'" + $("#tb_date").val() + "',np:" + np, function (data) {
                $("#tb_date").val(data.d[0]);
                $("#lb_day").html(data.d[1]);
                $("#lb_count").html(data.d[2]);
                $("#cb_filter").html(data.d[3]);
                $("#div_time").html(data.d[4]); 
                $('#tbl_time').addClass("tableFixHead");
                $('#tbl_time td').contextmenu({ target: '#cmenu', onItem: function (obj, e) { } });
                $('#cmenu').on('show.bs.context', function (e) {
                    shrow = $(e.target).attr("row");
                    sprow = $(e.target).parent().attr("prow");
                    sname = $(e.target).parent().find("td:eq(1)").text();
                    changecolor($(e.target));
                });
                $("#tbl_time td").hover(
                    function () {
                        $(this).css('background-color', '#ff0')
                    }, function () {
                        $(this).css('background-color', '')
                    });
                $("#tbl_time td").dblclick(function () {
                    shrow = $(this).attr("row");
                    sprow = $(this).parent().attr("prow");
                    sname = $(this).parent().find("td:eq(1)").text();
                    if (shrow == '-1' || shrow == undefined)
                        add_();
                    else
                        edit_();
                });
            });
        }

        function add_() {
            open_form_("../../page/time/page_time_new.aspx", sname, sprow + '&0&' + $("#tb_date").val(), 'refresh_row');
        }
        function edit_() {
            if (shrow == '-1' || shrow == undefined) return;

            open_form_("../../page/time/page_time_new.aspx", sname, sprow + '&' + shrow, 'refresh_row');
        }
        function delete_() {
            if (shrow == '-1' || shrow == undefined) return;
            open_form_("../../page/time/page_delete_time.aspx", sname, sprow + '&' + shrow, 'refresh_row');
        }
        var shrow;
        var sprow;
        var sname;

        function changecolor(a) {
            //$('[id^=curtr]').css("background-color", "#ECECEC");
            //$('.SelectRadio:checked').closest('tr').css("background-color", "");
            $('.select').removeClass('select');
            $(a).addClass('select');

        }


        function refresh_row() {
            reqsvr("load_prow", "date:'" + $("#tb_date").val() + "',prow:" + sprow,
                function (data) {
                    $("tr[prow='" + sprow + "']").html(data.d);
                    $('#tbl_time td').contextmenu({ target: '#cmenu', onItem: function (obj, e) { } });

                    $("#tbl_time td").hover(
                        function () {
                            $(this).css('background-color', '#ff0')
                        }, function () {
                            $(this).css('background-color', '')
                        });
                    $("#tbl_time td").unbind('dblclick');
                    $("#tbl_time td").dblclick(function () {
                        shrow = $(this).attr("row");
                        sprow = $(this).parent().attr("prow");
                        sname = $(this).parent().find("td:eq(1)").text();
                        if (shrow == '-1' || shrow == undefined)
                            add_();
                        else
                            edit_();
                    });
                });
        }

        function pre_day() {
            load_day(-1);
        }

        function next_day() {
            load_day(1);
        }

        function search() {
            var value = $("#tb_search").val().toLowerCase();
            $("#tbl_time tbody tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        }
        function filter() {
            var value = $("#cb_filter").val();
            if (value == "all") {
                $("#tbl_time tbody tr").show();
                $("#tbl_time tbody tr td").removeClass('select');

            }
            else
                if (value == "del") {
                    $("#tbl_time tbody tr").hide();
                    $("#tbl_time tbody tr td").removeClass('select');
                    $("#tbl_time tbody tr td[row='-1']").parent().show();
                    $("#tbl_time tbody tr td[row='-1']").addClass('select');

                }
                else {
                    $("#tbl_time tbody tr").hide();
                    $("#tbl_time tbody tr td").removeClass('select');
                    $("#tbl_time tbody tr td[plc='" + value + "']").parent().show();
                    $("#tbl_time tbody tr td[plc='" + value + "']").addClass('select');
                }
        }

    </script>
</head>
<body>
    <form>
        <div class="bg-menu  align-center h-40">
            <div class="btn-group-div">

                <button type="button" title="روز قبلی" class="btn glyphicon glyphicon-chevron-right" style="border-bottom-left-radius: 0; border-top-left-radius: 0;"
                    onclick="pre_day()">
                </button>
                <span>تاریخ : </span>
                <input id="tb_date" class="form-control date w-100" />
                <button type="button" title="روز بعدی" class="btn glyphicon glyphicon-chevron-left" style="border-bottom-right-radius: 0; border-top-right-radius: 0;"
                    onclick="next_day()">
                </button>
                <span id="lb_day" style="padding-right: 5px"></span>
            </div>

        </div>
        <div class="h-40 pad5">
            <span>جستجو :</span> 
            <input type="text" id="tb_search" class="form-control w-300" onkeyup="search()" placeholder="جستجو با شماره و یا نام پرسنل" maxlength="50" />

            <span>دستگاه :</span> 
            <select id="cb_filter" onchange="filter()" class="form-control w-300">
            </select>

        </div> 
        <div id="div_time" class="auto-height ofy-scroll ">
        </div>
        <div class="footer   pad5">
            <span>تعداد کل :</span>
            <span id="lb_count"></span>
        </div> 
        <div id="cmenu">
            <ul class="nav dropdown-menu">
                <li><a href="#" onclick="add_()"><span>&nbsp;</span>ثبت تردد</a></li>
                <li><a href="#" onclick="edit_()"><span>&nbsp;</span>ویرایش تردد</a></li>
                <li><a href="#" onclick="delete_()"><span>&nbsp;</span>حذف تردد</a></li>
            </ul>
        </div>
    </form>
</body>
</html>
