﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_change_time.aspx.cs" Inherits="TimeWork.page_change_time"
    EnableSessionState="True" %>

<%@ Register Src="~/user control/wuc_personnel_select.ascx" TagPrefix="uc1" TagName="wuc_personnel_select" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>

    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/spinner/jquery-spinner.css" rel="stylesheet" />
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/mask/jquery.mask.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/spinner/jquery-spinner.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script src="../../script/FncDate.js" type="text/javascript"></script>
    <script>  

        $(document).ready(function () {
            initial_page(800, 600);
            initial_time();
            unwait_();
        });

        function search() {

            $("#progress_bar").parent().addClass("hide");

            var data = get_data_div("#div_main");
            reqsvr("search", "data:'" + data + "'",
                function (data) {
                    if (data.d[0] == "ok") {
                        orderable = false;

                        load_tbl_chb(data.d[1], 'result', 'row');
                       load_cb('#cb_device', data.d[2]);
                        $("#tbl_result_filter").addClass("hide");
                        $("#btn_save").prop('disabled', false);

                    }
                    else {
                        alert_error(data.d[0]);
                    }
                }
            );
        }

        function device_change(obj) {
            $('#tbl_result')
                .DataTable()
                .column(6)
                .search(obj.value)
                .draw();

        } var cnt_all = 0;
        function save_() {
            $("#progress_bar").css("width", "0px");
            $("#progress_bar").parent().removeClass("hide");

            cnt_all = $('#tbl_result tbody input:checked').length;
            reqsvr("save", "rows:'" + get_table_checked('#tbl_result') + "',lenght:'" + $("#lenght").val() + "',kind:'" + $("input[name='rdo_kind']:checked").val() + "'",
                function (data) {

                    if (data.d == "ok") {

                        $("#btn_save").prop('disabled', true);
                    }
                    else {
                        alert_error(data.d);
                    }
                }
            );
            $("#btn_stop").prop('disabled', false);
            updateProgress();
        }

        function stop_() {
            reqsvr("StopProgress", "", function (data) {
                $("#btn_stop").prop('disabled', true);
            });
        }
        function updateProgress() {
            reqsvr2("GetProgress", "", function (data) {
                $("#progress_bar").css("width", data.d[0] + "%");
                if (data.d[0] != "-1")
                    $("#progress_bar").html(data.d[1] + " / " + cnt_all);
                if (data.d[0] == "-1" || data.d[0] == "100") {
                    if (data.d[1] != "0")
                        alert_message("عملیات برای " + data.d[1] + " مورد انجام شد");

                    return;
                }

                statusTimerID = setTimeout(updateProgress, 100);

            });
        }
    </script>
</head>
<body>
    <form>
        <div id="div_main" class="panel   pad5">

            <div class="row">
                <div class="col-sm-6">
                    <label>از تاریخ :</label>
                    <input id="sd1" type="text" name="sdate" class="form-control date" value="1401/02/01" />
                    &nbsp;&nbsp;&nbsp; &nbsp; 
                    <label>از ساعت :</label>
                    <input name="stime" type="text" class="form-control time" value="00:00" />
                </div>
                <div class="col-sm-6">
                    <label>تا تاریخ :</label>
                    <input id="ed1" type="text" name="edate" class="form-control date" value="1401/02/01" />
                    &nbsp;&nbsp;&nbsp;&nbsp; 
                    <label>تا ساعت :</label>
                    <input name="etime" type="text" class="form-control time" value="23:59" />
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <input name="manual" type="checkbox" class="form-control" />&nbsp;<label>ساعات دستی هم جستجو شود</label>
                </div>
                <div class="col-sm-6">
                    <button type="button" onclick="search()" class="btn btn-primary float-left w-100"><span class="glyphicon glyphicon-search"></span>جستجو</button>
                </div>
            </div>
        </div>
        <div class="row pad5">
            <div class="col-sm-6">
                <label>محل :</label>
                <select id="cb_device" class="form-control w-300" onchange="device_change(this)"></select>
            </div>
            <div class="col-sm-6">
            </div>
        </div>
        <div class="row pad5 panel">
            <div class="col-sm-3">
                <label>مدت :</label>
                <input id="lenght" type="text" class="form-control time" value="00:00" />
            </div>
            <div class="col-sm-3">
                <div class="row ">
                    <input type="radio" name="rdo_kind" value="0" checked class="form-control" />
                    <label>به جلو</label>
                    <input type="radio" name="rdo_kind" value="1" class="form-control" />
                    <label>به عقب</label>

                </div>
            </div>
            <div class="col-sm-4">
                <div class="progress  h-25 hide">
                    <div id="progress_bar" class="progress-bar " role="progressbar" aria-valuenow="70"
                        aria-valuemin="0" aria-valuemax="100" style="width: 0%">
                        0%
                    </div>
                    <button id="btn_stop" type="button" onclick="stop_()" class="btn btn-danger" title="توقف" disabled="disabled"><span class="glyphicon glyphicon-remove"></span></button>
                </div>
            </div>
            <div class="col-sm-2">
                <button id="btn_save" type="button" onclick="save_()" class="btn btn-success float-left w-100  " disabled="disabled"><span class="glyphicon glyphicon-save"></span>اجرا</button>
            </div>
        </div>
        <div id="div_result" class="auto-height no-scroll"></div>


    </form>
</body>
</html>
