﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_group.aspx.cs" Inherits="TimeWork.page_group" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>

    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/bootstrap-editable/bootstrap-editable.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/bootstrap-editable/bootstrap-editable.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>  
        $(document).ready(function () {
            initial_page(600, 600);

            load_group_kind();
            $.fn.editable.defaults.mode = 'inline';
        });
        function new_group() {
            var elt = document.getElementById('cb_group_kind');
            if (elt.selectedIndex == -1)
                return "";
            show_input_alert('ایجاد گروه جدید در دسته بندی ' + elt.options[elt.selectedIndex].text, '',
                function (v) {
                    reqsvr("save_group", "group_kind_id:" + $('#cb_group_kind').val() + ",name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {

                                load_group($('#cb_group_kind').val());
                            }
                            else
                                alert_error(data.d);
                        });
                });
        }

        function new_group_kind() {

            show_input_alert('ثبت دسته بندی گروه', '',
                function (v) {
                    reqsvr("save_group_kind", "name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {

                                load_group_kind();
                            }
                            else
                                alert_error(data.d);
                        });
                });
        }
        function edit_group_kind() {
            var elt = document.getElementById('cb_group_kind');
            if (elt.selectedIndex == -1)
                return "";

            show_input_alert('ویرایش دسته بندی گروه', elt.options[elt.selectedIndex].text,
                function (v) {
                    reqsvr("edit_group_kind", "code:" + $('#cb_group_kind').val() + ",name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {

                                load_group_kind();
                            }
                            else
                                alert_error(data.d);
                        });
                });
        }

        function delete_group_kind() {

            confirm_alert(function () {

                reqsvr("delete_group_kind", "code:" + $('#cb_group_kind').val(),
                    function (data) {
                        if (data.d == "ok") {
                            load_group_kind();
                        }
                        else
                            alert_error(data.d);
                    });
            });
        }

        function load_group_kind() {


            reqsvr("load", "", function (data) {
                load_cb("#cb_group_kind", data.d);
                try {
                    //document.getElementById("cb_group_kind").options[0].selected = true;
                    //$('.selectpicker').selectpicker('render');
                    //$('.selectpicker').selectpicker('refresh');
                    load_group($("#cb_group_kind").val());
                } catch{ }

            });

            $("#cb_group_kind").on('changed.bs.select',
                function (e, clickedIndex, newValue, oldValue) {
                    var code = $(e.currentTarget).val();
                    load_group(code);
                });
        }

        function delete_group(th) {

            
            confirm_alert(function () {
                reqsvr("delete_group", "code:" + $(th).attr("group_id"),
                    function (data) {
                        if (data.d == "ok") {
                            $(th).closest('tr').remove();
                        }
                        else
                            alert_error(data.d);
                    });
            });

        }
        function load_group(code) {
            if (code == undefined) return;
            reqsvr("load_group", "code:" + code, function (data) {
                var headers = [];
                headers.push('<thead ><tr>');
                headers.push('<th class="w-100"><span>کد</span></th>');
                headers.push('<th><span>عنوان</span></th>');
                headers.push('<th  class="w-50"><button onclick="new_group()" class="btn btn-info glyphicon glyphicon-plus" type="button" title="اضافه جدید"   /></button > </th>');
                headers.push('</tr></thead>');
                var rows = [];
                rows.push('<tbody>');

                $(data.d).find("group").each(function () {
                    rows.push('<tr>');
                    rows.push('<td> ' + $(this).find('code').text() + ' </td>');
                    rows.push('<td><a href="#" class="editable"  group_id="' + $(this).find('code').text() + '">' + $(this).find('name').text() + '</a></td>');
                    rows.push('<td style="padding: 1px; text-align: center;">');
                    rows.push('<button onclick="delete_group(this)" class="btn btn-danger glyphicon glyphicon-trash " type="button" title="حذف" group_id="' + $(this).find('code').text() + '" /></button >');
                    rows.push('</td></tr>');
                });
                rows.push('</tbody>');
                var top = '<table    class="table table-bordered table-hover  ">';
                var bottom = '</table>';
                $('#dgv_groups').html(top + headers.join("") + rows.join("") + bottom);

                $('.editable').editable({
                    validate: function (value) {
                        if ($.trim(value) == '')
                            return 'عنوان را وارد کنید';
                    },
                    url: function (params) {
                        var d = new $.Deferred();

                        reqsvr("edit_group", "code:" + $(this).attr("group_id") + ",group_kind_id:" + $("#cb_group_kind").val() + ",name:'" + params.value + "'"
                            , function (data) {
                                if (data.d == "ok") {
                                    d.resolve();
                                    alert_message("ذخیره شد");
                                }
                                else {
                                    d.reject(data.d);
                                }
                            });
                        return d.promise();
                    }
                });
            });
        }

    </script>
</head>
<body>
    <form class="">
        <div class="row bg-menu pad3 btn-group">
            <div class=" col-xs-9">
                <label class="w-100">دسته بندی ها : </label>
                <select id="cb_group_kind" class="selectpicker " data-width="300px" data-size="10" data-live-search="true">
                </select>
            </div>

            <button type="button" onclick="new_group_kind()" title="دسته بندی جدید" class="btn btn-info glyphicon glyphicon-plus"></button>
            <button type="button" onclick="edit_group_kind()" title="ویرایش دسته بندی" class="btn btn-warning glyphicon glyphicon-pencil"></button>
            <button type="button" onclick="delete_group_kind()" title="حذف دسته بندی" class="btn btn-danger glyphicon glyphicon-trash"></button>

        </div>
        <br />
        <div id="dgv_groups" class="auto-height pad3">
        </div>
    </form>
</body>
</html>
