﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_employment.aspx.cs" Inherits="TimeWork.page_employment" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>

    <script> 
        $(document).ready(function () {
            initial_page(1000, 600);
            load();
        });

        function load() {
            reqsvr("load", "",
                function (data) {
                    fix_header_only = true;
                    load_tbl_btn(data.d, 'dgv');
                    tbl_add_copy_btn("dgv");
                    $("#tbl_dgv tbody tr:first").addClass("selectedtr");
                    load_personel();
                    $("#tbl_dgv td").click(function () {
                        load_personel($(this).closest('tr').attr('code'));

                    });
                });
        }

        var arow;


        function load_personel(id) {
            if (id == undefined) {
                id = tbl_cur_row("#tbl_dgv", "code");
                if (id == "") return;
            }
            $("#div_personel").attr('data_hf', '{"headerc2":"نوع استخدام :' + $('#tbl_dgv tbody .selectedtr').find("td:first").html() + '"}');

            reqsvr("load_personel", "code:" + id,
                function (data) {
                    load_tbl_chb(data.d, 'personel', 'row');


                });


        }

        function copy_dgv(o) {

            var code = $(selected_tr).attr("code");
            if (code == "" || code == undefined) { alert_error("لطفا یک مورد انتخاب نمائید"); return; }
            show_input_alert('عنوان جدید', '',
                function (v) {
                    reqsvr("copy", "code:" + code + ",name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {
                                load();
                            }
                            else
                                alert_error(data.d);
                        });
                });
        }

        function new_dgv() {

            open_form_('../../page/setting/page_employment_new.aspx', 'ایجاد نوع استخدام جدید', '-1', "load");
        }


        function edit_dgv(th) {
            var code = $(th).closest('tr').attr("code");
            if (code == "") return;
            open_form_('../../page/setting/page_employment_new.aspx', 'ویرایش نوع استخدام', code, "load");
        }
        function delete_dgv(th) {
            var code = $(th).closest('tr').attr("code");
            if (code == "") return;
            confirm_alert(function () {
                reqsvr("delete", "code:" + code,
                    function (data) {
                        if (data.d == "ok")
                            load();
                        else
                            alert_error(data.d);
                    });
            });
        }

        function add_personel() {
            var code = tbl_cur_row("#tbl_dgv", "code");
            if (code == "") return;
            open_form_('../../page/personnel/page_personnel_employment_add.aspx', 'اضافه کردن افراد', code, "load_personel");
        }
        function del_personel() {
            var row = get_checked('#tbl_personel');
            if (row == null) return;


            confirm_alert(function () {
                reqsvr("delete_personel", "row:'" + row + "'",
                    function (data) {
                        if (data.d == "ok")
                            load_personel();
                        else
                            alert_error(data.d);
                    });
            });
        }
    </script>
</head>
<body>
    <form>

        <div class="row auto-height panel" style="overflow-y: hidden">

            <div class="col-sm-5">
                <div id="div_dgv">
                </div>
            </div>
            <div class="col-sm-7">
                <div class="btn-group w-full bg-menu">
                    <button onclick="add_personel()" type="button" class="btn btn-primary "><span class="glyphicon glyphicon-user"></span>&nbsp;اضافه نمودن پرسنل</button>
                    <button onclick="del_personel()" type="button" class="btn btn-danger "><span class="glyphicon glyphicon-user"></span>&nbsp;حذف پرسنل</button>
                </div>
                <div id="div_personel"></div>
            </div>

        </div>

    </form>

</body>
</html>
