﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_calendar.aspx.cs" Inherits="TimeWork.page_calendar"
    EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/spinner/jquery-spinner.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/spinner/jquery-spinner.js" type="text/javascript"></script>
    <script type="text/javascript" src="../../style/mask/jquery.mask.min.js"></script>
    <script type="text/javascript" src="../../style/calendar/js-persian-cal.min.js"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>

        $(document).ready(function () {
            initial_page(1120, 500);
            initial_stepper();
            var year = 1396;
            var month = 04;
            reqsvr("get_date", "", function (data) {
                year = data.d.substring(0, 4);

                load_calendar(year);
            });
            $("#btn_upload_file").on("change", readFile_calendar);
        })
        function load_calendar(year) {

            parent.wait();
            $("#btn_save").addClass("disabled");

            $("#cb_year").val(year);

            reqsvr("get_clendar", "year :" + year, function (data) {

                $('#tbl_calendar').html(data.d[0]);
                $("#chb_multi")[0].checked = false;

                if (data.d[1] != "") {
                    $('#tb_sdate1').val(data.d[1]);
                    $('#tb_edate1').val(data.d[2]);
                    if (data.d[3] != "") {
                        $("#chb_multi")[0].checked = true;
                        $('#tb_sdate2').val(data.d[3]);
                        $('#tb_edate2').val(data.d[4]);
                    }
                }
                change_one_two();
                $('#tbl_calendar .calcell').dblclick(function () {
                    $(this).css({ "background-color": set_color(this) });
                    $("#btn_save").removeClass("disabled");

                });
                $('[data-toggle="tooltip"]').tooltip();

            });

            function set_color(obj) {
                var tag = $(obj).attr("tag");
                if (tag.indexOf("f") >= 0)
                    tag = tag.replace("f", "");
                else
                    tag = tag + "f";
                $(obj).attr("tag", tag);
                var bg = "White";
                if (tag.indexOf("f") >= 0) {
                    if (tag.indexOf("r") >= 0)
                        bg = "DarkRed";
                    else
                        bg = "Red";
                }
                else
                    if (tag.indexOf("j") >= 0) {
                        if (tag.indexOf("r") >= 0) {
                            bg = "Coral";
                        }
                        else {
                            bg = "bMistyRose";
                        }
                    }
                    else {
                        if (tag.indexOf("r") >= 0)
                            bg = "GreenYellow";
                        else
                            bg = "White";
                    }

                return bg;

            }
        }
        function save() {

            var free_day = "";
            $('#tbl_calendar').find(".calcell").each(function () {
                if ($(this).attr("tag").indexOf("f") >= 0) {
                    free_day = free_day + $(this).attr("date") + "-";
                }
            });
            reqsvr("save", "year :" + $("#cb_year").val()
                + " ,free_day:'" + free_day
                + "',sdate1:'" + $("#tb_sdate1").val()
                + "',edate1:'" + $("#tb_edate1").val()
                + "',sdate2:'" + $("#tb_sdate2").val()
                + "',edate2:'" + $("#tb_edate2").val() + "'"
                , function (data) {
                    if (data.d == "ok") {
                        alert_success("ذخیره شد");
                        $("#btn_save").addClass("disabled");
                        year_change();
                    }
                    else {
                        alert_error(data.d);
                    }
                });
        }

        function readFile_calendar() {
            if (this.files && this.files[0]) {
                var FR = new FileReader();
                FR.addEventListener("load", function (e) { sendFile(e.target.result); });
                FR.readAsDataURL(this.files[0]);
            }
        }
        function sendFile(imgb64) {

            reqsvr("upload", "val:'" + imgb64 + "'",
                function (data) {
                    if (data.d != "err") {
                        alert_success("ذخیره شد");
                        load_calendar(data.d);
                    }
                    else {
                        alert_error(data.d);
                    }
                });
        }

        function year_change() {
            var y = $("#cb_year").val();
            load_calendar(y);
        }

        function change_one_two() {

            if ($("#chb_multi")[0].checked) {
                $("#tbl_ramezan2").removeClass("hide");
            }
            else {
                $("#tbl_ramezan2").addClass("hide");
            }
        }
    </script>
</head>
<body>

    <div class="btn-group w-full bg-menu">
        <button onclick="year_change()" type="button" class="btn btn-primary"><span class="glyphicon glyphicon-refresh"></span>&nbsp;انصراف&nbsp;</button>
        <label class="btn btn-warning btn-file">
            <span class="fa fa-upload"></span>
            بارگزاری فایل
        <input id="btn_upload_file" type="file" accept=".tgv" style="display: none;" />
        </label>
        <button onclick="save()" type="button" class="btn btn-success"><span class="glyphicon glyphicon-floppy-disk"></span>&nbsp;ذخیره&nbsp;</button>
        
        <span>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</span>
        <span>سال : </span>
        <input id="cb_year" type="number" readonly style="text-align: center; width: 80px" onchange="year_change()" value="1390" class="form-control" min="1380" max="1480" step="1" />
    </div>
    <div class="panel auto-height pad3">

        <div id="tbl_calendar">
        </div>
        <div class="row">
            <div class="col-sm-5 pad5">
                <table class="w-full">
                    <tr>
                        <td>شروع رمضان : </td>
                        <td>
                            <input id="tb_sdate1" name="sdate1" type="text" class="form-control date " />
                        </td>
                        <td>پایان رمضان : </td>
                        <td>
                            <input id="tb_edate1" name="edate1" type="text" class="form-control date " />
                        </td>
                    </tr>

                </table>
            </div>
            <div class="col-sm-1 pad5">
                <input id="chb_multi" name="multi_time" type="checkbox" class="form-control" value="دو مرتبه" onchange="change_one_two()" />&nbsp;<span>دو مرتبه</span>


            </div>
            <div class="col-sm-6 pad5">

                <table id="tbl_ramezan2" class="w-full hide">
                    <tr>
                        <td>شروع رمضان 2 : </td>
                        <td>
                            <input id="tb_sdate2" name="sdate2" type="text" class="form-control date " />
                        </td>
                        <td>پایان رمضان 2 : </td>
                        <td>
                            <input id="tb_edate2" name="edate2" type="text" class="form-control date " />
                        </td>
                    </tr>

                </table>
            </div>
        </div>
    </div>

</body>
</html>
