﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_section.aspx.cs" Inherits="TimeWork.page_section" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/treeGrid/treeGrid.css" rel="stylesheet" />
    <link href="../../style/SelectTree/select2.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/treeGrid/treeGrid.js" type="text/javascript"></script>
    <script src="../../style/SelectTree/select2.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>

    <script> 
        $(document).ready(function () {
            initial_tab();
            load();

            $("#tb_search_tree").on("keyup", function () {
                var arr = $(this).val().toLowerCase().replace("  ", " ").split(' ');

                $("#tbl_section tbody tr").filter(function () {
                    var toggled = true;
                    for (var i = 0; i < arr.length; i++) {
                        if (arr[i] == '') continue;
                        if ($(this).text().toLowerCase().indexOf(arr[i]) == -1) {
                            toggled = false;
                            break;
                        }
                    }
                    $(this).toggle(toggled);
                    load_personel("-1");
                });
            });

        });

        var loading = false;
        function load() {
            last_id = "";
            reqsvr("load", "",
                function (data) {
                    $('#div_section').html(data.d[0]);
                    if (!loading) {
                        $("#div_menu_section").append(data.d[1]);
                        $("#div_menu_personel").append(data.d[2]);
                        loading = true;
                    }
                    set_datatable('#tbl_section');
                    $('.tree').treegrid({
                        enableMove: edit_mode
                    });
                    if (edit_mode) {
                        $('#tbl_section').find(".treegrid-container").addClass("grab");
                    }
                    $('#div_personel').html("...");
                    var c = $("#tbl_section tbody tr:first").attr('code');
                    if (c !== undefined) {
                        $("#tbl_section").find("[code=" + c + "]").addClass("selectedtr");
                        $("#tbl_section").find("[code=" + c + "]").parents('tr').click();
                        load_personel($("#tbl_section").find(".selectedtr").attr('code'));

                    }
                    $("#tbl_section tbody tr").click(function () {
                        $("#tbl_section tr").removeClass("selectedtr");
                        $(this).addClass("selectedtr");
                        load_personel($(this).attr('code'));
                    });
                }
            );

        }
        var last_id;

        function refresh_personel() {

            var obj = $("#tbl_section").find(".selectedtr");
            last_id = "";
            reqsvr("refresh_cnt", "",
                function (data) {
                    var xml = XMLparse(data.d);
                    xml.find("mytable").each(function () {

                        var o = $("#tbl_section").find("tr[code=" + $(this).find('code').text() + "]");
                        if (o.length > 0) {
                            var cnt = $(this).find('cnt').text();
                            var max = $(this).find('cnt_max').text();
                            var st = "green-dark bg-green-light";
                            if (parseInt(cnt) > parseInt(max))
                                st = "yellow bg-yellow-light";
                            else
                                if (parseInt(cnt) < parseInt(max))
                                    st = "red bg-red-light";
                            if ($(this).find('section_kind_id').text() == 4)
                                $(o).find("td").eq(3).replaceWith("<td class=\"center " + st + " ltr\">" + cnt + " / " + max + "</td>");
                            else $(o).find("td").eq(3).replaceWith("<td class=\"center ltr\">" + cnt + "</td>");

                            $(o).find("td").eq(4).html($(this).find('sum').text());
                        }
                    });
                });

            load_personel(obj.attr('code'));
        }
        function load_personel(id) {

            if (id != last_id) {

                if (id == "last") id = last_id;

                var ch = $("#chb_all")[0].checked ? 1 : 0;
                reqsvr("load_personel", "code:" + id + ",all:" + ch,
                    function (data) {
                        load_tbl_btn_chb(data.d, 'personel', 'row');
                        $("#div_personel").find("button[name=delete_multi]").remove();
                        $("#div_personel").find("button[name=delete]").remove();
                        $("#div_personel").find("button[name=new]").remove();
                    });
                last_id = id;
            }
        }

        function new_click() {
            var obj = $("#tbl_section").find(".selectedtr");
            open_form_('../../page/section/page_section_new.aspx', 'جدید', obj.attr('code') + '&-1', "tree_add");
        }

        function tree_add(mode, code) {

            var obj = $("#tbl_section").find(".selectedtr");

            reqsvr("node_load",
                "code:" + code + ",cnt:'0', sum_cnt:'0'",
                function (data) {
                    $(obj).treegrid('add', ['<tr class="treegrid-' + code + '" code="' + code + '"cnt="0" sum-cnt="0" name="' + data.d[0] + '"><td title="' + data.d[1] + '">' + data.d[2] + '</td>' + data.d[3] + data.d[4] + data.d[5] + data.d[6] + '</tr>']);
                    tbl_select("#tbl_section");
                });
        }

        var edit_mode = false;
        function edit_chart_click() {

            $("button[name=new]").addClass("hide");
            $("button[name=edit]").addClass("hide");
            $("button[name=delete]").addClass("hide");
            $("#btn_edit_chart").addClass("hide");
            $("#btn_save_sort").removeClass("hide");
            $("#btn_cancel_sort").removeClass("hide");
            edit_mode = true;
            load();
            
        }
        function save_sort() {

            var data = "";
            $("#tbl_section tbody").find("tr").each(function () {
                data = data + "," + $(this).attr("class");
            });
            reqsvr("save_sort", "data:'" + data + "'",
                function (data) {
                    if (data.d == "ok") {
                        $("button[name=new]").removeClass("hide");
                        $("button[name=edit]").removeClass("hide");
                        $("button[name=delete]").removeClass("hide");
                        $("#btn_save_sort").addClass("hide");
                        $("#btn_cancel_sort").addClass("hide");
                        $("#btn_edit_chart").removeClass("hide");
                        edit_mode = false;
                        refresh_personel();
                        alert_success("تغییرات ذخیره شد");

                    }
                    else
                        alert_error(data.d);
                });
        }

        function cancel_sort() {

            $("button[name=new]").removeClass("hide");
            $("button[name=edit]").removeClass("hide");
            $("button[name=delete]").removeClass("hide");
            $("#btn_save_sort").addClass("hide");
            $("#btn_cancel_sort").addClass("hide");
            $("#btn_edit_chart").removeClass("hide");
            edit_mode = false;
            load()
        }

        function edit_click() {

            var obj = $("#tbl_section").find(".selectedtr");
            if (obj == undefined || obj.attr('code') == '0' || obj.attr('code') == undefined) return;
            open_form_('../../page/section/page_section_new.aspx', 'ویرایش', '-1&' + obj.attr('code') + '&' + obj.attr('name'), "tree_edit");
        }

        function tree_edit(mode, code) {
            if (mode == "load") load();
            else {
                var obj = $("#tbl_section").find(".selectedtr");

                reqsvr("node_load",
                    "code:" + code + ", cnt:'" + $(obj).attr('cnt') + "', sum_cnt:'" + $(obj).attr('sum-cnt') + "'",
                    function (data) {
                        $(obj).attr('name', data.d[0]);
                        $(obj).find("td").eq(0).attr('title', data.d[1]);
                        $(obj).find("td").eq(0).find('.title').replaceWith(data.d[2]);
                        $(obj).find("td").eq(1).replaceWith(data.d[3]);
                        $(obj).find("td").eq(2).replaceWith(data.d[4]);
                        $(obj).find("td").eq(3).replaceWith(data.d[5]);
                        $(obj).find("td").eq(4).replaceWith(data.d[6]);

                    });

            }
        }

        function delete_click() {
            var obj = $("#tbl_section").find(".selectedtr");
            if (obj == undefined || obj.attr('code') == '0') return;
            if (obj.attr('code') == undefined) {
                alert_error('هیچ گزینه ای انتخاب نشده است');
                return;
            }
            var data_parent = obj.attr('data-parent');
            confirm_alert(function () {
                reqsvr("delete",
                    "code:" + obj.attr('code'),
                    function (data) {
                        if (data.d == "ok")
                            $(obj).treegrid('remove');
                        else
                            alert_error(data.d);
                    });
            });
        }

        function view_chart() {
            var obj = $("#tbl_section").find(".selectedtr");
            open_form_('../../page/section/page_section_chart.aspx', obj.attr('name'), obj.attr('code'));
        }

        function set_admin() {
            var obj = $("#tbl_section").find(".selectedtr"); 
            if (obj == undefined || obj.attr('code') == '0') return;
            var row = tbl_cur_row('#tbl_personel');
            if (row == "")
                return;

            reqsvr("save_admin_section", "section_id:" + obj.attr('code') + ",row:" + row, function (data) {
                if (data.d[0] == "ok") {
                    $(obj).find(".admin").html(data.d[1]);
                     
                }
                else
                    alert_error(data.d[0]);
            });
        }

        function add_personel() {
            var obj = $("#tbl_section").find(".selectedtr");
            parent.sel_prow = "";

            open_form_('../../page/section/page_section_person_add.aspx', 'اضافه کردن افراد در ' + obj.attr('name'), obj.attr('code'), "refresh_personel");
        }


        function edit_personel(obj) {
            open_form_('../../page/section/page_section_person_edit.aspx', $(obj).closest('tr').find('td:eq(1)').html() + " - " + $(obj).closest('tr').find('td:eq(2)').html(), $(obj).closest('tr').attr('code'));
        }

 
        function change_personel() {
            var row = get_checked('#tbl_personel');
            if (row == null) return;
            var obj = $("#tbl_section").find(".selectedtr");
            parent.temp = row;
            open_form_('../../page/section/page_section_person_add.aspx', 'جابجایی افراد در ' + obj.attr('name'), obj.attr('code') , "refresh_personel");
        }

        function del_personel() {
            var row = get_checked('#tbl_personel');
            if (row == null) return;
            confirm_alert(function () {
                reqsvr("delete_personel",
                    "row:'" + row + "'",
                    function (data) {
                        if (data.d == "ok") {
                            var obj = $("#tbl_section").find(".selectedtr");

                            refresh_personel();
                        }
                        else
                            alert_error(data.d);
                    });
            });
        }
    </script>
</head>
<body>
    <form>
        <div id="div_menu_section" class="  bg-menu">
            <a href="#" class="btn btn-default glyphicon glyphicon-refresh" onclick="load()"></a>
            <a href="#" class="btn btn-default fa fa-sitemap" onclick="view_chart()"></a>
        </div>
        <div class="row  auto-height no-scroll">
            <div class="col-xs-6">
                <div id="tbl_result_filter" class="dataTables_filter">
                    <input type="search" class="form-control input-sm" placeholder="جستجو" id="tb_search_tree" />
                </div>
                <div id="div_section" class="panel  auto-height">
                </div>
            </div>
            <div class="col-xs-6">
                <div id="div_menu_personel" class="btn-group w-full bg-menu">
                    &nbsp;&nbsp;
                    <input id="chb_all" type="checkbox" class="form-control" title="همه افراد" onchange="load_personel('last')" />&nbsp;<span>نمایش افراد قطع کار شده</span>
                </div>
                <div id="div_personel" class="auto-height"></div>
            </div>
        </div>
    </form>

    <p>
    </p>

</body>
</html>
