﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_payroll_salary_slip.aspx.cs" Inherits="TimeWork.page_payroll_salary_slip" EnableSessionState="True" %>


<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/spinner/jquery-spinner.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />


    <script type="text/javascript" src="../../script/jquery.min.js"></script>
    <script type="text/javascript" src="../../style/bootstrap/bootstrap.min.js"></script>
    <script type="text/javascript" src="../../style/select/bootstrap-select.js"></script>
    <script type="text/javascript" src="../../style/spinner/jquery-spinner.js"></script>
    <script type="text/javascript" src="../../script/fnc.js"></script>

    <script type="text/javascript"> 
        $(document).ready(function () {
            initial_tab();
            initial_stepper();

            reqsvr("load", "",
                function (data) {
                    $("#cb_year").val(data.d.substring(0, 4));
                    $("#cb_month").val(data.d.substring(5, 7));
                });
        });
        var _year;
        var _month;
        function view_fish() {
            reqsvr("view", "code:" + parent.sms_code + ",year:" + $("#cb_year").val() + ",month:" + $("#cb_month").val(), function (data) {
                _year = $("#cb_year").val();
                _month = $("#cb_month").val();
                switch (data.d[0]) {
                    case "ok":
                        view_data(data.d);
                        break;
                    case "er":
                    case "error":
                        alert_error(data.d[1]);
                        break;
                    default:
                        show_key(data.d[0], data.d);
                        break;
                } 
            });
        }

        function accept_fish() {
            reqsvr("accept_fish", "year:" + _year + ",month:" + _month, function (data) {
                $("#div_accept").html(data.d);
            });
        } 
        function show_key(c, d) {
            parent.Swal.fire({
                title: 'رمز یکبار مصرف',
                input: 'text',
                inputValue: '',
                inputPlaceholder: '',
                inputAttributes: {
                    autocapitalize: 'off'
                },
                showCancelButton: true,
                confirmButtonText: 'تائید',
                cancelButtonText: 'انصراف',
                showLoaderOnConfirm: true,
                preConfirm: (txt) => {
                    if (txt !== c) {
                        parent.swal.showValidationMessage('رمز وارد شده صحیح نمی باشد');
                    }
                },
                allowOutsideClick: false,
            }).then((result) => {
                if (result.value == c) {
                    view_data(d);
                    parent.sms_code = c;


                }
            })
        }
        var file_path = "";
        var file_name = "";
        function view_data(d) {
                file_path = d[2];
                file_name = d[6];
            if (d[5] == "file") {
                download();
            }
            else {
                file_path = d[2];
                $("#div_report").html(d[3]);
                $("#div_report").attr("dir", "rtl");
                $("#div_report table:first").css("direction", "ltr");
                $("#div_report table:first").css("padding", "10px");
                $("#div_report table:first").css("direction", "ltr");
                $("#div_report table:first").css("background-color", "#fff");
                $('#div_report table tr td').css("font-family", "Shabnam");
            }
            $("#div_accept").html(d[4]);
        }
        function download() {
            file_download(file_path, file_name);
        }
    </script>
</head>
<body>
    <form>
        <div class="bg-menu pad-5">
            <div style="display: inline;">
                <div id="div_date_fix" style="display: inline;">
                    <label>دوره :</label>
                    <input id="cb_year" type="number" readonly style="padding-left: 30px !important;" class="form-control" min="1380" max="1480" step="1" />
                    <select id="cb_month" class="form-control" style="width: 90px;">
                        <option value="01">فروردین</option>
                        <option value="02">اردیبهشت</option>
                        <option value="03">خرداد</option>
                        <option value="04">تیر</option>
                        <option value="05">مرداد</option>
                        <option value="06">شهریور</option>
                        <option value="07">مهر</option>
                        <option value="08">آبان</option>
                        <option value="09">آذر</option>
                        <option value="10">دی</option>
                        <option value="11">بهمن</option>
                        <option value="12">اسفند</option>
                    </select>
                </div>
            </div>
            <button type="button" title="مشاهده" class="btn btn-primary" onclick="view_fish()"><span>نمایش </span></button>
            <button type="button" title="دانلود" class="btn btn-default" onclick="download()"><span class=" fa fa-download "></span></button>
        </div>
        <div id="div_accept" class="center">
        </div>
        <div dir="ltr" id="div_report" class="auto-height w-full" style="display: inline-block;">
        </div>

    </form>
</body>
</html>
