﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_rull_new.aspx.cs" Inherits="TimeWork.page_rull_new" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <link href="../../style/tagify/tagify.css" rel="stylesheet" />

    <script  src="../../script/jquery.min.js"  type="text/javascript" ></script>
    <script  src="../../style/bootstrap/bootstrap.min.js"  type="text/javascript" ></script>
    <script  src="../../script/fnc.js"  type="text/javascript" ></script>
    <script  src="../../style/tagify/tagify.min.js"  type="text/javascript" ></script>
    <script >
        var ecode;
        var field = [];
        var parameter_day = [];
        var parameter_month = [];

        $(document).ready(function () {
            var ar = initial_page(800, 500);
            ecode = ar[0];
            reqsvr("load", "code:" + ecode, function (data) {
                load_cb("#rull_step", data.d[0]);

                if (ecode != 0) {
                    var xml = XMLparse(data.d[1]);
                    $(xml).find("mytable").each(function () {
                        $("#name").val($(this).find('name').text());
                        $("#rull_step").val($(this).find('rull_step_id').text());
                        $("#detail").val($(this).find('detail').text());
                        $("#formul_xml").val($(this).find('formul_xml').text());
                        $('#active').prop('checked', $(this).find('active').text() == '1');
                    });
                }
                rull_step_change();
                initial_tagify();
            });
        });

        function initial_tagify() {
            var input = document.querySelector('#formul_xml'),
                tagify = new Tagify(input, {
                    mode: 'mix',  // <--  Enable mixed-content
                    pattern: /@|!|#/,  // <--  Text starting with @ or # (if single, String can be used here)
                    tagTextProp: 'text',  // <-- the default property (from whitelist item) for the text to be rendered in a tag element.
                    enforceWhitelist: true,
                    whitelist: field.concat(parameter_day.concat(parameter_month)).map(function (item) { return typeof item == 'string' ? { value: item } : item }),
                    keepInvalidTags: 0,
                    duplicates: 1,
                    dropdown: {
                        enabled: 0,
                        maxItems: 1000,
                        position: 'text', // <-- render the suggestions list next to the typed text ("caret")
                        mapValueTo: 'text', // <-- similar to above "tagTextProp" setting, but for the dropdown items
                        highlightFirst: false  // automatically highlights first sugegstion item in the dropdown
                    },
                    transformTag: transformTag
                })
            tagify.on('input', function (e) {
                switch (e.detail.prefix) {
                    case '#': tagify.settings.whitelist = field; break;
                    case '@': tagify.settings.whitelist = parameter_day; break; 
                    case '!': tagify.settings.whitelist = parameter_month; break;
                }
                if (e.detail.value.length > 1) tagify.dropdown.show.call(tagify, e.detail.value);
            })
            function transformTag(tagData) {
                switch (tagData.kind) {
                    case "pd": tagData.style = "--tag-bg:#f2fdd0"; break;
                    case "pm": tagData.style = "--tag-bg:#aee8ff"; break;
                    case "f": tagData.style = "--tag-bg:#ffc3c3"; break;
                }
            }
        }

        function rull_step_change() {
            field = [];
            parameter_day = [];
            reqsvrS("rull_step_change", "code:" + $('#rull_step').val(), function (data) {
                $(data.d[0]).find("mytable").each(function () {
                    field.push({ value: $(this).find('code').text(), text: $(this).find('name').text(), kind: 'f' });
                });
                $(data.d[1]).find("mytable").each(function () {
                    parameter_day.push({ value: $(this).find('code').text(), text: $(this).find('name').text(), kind: 'pd' });
                });
                $(data.d[2]).find("mytable").each(function () {
                    parameter_month.push({ value: $(this).find('code').text(), text: $(this).find('name').text(), kind: 'pm' });
                });
            });
        }

        function save() {

            reqsvr("save",
                "code:" + ecode +
                ",rull_step_id:" + $("#rull_step").val() +
                ",name:'" + $("#name").val() +
                "',detail:'" + $("#detail").val() +
                "',formul_xml:'" + $("#formul_xml").val() +
                "',active:'" + $("#active")[0].checked +
                "'",
                function (data) {
                    if (data.d == "ok") {
                        alert_message("ذخیره شد");
                        call_fnc();
                        close();
                    }
                    else
                        alert_error(data.d);
                });
        }

    </script>
</head>
<body>
    <div id="div_main" class="row">
        <div class="col-sm-6">
            <span>عنوان : </span>
            <input type="text" id="name" class="form-control" />
        </div>
        <div class="col-sm-6">
            <span>مرحله اجرا : </span>
            <select id="rull_step" class="form-control" onchange="rull_step_change()">
            </select>
        </div>

        <div class="col-sm-10">
            <span>توضیحات : </span>
            <input type="text" id="detail" class="form-control" />
        </div>

        <div class="col-sm-2">
            <input type="checkbox" id="active" class="form-control"/>فعال  
        </div>

        <div class="col-sm-12 ">
            <span>متن قانون : </span>
            <div class="form-control tagify" style="height: 300px; overflow: scroll" dir="ltr">
                <textarea id="formul_xml" class=""> </textarea>
            </div>

        </div>

    </div>

    <div class="toolbar-footer">
        <button type="button" class="btn btn-success  " onclick="save()">ذخیره</button>
    </div>

</body>
</html>
