﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_rull_events.aspx.cs" Inherits="TimeWork.page_rull_events" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>

    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script> 



        $(document).ready(function () {
            initial_tab();

            reqsvr("load", "", function (data) {
                load_cb("#cb_rull_step", data.d[0]);
                $("#div_rull_access").html(data.d[1]);
                load();

            });



        });
        function load() {

            reqsvr("load_step", "step_id:" + $("#cb_rull_step").val(), function (data) {
                load_tbl_page(data.d, 'events', 'code', 0, 'rull_step_id');

                $('#tbl_events thead tr').find('th:last').after('<th class="w-150"><button onclick="new_event()" class="btn btn-info glyphicon glyphicon-plus" title="اضافه جدید"/></button > </th>');
                $('#tbl_events tbody tr').each(function () {
                    switch ($(this).attr("rull_step_id")) {
                        case "1": $(this).find("td:first").css('background', '#fffde7'); break;
                        case "2": $(this).find("td:first").css('background', '#f1f8e9'); break;
                        case "3": $(this).find("td:first").css('background', '#e0f2f1'); break;
                        case "4": $(this).find("td:first").css('background', '#e1f5fe'); break;
                        case "5": $(this).find("td:first").css('background', '#e3f2fd'); break;
                        case "6": $(this).find("td:first").css('background', '#ede7f6'); break;
                        case "7": $(this).find("td:first").css('background', '#ffebee'); break;
                        case "8": $(this).find("td:first").css('background', '#D6EAF8'); break;
                    }
                    var td_ = [];
                    td_.push('<td>' +
                        '<button type="button" class="btn glyphicon glyphicon-menu-up"   onclick="row_up(this)"  ></button>' +
                        '<button type="button" class="btn glyphicon glyphicon-menu-down" onclick="row_down(this)"></button>' +
                        '<button type="button" class="btn glyphicon glyphicon-pencil"    onclick="edit_event(this)"   title="ویرایش"></button>' +
                        '<button type="button" class="btn glyphicon glyphicon-trash red" onclick="delete_event(this)" title="حذف"></button>' +
                        '</td>');
                    $(this).find('td:last').after(td_);
                });
            });

        }

        function cb_rull_step_change() {
            load();

        }
        function rull_click() {
            open_form_('page/rull/page_rulls.aspx', "لیست قوانین", "", "load()");
        }
        function new_event() {
            open_form_('page/rull/page_rull_events_new.aspx', "جدید", "0", "load()");
        }

        function edit_event(th) {

            open_form_('page/rull/page_rull_events_new.aspx', "ویرایش", $(th).closest('tr').attr("code"), "load()");


        }
        function delete_event(th) {

            confirm_alert(function () {
                reqsvr("delete", "code:" + $(th).closest('tr').attr("code"),
                    function (data) {
                        if (data.d == "ok") {
                            $(th).closest('tr').remove();
                            alert_message("حذف انجام شد");
                        }
                        else
                            alert_error(data.d);
                    });
            });

        }


        function row_up(obj) {

            reqsvr("row_up", "code:" + $(obj).closest('tr').attr('code'),
                function (data) {
                    if (data.d[0] == "ok") {
                        tr_up($(obj).closest('tr'));
                    }
                });
        }
        function row_down(obj) {
            reqsvr("row_down", "code:" + $(obj).closest('tr').attr('code'),
                function (data) {
                    if (data.d[0] == "ok") {
                        tr_down($(obj).closest('tr'));
                    }
                });
        }

    </script>
</head>
<body>
    <div id="div_main">
        <div class="w-full" style="background-color: #e9eaea;">
            <div class="row">
                <div class="col-sm-4">
                    <div class="col-sm-4 lbl">مرحله اجرا : </div>
                    <div class="col-sm-8">
                        <select id="cb_rull_step" class="selectpicker" onchange="cb_rull_step_change()" style="width: 200px; height: 30px" data-width="300px" data-size="10">
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                </div>
                <div id="div_rull_access" class="col-sm-4">
                </div>
            </div>
        </div>
        <div id="div_events" class="auto-height">
        </div>
    </div>
</body>
</html>
