﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_poll_pattern.aspx.cs" Inherits="TimeWork.page_poll_pattern" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js"></script>
    <script src="../../style/mask/jquery.mask.min.js"></script>
    <script src="../../style/select/bootstrap-select.js"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../script/fncDate.js" type="text/javascript"></script>
    <script src="../../style/alert/sweetalert.js"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>
        $(document).ready(function () {
            initial_page(775, 600);
            refresh();
        })

        var new_html = '<div class="col-sm-12"> \
                    <span class="float-right">نام ماژول <span class=\"red_\"> *</span></span></span><input id="module_name" class="form-control" type="text"/> \
                  </div> \
                <div class="col-sm-12"> \
                    <span class="float-right">عنوان الگو <span class=\"red_\"> *</span></span></span><input id="poll_name" class="form-control" type="text"  /> \
                </div> \
                <div class="col-sm-12"> \
                    <span class="float-right">فعال / غیر فعال <span class=\"red_\"> *</span></span></span><input name="poll_enabled" class="form-control" type="checkbox" value="1" /> \
                </div> \
                <div class="col-sm-12"> \
                    <span class="float-right">جزئیات نظرسنجی</span><textarea id="poll_detail" class="form-control" style="min-width:100%; max-width:100%; width:100%;" rows="3"></textarea> \
                </div>';

        function refresh() {
            reqsvr("loading", "", function (data) {
                load_cb_not_select("#cb_request", data.d);
            });

            reqsvr("load", "", function (data) {
                load_tbl_btn(data.d, "table");
            });
        }
        function search() {
            var cb_request = get_cb("#cb_request");
            if (cb_request == "") {
                alert_error("حداقل یک ماژول را انتخاب کنید");
                return "";
            }
            reqsvr("search", "request_item:'" + cb_request + "'", function (data) {
                load_tbl_btn(data.d, "table");
            });
        }

        function edit_table(o) {
            var input_checked = "";
            var el = $(o).closest('tr');
            reqsvr("data_load", "code:" + el.attr('code'), function (data) {
                const arr_items = data.d.split(",");
                if (arr_items[2] == "1")
                    input_checked = 'checked="checked"'
                var edit_html = '<div class="col-sm-12"> \
                    <span class="float-right">نام جدول</span><input value="poll_'+ arr_items[4] + '" class="form-control" type="text" readonly/> \
                </div> \
                    <div class="col-sm-12"> \
                    <span class="float-right">نام ماژول<span class=\"red_\"> *</span></span><input id="module_name" value="'+ arr_items[0] + '" class="form-control" type="text"/> \
                </div> \
                <div class="col-sm-12"> \
                    <span class="float-right">عنوان الگو<span class=\"red_\"> *</span></span><input id="poll_name" value="'+ arr_items[1] + '" class="form-control" type="text"  /> \
                </div> \
                <div class="col-sm-12"> \
                    <span class="float-right">فعال / غیر فعال</span><input name="poll_enabled" '+ input_checked + ' class="form-control" type="checkbox" value="1"  /> \
                </div> \
                <div class="col-sm-12"> \
                    <span class="float-right">جزئیات نظرسنجی</span><textarea id="poll_detail" class="form-control" style="min-width:100%;" rows="3">'+ arr_items[3] + '</textarea> \
                </div>';
                show_html_alert("تغییر الگو", edit_html, function (v) {
                    if ($.trim(v[0]) == "" || $.trim(v[1]) == "" || $.trim(v[2]) == "") {
                        alert_error("مقادیر ستاره دار را وارد کنید");
                        return;
                    }
                    reqsvr("edit_poll", "cmd:'" + v + "',code:" + el.attr('code'), function (data) {
                        const arr = data.d.split(",");
                        $(el).find('td[col_name="module_name"]').text(arr[0]);
                        $(el).find('td[col_name="name"]').text(arr[1]);
                        $(el).find('td[col_name="enabled"]').text(arr[2]);
                        $(el).find('td[col_name="detail"]').text(arr[3]);
                    })
                }, function () {
                    return [
                        $("#module_name").val(),
                        $("#poll_name").val(),
                        $("[name='poll_enabled']:checked").val(),
                        $("#poll_detail").val()
                    ]
                }
                );

            })
        }

        function new_table() {
            show_html_alert("الگو جدید", new_html, function (v) {
                if ($.trim(v[0]) == "" || $.trim(v[1]) == "") {
                    alert_error("مقادیر ستاره دار را وارد کنید");
                    return;
                }
                reqsvr("new_poll", "request_items:'" + v + "'", function (data) {
                    alert_success("نظرسنجی با موفقیت ثبت شد");
                    refresh();
                });
            }, function () {
                return [
                    $("#module_name").val(),
                    $("#poll_name").val(),
                    $("[name='poll_enabled']:checked").val(),
                    $("#poll_detail").val()
                ]
            });
        }


        function delete_table(o) {
            var el = $(o).closest('tr');
            confirm_alert(function () {
                reqsvr("delete_poll", "code:'" + $(el).attr("code") + "'", function (data) {
                    if (data.d == "ok") {
                        alert_success("الگو حذف شد");
                        refresh();
                    } else {
                        alert_error(data.d);
                    }
                });
            });
        };

    </script>
</head>
<body>
    <form>
        <div class="dock-full container">
            <div class="btn-group  bg-menu">
                <button type="button" class="btn block collapsed" data-toggle="collapse" data-target="#div_filter" aria-expanded="false"><span class="glyphicon glyphicon-filter">&nbsp;</span>فیلتر</button>
            </div>
            <div id="div_filter" class="filter collapse" aria-expanded="false" style="height: 20px;">
                <div class="row">
                    <div>نام ماژول :</div>
                    <select id="cb_request" class="selectpicker " data-width="100%" data-size="10" multiple="multiple" data-actions-box="true" multiple data-selected-text-format="count > 3">
                    </select>
                </div>
                <div class="row align-center" style="border-top: solid 1px; margin-top: 5px; padding-top: 5px;">
                    <button type="button" class="btn btn-primary" onclick="search(this)"><span class="glyphicon glyphicon-search">&nbsp;</span>جستجو</button>&nbsp;
                </div>
            </div>
            <div class="dataTables_scrollBody" id="div_table"></div>
        </div>
    </form>
</body>
</html>
