﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_poll_event_view.aspx.cs" Inherits="TimeWork.page_poll_event_view" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../style/alert/sweetalert.js"></script>
    <script src="../../style/googlechart/loader.js"></script>
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js"></script>
    <script src="../../style/mask/jquery.mask.min.js"></script>
    <script src="../../style/select/bootstrap-select.js"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../script/fncDate.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>
        var poll_pattern_id;
        var ecode;
        $(document).ready(function () {
            var ar = initial_page(500, 450);
            ecode = ar[0];
            reqsvr("load", "code:'" + ecode + "'", function (data) {
                poll_pattern_id = data.d[0];
                load_cb_not_select("#cb_field", data.d[1], "", "ig_id,fv_id,f_name");
            });
        });
        // Load Charts and the corechart and barchart packages.
        google.charts.load('current', { 'packages': ['corechart'] });
        function drawChart(cmp) {
            var data = new google.visualization.DataTable();
            data.addColumn('string', 'عنوان');
            data.addColumn('number', 'تعداد');
            data.addRows(JSON.parse(cmp));
            var piechart_options = {
                width: $(window).width(),
                height: 300
            };
            var piechart = new google.visualization.PieChart(document.getElementById('piechart_div'));
            piechart.draw(data, piechart_options);

            var colchart_options = {
                legend: 'none',
                width: $(window).width(),
                height: 300
            };
            var colchart = new google.visualization.ColumnChart(document.getElementById('colchart_div'));
            colchart.draw(data, colchart_options);
        }
        function report_field_onchange() {
            $("#colchart_div").empty();
            $("#piechart_div").empty(); 
            var ig_id = get_cb_attr('#cb_field', 'ig_id');
            var fv_id = get_cb_attr('#cb_field', 'fv_id');
            var f_name = get_cb_attr('#cb_field', 'f_name');
             
            if (["1", "2", "3", "4"].indexOf(fv_id) !== -1) {
                $("#item_filter_div").show();
                reqsvr("load_items", "ig_id:'" + ig_id + "'",
                    function (data) {
                    load_cb_not_select("#cb_item", data.d);
                });
            } else
                $("#item_filter_div").hide();

            if (["1", "3"].indexOf(fv_id) == -1) {
                $("#li_pie").removeClass("active");
                $("#col_chart").removeClass("in active");
                $("#li_col").removeClass("active");
                $("#pie_chart").removeClass("in active");
                $("#li_col").hide();
                $("#li_pie").hide();
                $("#li_data").addClass("active");
                $("#data_chart").addClass("in active");
            } else {
                $("#li_col").show();
                $("#li_pie").show();
                reqsvr("load_chart", "event_id:'" + ecode + "',poll_pattern_id:'" + poll_pattern_id + "',field_name:'" + f_name + "'", function (data) {
                    drawChart(data.d);
                });
            }
            reqsvr("load_data", "code:'" + ecode + "',poll_pattern_id:'" + poll_pattern_id + "',name:'" + f_name+ "',attr:'" + fv_id, function (data) {
                load_tbl(data.d, "data");
            });
        }
        function slc_item_onchange() {
            const cb_request = get_cb("#cb_item");
            reqsvr("load_data", "code:'" + ecode + "',poll_pattern_id:'" + poll_pattern_id + "',name:'" + f_name + "',attr:'" + fv_id + "',filter:'" + cb_request + "'", function (data) {
                load_tbl(data.d, "data");
            });
        }

    </script>
</head>
<body>
    <form>
        <div class="row">
            <div class="col-sm-3">
                <span class="f14 align-center">انتخاب گزینه : </span>
            </div>
            <div class="col-sm-9">
                <select id="cb_field" onchange="report_field_onchange()" class="form-control">
                    <option></option>
                </select>
            </div>
        </div>

        <ul class="nav nav-tabs">
            <li id="li_pie"><a data-toggle="tab" href="#pie_chart">نمودار دایره ای</a></li>
            <li id="li_col"><a data-toggle="tab" href="#col_chart">نمودار میله ای</a></li>
            <li id="li_data" class="active"><a data-toggle="tab" href="#data_chart">اطلاعات</a></li>
        </ul>
        <div class="tab-content">
            <div id="pie_chart" class="tab-pane fade">
                <div class="col-sm-12" style="width: 100%; height: 60%;" id="piechart_div"></div>
            </div>
            <div id="col_chart" class="tab-pane fade">
                <div class="col-sm-12" style="width: 100%; height: 60%;" id="colchart_div"></div>
            </div>
            <div id="data_chart" class="tab-pane fade in active">
                <div id="item_filter_div" hidden="hidden">
                    <div class="col-xs-1">
                        <span class="f14 align-center">آیتم : </span>
                    </div>
                    <div class="col-xs-5">
                        <select onchange="slc_item_onchange()" id="cb_item" class="selectpicker " data-width="100%" data-size="10" multiple="multiple" data-actions-box="true" multiple>
                        </select>
                    </div>
                </div>
                <div class="col-sm-12" style="width: 100%; height: 60%;" id="div_data">
                </div>
            </div>
        </div>

    </form>
</body>
</html>
