﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_poll_event_list.aspx.cs" Inherits="TimeWork.page_poll_event_list" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../style/alert/sweetalert.js"></script>
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js"></script>
    <script src="../../style/mask/jquery.mask.min.js"></script>
    <script src="../../style/select/bootstrap-select.js"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../script/fncDate.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>
        $(document).ready(function () {
            initial_page(775, 600);
            refresh();
        })

        function refresh() {
            reqsvr("loading", "", function (data) {
                load_cb_not_select("#cb_pattern", data.d);
            });

            reqsvr("search", "pattern_id:''", function (data) {
                load_tbl_btn(data.d, "table");

                //$('#tbl_table tbody tr td .btn-edit').each(function () {
                //    $(this).parent().prepend('<button onclick="view_report(this)" class="btn btn-default glyphicon glyphicon-eye-open" type="button" title="گزارش"></button>');;
                //    $(this).closest("td").css("width", "100px");
                //});
                //$("#div_table").find("button[name=new]").closest('th').css("width", "100px");
                //$("#div_table").find("button[name=new]").closest('th').css("min-width", "100px");

            });

        }
        function search() {
            var cb_pattern = get_cb("#cb_pattern");
            if (cb_pattern == "") {
                alert_error("حداقل یک الگو را انتخاب کنید");
                return "";
            }
            reqsvr("search", "pattern_id:'" + cb_pattern + "'", function (data) {
                load_tbl_btn(data.d, "table");
            });
        }

        function edit_table(o) {
            var el_code = $(o).closest('tr').attr("code");
            open_form_("../../page/poll/page_poll_event.aspx", 'ویرایش نظرسنجی', el_code, 'refresh');
        }

        function new_table() {
            open_form_("../../page/poll/page_poll_event.aspx", 'ایجاد نظرسنجی', '-1', 'refresh');
        }


        function delete_table(o) {
            var el_code = $(o).closest('tr');
            confirm_alert(function () {
                reqsvr("delete_event", "code:'" + $(el_code).attr("code") + "'", function (data) {
                    if (data.d == "ok") {
                        alert_success("نظرسنجی با موفقیت حذف شد");
                        refresh();
                    } else
                        alert_error(data.d);
                });
            });
        };
         
    </script>
</head>
<body>
    <form>
        <div class="dock-full container">
            <div class="btn-group  bg-menu">
                <button type="button" class="btn block collapsed" data-toggle="collapse" data-target="#div_filter" aria-expanded="false"><span class="glyphicon glyphicon-filter">&nbsp;</span>فیلتر</button>
            </div>
            <div id="div_filter" class="filter collapse" aria-expanded="false" style="height: 20px;">
                <div class="row">
                    <div>انتخاب الگو :</div>
                    <select id="cb_pattern" class="selectpicker " data-width="100%" data-size="10" multiple="multiple" data-actions-box="true" multiple data-selected-text-format="count > 3">
                    </select>
                </div>
                <div class="row align-center" style="border-top: solid 1px; margin-top: 5px; padding-top: 5px;">
                    <button type="button" class="btn btn-primary" onclick="search(this)"><span class="glyphicon glyphicon-search">&nbsp;</span>جستجو</button>&nbsp;
                </div>
            </div>
            <div class="dataTables_scrollBody" id="div_table"></div>
        </div>
    </form>
</body>
</html>
