﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_personnel_program_shift.aspx.cs" Inherits="TimeWork.page_personnel_program_shift" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/contextMenu/bootstrap-contextmenu.css" rel="stylesheet" />
    <link href="../../style/spinner/jquery-spinner.css" rel="stylesheet" />
    <link href="../../style/SelectTree/select2.css" rel="stylesheet" />
    <%--<link href="../../style/elementmultiselect/nu-selectable.css" rel="stylesheet" />--%>
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/contextMenu/bootstrap-contextmenu.js" type="text/javascript"></script>
    <script src="../../style/spinner/jquery-spinner.js" type="text/javascript"></script>
    <script src="../../style/SelectTree/select2.min.js" type="text/javascript"></script>
    <script src="../../style/draggableTouch/draggableTouch.js"></script>
    <script src="../../style/datatable/dataTables.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js" type="text/javascript"></script>
    <%--<script src="../../style/elementmultiselect/nu-selectable.js"></script>--%>

    <script src="../../script/FncTime.js" type="text/javascript"></script>
    <script src="../../script/FncDate.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>  
        var change_access = false;
        var prow = '-1';
        $(document).ready(function () {

            var array = initial_page(1000, 620);
            if (array != undefined)
                prow = array[0];

            if (prow == "")
                prow = parent.cur_prow;
            initial_stepper();
            reqsvr("loading", "prow:'" + prow + "'", function (data) {
                $("#cb_year").val(data.d[0].substring(0, 4));
                $("#cb_month").val(data.d[0].substring(5, 7));
                load_cb_tree("#cb_section", data.d[1]);
                $("#cb_section").select2('val', data.d[2]);
                refresh();
            });

            if (check_access("050302")) {
                $("#li_get_shift_other").removeClass("hide");
            }
            else
                $("#li_get_shift_other").remove();
            if (check_access("050301")) {
                $("#btn_save").removeClass("hide");
                $("#btn_cancel").removeClass("hide");
                change_access = true;
            }
            else {
                $("#btn_save").remove();
                $("#btn_cancel").remove();
            }
            $("#cb_month").on('change',
                function (e) {
                    refresh();
                });
            $("#cb_year").on('change',
                function (e) {
                    refresh();
                });
        });

        var xml_all_shifts;

        function refresh() {
            $("#context-shift").hide();
            reqsvr("load_personnel", "code:" + $("#cb_section").val() + ",year:" + $("#cb_year").val() + ",month:" + $("#cb_month").val(), function (data) {

                load_tbl(data.d[0], "personnel");
                xml_all_shifts = data.d[1];

                load_context_menu('#menu_shift', xml_all_shifts);
                $('#div_personnel').find('.btn-area').addClass("hide");
                var tr = $('#tbl_personnel tbody tr[code="' + prow + '"]');
                if (tr.length > 0) {
                    $(tr).addClass("selectedtr");
                    selected_changed(prow);
                }
                else {
                    tr = $('#tbl_personnel tbody').children('tr:first');
                    $(tr).addClass("selectedtr");
                    if (tr.length > 0) {
                        selected_changed(tr.attr("code"));
                    }
                    else
                        selected_changed(-1);

                }
                $("#tbl_personnel td").click(function () {
                    selected_changed($(this).closest('tr').attr("code"));
                });
            });

        }

        function load_context_menu(o, data) {
            d = $(data).find("mytable");
            $(o).empty();

            d.each(function () {
                if ($(this).find('disable').text().toLowerCase() == "false")
                    $(o).append($('<a class="next-td row w-300" tabindex="-1" enable="' + $(this).find('enable').text() + '"wgid="' + $(this).find('workgroupid').text() + '" val="' + $(this).find('code').text() + '"><div class="col-xs-8  " >' + $(this).find('name').text() + ' (' + $(this).find('mininame').text() + ')</div><div class="col-xs-4 align-left">' + $(this).find('daily_end').text() + ' - ' + $(this).find('daily_start').text() + '</div>' + ' </a>'));
            });
        }
        //$(function () {
        //    var selection = $('#div_grid').nuSelectable({
        //        items: '.item',
        //        selectionClass: 'nu-selection-box',
        //        selectedClass: 'nu-selected'
        //    });
        //});
        var cur_obj;

        function set_shift(shid) {

            if (shid == undefined || $(cur_obj).attr("shid") == shid) return;
            var row = search_xml(xml_all_shifts, shid);
            $(cur_obj).attr("shid", shid);
            $(cur_obj).attr("title", $(row).find("mininame").text());
            $(cur_obj).html($(row).find("name").text());
            $(cur_obj).parent().addClass('cell-changed');
            $(cur_obj).closest('tr').find('.btn_mini').removeClass("hide");

            var shiftkind = $(row).find("shiftkind_").text();
            var l = Time2Min($(row).find("daily_time").text());

            $(cur_obj).attr("d", shiftkind.substring(0, 1));
            $(cur_obj).attr("e", shiftkind.substring(1, 2));
            $(cur_obj).attr("n", shiftkind.substring(2, 3));
            $(cur_obj).attr("l", l);
            // calc_all($(cur_obj).closest('tr'), cur_obj);


        }
        function selected_changed(prow_) {
            wait_();
            if (prow_ == undefined) prow_ = -1;
            prow = prow_;
            var tr = $('#tbl_personnel tbody tr[code="' + prow_ + '"]');
            $("#div_pname").html("&nbsp;شماره پرسنل : <b>" + $(tr).find("td:eq(0)").text() + "</b>&nbsp;&nbsp; نام پرسنل : <b>" + $(tr).find("td:eq(1)").text() + "</b>&nbsp; سمت : <b>" + $(tr).find("td:eq(2)").text() + "</b>");
            reqsvr("load_calendar", "prow:" + prow_ + ",year:" + $("#cb_year").val() + ",month:" + $("#cb_month").val(), function (data) {
                $("#tbl_grid tbody").html(data.d[0]);
                $("#context-shift").draggableTouch();
                if (data.d[8] == "1")
                    $("#li_leave_draft").removeClass("hide");
                else
                    $("#li_leave_draft").remove();

                if (change_access)
                    $('.cell').contextmenu({
                        target: '#context-shift',
                        left_click: true,
                        onItem: function (obj, e) {
                            cur_obj = obj;
                            if ($(e.target).closest("a").attr("val") == '-999') {
                                open_form_('../../page/workgroup_shift/page_shift_list.aspx', 'لیست شیفت ها', '', 'set_shift');
                                return;
                            }
                            gotonext = 1;
                            var shid = $(e.target).closest("a").attr("val");
                            set_shift(shid);
                        },
                        before: function (obj, e) {
                            var w = GetPersianDayName($(e).attr("date"));
                            $("#lb_date").text(w + " - " + $(e).attr("date"));
                            $("#menu_shift a").addClass("hide");
                            $("#menu_shift").find("[wgid=" + $(e).attr("wgid") + "]").removeClass("hide");
                            $("#menu_shift").find("[val=0]").removeClass("hide");
                            $("#menu_shift a").removeClass("selected");
                            $("#menu_shift").find("[val=" + $(e).attr("shid") + "]").addClass("selected");
                        },
                        after: function (e) {
                            $(e).closest('td').next('td').click();

                        }
                    });
                //$('#tbl_grid').nuSelectable({
                //    items: '.item',
                //    selectionClass: 'nu-selection-box',
                //    selectedClass: 'nu-selected',
                //    autoRefresh: true
                //});
            });
        }


        function save() {
            var str = "";
            var date = [""];
            var shifts = [""];
            var shifts_old = [""];
            var i = 0;

            $("#tbl_grid .cell").each(function () {
                var dval = $(this).attr("dval").split('☺');
                date[i] = $(this).attr("date");
                shifts[i] = $(this).attr("shid");
                shifts_old[i] = dval[0];
                i = i + 1;
            });
            if (i == 0) return;
            if (str.length > 0) str = str.slice(1);
            reqsvr("save", "prow:" + prow + ",section_id:" + $("#cb_section").val() + ",year:" + $("#cb_year").val() + ",month:" + $("#cb_month").val() + ",date:" + JSON.stringify(date) + ",shifts:" + JSON.stringify(shifts) + ",shifts_old:" + JSON.stringify(shifts_old), function (data) {

                if (data.d == "ok") {
                    $("#tbl_grid .cell").parent().removeClass("cell-changed");
                    alert_success("ذخیره شد");

                }
                else {
                    alert_error(data.d);
                }
            });


        }
    </script>

</head>
<body>
    <form>

        <div class="btn-group w-full bg-menu">
            <button onclick="refresh()" type="button" class="btn btn-primary"><span class="glyphicon glyphicon-refresh"></span>&nbsp;انصراف&nbsp;</button>
            <button onclick="save()" type="button" class="btn btn-success"><span class="glyphicon glyphicon-floppy-disk"></span>&nbsp;ذخیره&nbsp;</button>

        </div>
        <div class="row pad  auto-height" style="overflow-y: hidden">
            <div class="col-sm-4 ">
                <div class="row">
                    <label>محل خدمت :</label>
                    <div class="  no-padding">
                        <input id="cb_section" type="hidden" class="search-result-box" onchange="refresh()" />
                    </div>
                </div>
                <div id="div_personnel" class="auto-height no-scroll">
                </div>
            </div>
            <%--<div class="  col-sm-8 auto-height border">

                <div class="row h-40 bold">
                    <div class="col-xs-1 w-75">شنبه</div>
                    <div class="col-xs-1 w-75">یکشنبه</div>
                    <div class="col-xs-1 w-75">دو شنبه</div>
                    <div class="col-xs-1 w-75">سه شنبه</div>
                    <div class="col-xs-1  w-75">چهار شنبه</div>
                    <div class="col-xs-1  w-75">پنج شنبه</div>
                    <div class="col-xs-1  w-75">جمعه</div>
                </div>


                <div id="div_grid" class="container-fluid  panel  ">
                </div>
            </div>--%>
            <div id="div_grid" class="  panel col-sm-8 auto-height border">
                <div id="div_pname"></div>
                <table id="tbl_grid" class="w-full table table-bordered">
                    <thead>
                        <tr class="h-40 bold">
                            <th class="w-75">شنبه</th>
                            <th class="w-75">یکشنبه</th>
                            <th class="w-75">دو شنبه</th>
                            <th class="w-75">سه شنبه</th>
                            <th class="w-75">چهار شنبه</th>
                            <th class="w-75">پنج شنبه</th>
                            <th class="w-75">جمعه</th>
                        </tr>
                    </thead>
                    <tbody class="container-fluid">
                    </tbody>

                </table>

            </div>
        </div>

        <div id="context-shift" class="DraggableDiv" style="position: absolute; z-index: 9999; top: 123px; left: 322px;">
            <ul class="dropdown-menu" role="menu" style="">
                <li style="text-align: center; background: #579; cursor: move; color: #fff; height: 30px" class="no-action pad5" id="lb_date"></li>
                <li class="divider no-action"></li>
                <li id="menu_shift" style="height: 250px; overflow-y: scroll">
                    <a tabindex="-1">null</a>
                </li>
                <li class="divider no-action"></li>
                <li class="divider no-action"></li>
                <li id="li_leave_draft" class="hide"><a href='#' tabindex="-1" val="-2">پیش نویس مرخصی</a></li>
                <li id="li_get_shift_other" class="hide"><a href='#' tabindex="-1" val="-999">فراخوانی از سایر گروهها</a></li>
            </ul>
        </div>
        <div class="footer  align-center">
            <button type="button" title="ماه قبل" class="btn btn-default glyphicon glyphicon-chevron-right" style="margin-left: -4px; margin-top: -3px; border-bottom-left-radius: 0; border-top-left-radius: 0;"
                onclick="prev_month()">
            </button>

            <select id="cb_month" name="month" class="form-control" style="width: 100px; display: inline; padding: 0">
                <option value="01">فروردین</option>
                <option value="02">اردیبهشت</option>
                <option value="03">خرداد</option>
                <option value="04">تیر</option>
                <option value="05">مرداد</option>
                <option value="06">شهریور</option>
                <option value="07">مهر</option>
                <option value="08">آبان</option>
                <option value="09">آذر</option>
                <option value="10">دی</option>
                <option value="11">بهمن</option>
                <option value="12">اسفند</option>
            </select>
            <input id="cb_year" name="year" type="number" readonly style="text-align: center; width: 80px" class="form-control" min="1380" max="1480" step="1" />

            <button type="button" title="ماه بعد" class="btn btn-default from-control glyphicon glyphicon-chevron-left" style="margin-right: -3px; margin-top: -3px; border-bottom-right-radius: 0; border-top-right-radius: 0;"
                onclick="next_month()">
            </button>
        </div>
    </form>
</body>
</html>
