﻿<%@ Page Language="C#" AutoEventWireup="true"
    CodeBehind="page_performance_point.aspx.cs" Inherits="TimeWork.page_performance_point" EnableSessionState="True" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/elastic-columns/elastic-columns.js"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>

    <script>   
        var event_id;
        $(document).ready(function () {
            var ar = initial_page(800, 600);
            event_id = ar[0];
            $("#img_picture").attr("src", ar[1]);
            $("#div_pname").html('<span>' + ar[2].replace("☺", "</br>").replace("☺", "</br>") + '</span>');
            if (ar[3] == "1")
                $("#div_save").removeClass("hide");
            else
                $("#div_save").remove();

            reqsvr("load", "event_id:" + event_id, function (data) {

                $("#div_question").html(data.d[0]);
                if (ar[3] == "0")
                    $("#div_question").find("input").disable();
                $('.columns').elasticColumns(
                    {
                        columns: 11,
                        minWidth: 70
                    });
                clac_sum();
                $('#div_question :radio').change(function () {
                    clac_sum();
                });
            });
        });

        function clac_sum() {
            var sum = 0;
            $("#div_question").find('tr').each(function () {
                if ($(this).find("input[name=n" + $(this).attr("code") + "]:checked").val() !== undefined) {

                    sum = + sum + (parseInt($(this).find("input[name=n" + $(this).attr("code") + "]:checked").val()) * parseInt($(this).attr("weight")));
                }
            });
            $("#sum_point").html(sum);
        }

        function save() {
            var data = "";
            var error = 0;
            $("#div_question").find('tr').each(function () {

                if ($(this).find("input[name=n" + $(this).attr("code") + "]:checked").val() == undefined) {
                    $(this).find("input[name=n" + $(this).attr("code") + "]").closest('.ack-list').addClass("border-error");
                    error = 1;
                } else {
                    $(this).find("input[name=n" + $(this).attr("code") + "]").closest('.ack-list').removeClass("border-error");
                }
                data = data + "☻" + $(this).attr("code") + "☺" + $(this).find("input[name=n" + $(this).attr("code") + "]:checked").val();
                var de = $(this).find("input[name=detail]");
                if (de.attr('force') == '1' && de.val() == "") {
                    de.closest('.ack-list').addClass("border-error");
                    error = 1;
                } else {
                    de.closest('.ack-list').removeClass("border-error");
                }
                data = data + "☺" + de.val();
            });
            if (error == 1) {
                alert_error("قسمت های مشخص شده را تکمیل کنید");

                return;
            }
            reqsvr("save", "event_id:" + event_id + " ,data:'" + data + "'", function (data) {
                if (data.d == "ok") {
                    call_fnc("'" + $("#sum_point").html() + "'");
                    alert_success("ثبت شد");
                    close();
                }
                else {
                    alert_error(data.d);
                }
            });
        }
    </script>
</head>

<body>
    <form>
        <div class="bg-dark">

            <table class="w-full h-70" style="background: #fbffe4">
                <tr>
                    <td class="w-70">
                        <img id="img_picture" src="#" alt="" width="65" height="65" class="img-circle pad3" onerror="this.src = '../../image/blank_profile.png'" />

                    </td>
                    <td>
                        <div id="div_pname" class=" f13" style="height: 65px; overflow-y: hidden"></div>
                    </td>
                    <td class="w-70">
                        <span id="sum_point" class="badge bg-crystal ltr" title="مجموع امتیازات داده شده توسط شما" style="height: 60px; width: 60px; border-radius: 50px; align-content: center; font-size: 25px; background-color: #ff6a00;">0</span>
                    </td>
                </tr>
            </table>

            <div id="div_question" class="auto-height">
            </div>
        </div>
        <div id="div_save" class="toolbar-footer hide">
            <button type="button" onclick="save()" class="btn btn-success  ">ثبت</button>
        </div>
    </form>
</body>
</html>
