﻿<%@ Page Language="C#" AutoEventWireup="true"
    CodeBehind="page_message.aspx.cs" Inherits="TimeWork.page_message" EnableSessionState="True" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>

    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../script/FncDate.js" type="text/javascript"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../style/mask/jquery.mask.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script> 
        var prow;
        $(document).ready(function () {
            var array = initial_tab();
            prow = array[0];
            initial_date();
            refresh();

        });

        function refresh() {
            search_btn("#btn_search", "", function () {

                $('#tbl_result tbody td:first-child').each(function () {
                    $(this).css("text-align", "center");
                    if ($(this).text() == "1")
                        $(this).html('<h4 title="فعال" class="glyphicon glyphicon-ok-sign green_" ></h4>');
                    else
                        $(this).html('<h4 title="غیر فعال" class="glyphicon glyphicon-minus-sign red_" ></h4>');
                });

                $('#tbl_result tbody tr td .glyphicon-pencil').each(function () {
                    $(this).parent().prepend('<button onclick="view_result(this)" class="btn btn-default glyphicon glyphicon-eye-open" type="button" title="نمایش سوابق" ></button>');;
                    $(this).closest("td").css("width", "100px");
                });

            });
        }

        function delete_result(o) {
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;

            confirm_alert(function () {

                reqsvr("delete", "code:'" + code + "'",
                    function (data) {
                        check_result_search(data.d);
                    });
            });
        };
        function edit_result(o) {
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;

            open_form_('page/message/page_message_new.aspx', "ویرایش پیام", prow + "&" + code, "refresh");

        };

        function new_result() {
            open_form_('page/message/page_message_new.aspx', "ثبت پیام", prow + "&0", "refresh");

        }
        function view_result(o) {
            var code = $(o).closest('tr').attr("code");
            if (code == "") return;

            open_form_('page/message/page_message_view_log.aspx', "سوابق مشاهده افراد", code, "");

        }
    </script>
</head>
<body>
    <form class="dock-full">
        <div class="btn-group">
            <button type="button" class="btn block" data-toggle="collapse" data-target=".collapse"><span class="glyphicon glyphicon-filter">&nbsp;</span>فیلتر</button>

        </div>

        <div id="div_filter" class="collapse filter">

            <div class="row">
                <div class="col-sm-6">
                    <div>از تاریخ :</div>
                    <input id="tb_sdate" name="sdate" type="text" class="form-control date" />
                </div>
                <div class="col-sm-6">
                    <div>تا تاریخ :</div>
                    <input id="tb_edate" name="edate" type="text" class="form-control date" />
                </div>
            </div>
            <div class="row">
                <br />
                <div>شرح :</div>
                <input name="detail" type="text" class="form-control" maxlength="500" />
            </div>
            <br />

            <div class="row align-center" style="border-top: solid 1px; margin-top: 5px; padding-top: 5px;">
                <button id="btn_search" type="button" value=" " class="btn btn-primary" onclick="search(this)"><span class="glyphicon glyphicon-search">&nbsp;</span>جستجو</button>&nbsp;
            </div>

        </div>

        <div id="div_result" class="panel  auto-height"></div>
    </form>
</body>
</html>
