﻿<%@ Page Language="C#"
    AutoEventWireup="true"
    CodeBehind="page_meet_monitoring.aspx.cs"
    Inherits="TimeWork.page_meet_monitoring"
    EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>
        var last_row = 0;
        $(document).ready(function () {
            initial_tab();

            last_row = "0";
            refresh(true); unwait_();
        });

        function refresh(l) {

            if (l == undefined) {
                l = false;
            }

            reqsvr2("get_monitor", " ", function (data) {
                $('#tbl_monitor tbody').html(data.d[0]);
                $('#cnt_all').html(data.d[1] + " نفر");
                $('#cnt_pre').html(data.d[2] + " نفر");
                $('#cnt_in').html(data.d[3] + " نفر");
                $('#cnt_ack').html(data.d[4] + " نفر");
                $('#cnt_out').html(data.d[6] + " نفر");
                $('[data-toggle="tooltip"]').tooltip();
                if (l == true)
                    statusTimerID = setTimeout(function () { refresh(true); }, 10000);
            });
        }

        function new_meet() {
            open_form_("../../page/meeting/page_meet.aspx", "ثبت ملاقات", "-1", "refresh");
        }
        function set_arrival(obj) {
            open_form_("../../page/meeting/page_meet_enter.aspx", "ثبت ورود", $(obj).closest("tr").attr("row"), "refresh");
        }
        function set_exit(obj) {
            open_form_("../../page/meeting/page_meet_exit.aspx", "ثبت خروج", $(obj).closest("tr").attr("row"), "refresh");
        }
        function show_meet(obj) {
            open_form_("../../page/meeting/page_meet_view.aspx", "روند انجام ملاقات", $(obj).closest("tr").attr("row"));
        }
        function print_meet(obj) {

        }
    </script>
</head>
<body>
    <form>

        <div class="row panel">
            <div class="col-xs-2">
                <button onclick="new_meet()" type="button" class="btn btn-info"><span class="glyphicon glyphicon-plus"></span><span class=" hidden-xs">ثبت ملاقات </span></button>
            </div>
            <div class="col-xs-2 ">
                <div class="form-control">
                    <span class="w3-large glyphicon glyphicon-asterisk gold_"></span>
                    <label class="w-100 hidden-xs">پیش ورود : </label>
                    <label id="cnt_pre" class=" bold  ">0</label>
                </div>
            </div>
            <div class="col-xs-2">
                <div class="form-control">
                    <span class="w3-large glyphicon glyphicon-log-in blue_"></span>
                    <label class="w-100 hidden-xs">داخل مجموعه : </label>
                    <label id="cnt_in" class="  bold  ">0</label>
                </div>
            </div>
            <div class="col-xs-2">
                <div class="form-control">
                    <span class="w3-large glyphicon glyphicon-check green_"></span>
                    <label class="w-100 hidden-xs">پاسخ داده : </label>
                    <label id="cnt_ack" class=" bold ">0</label>
                </div>
            </div>
            <div class="col-xs-2">
                <div class="form-control">
                    <span class="w3-large glyphicon glyphicon-log-out red_"></span>
                    <label class="w-100 hidden-xs">خروجی : </label>
                    <label id="cnt_out" class="  bold ">0</label>
                </div>
            </div>

            <div class="col-xs-2  ">
                <div class="form-control">
                    <span class="w3-large fa fa-users  "></span>
                    <label class="w-100 hidden-xs">تعداد کل میهمان : </label>
                    <label id="cnt_all" class="bold  ">0</label>
                </div>
            </div>
        </div>

        <div class=" w-full auto-height">
            <table id='tbl_monitor' class=' table-striped table-bordered table-hover table-condensed w-full'>
                <thead>
                    <tr>
                        <th class="w-25">وضعیت</th>
                        <th class="w-200">نام میهمان</th>
                        <th class="w-100">زمان مراجعه</th>
                        <th class="w-100">زمان ورود</th>
                        <th class="w-200">ملاقات شوندگان</th>
                        <th class="w-100">زمان خروج</th>
                        <th class="w-500">توضیحات</th>
                        <th class="w-50"></th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>

        </div>

    </form>
</body>
</html>
