﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_meet.aspx.cs" Inherits="TimeWork.page_meet" EnableSessionState="True" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>

    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../style/mask/jquery.mask.min.js" type="text/javascript"></script>
    <script src="../../script/FncDate.js" type="text/javascript"></script>
    <script src="../../script/FncTime.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>

    <script>
        var code = "-1";
        $(document).ready(function () {
            var ar = initial_page(800, 600);
            code = ar[0];
            load();
            $("#tb_guest_over_cnt").focusout(function () {
                var max = parseInt($(this).attr('max'));
                var min = parseInt($(this).attr('min'));
                if ($(this).val() > max) {
                    $(this).val(max);
                }
                else if ($(this).val() < min) {
                    $(this).val(min);
                }
            });
        });
        function load(de) {
            reqsvr("load", "code:" + code,
                function (data) {
                    load_cb_not_select("#cb_guest", data.d[0]);
                    load_cb("#cb_meet_kind", data.d[1]);
                    load_cb_not_select("#cb_car_kind", data.d[2]);
                    load_cb_not_select('#cb_personel', data.d[3]);
                    $('[name=date]').val(data.d[4]);
                    if (de != undefined)
                        $("#cb_guest").val(de);
                    if (data.d[5] != "") {
                        set_XML_div("#main", data.d[5]);
                        guests = data.d[6].split('☺');
                        for (var i = 0; i < guests.length; i++) {

                            add_guest(guests[i]);
                        }
                        $("#tbl_list tbody").append(data.d[7]); 
                    }
                });
        }
        function save() {
            if (check_force_error("#main")) return;
            reqsvr("save", "code:" + code + ", data:'" + get_data_div("#main") + "'",
                function (data) {
                    if (data.d == "ok") {
                        alert_success("ثبت انجام شد");
                        call_fnc();
                        close();
                    }
                    else
                        alert_error(data.d);
                });
        }
        function list_guest() {
            open_form_("../../page/meeting/page_guest_list.aspx", "لیست میهمان", "-1&0", "", "load");
        }
        function new_guest() {
            open_form_("../../page/meeting/page_guest.aspx", "تعریف میهمان", "-1&0", "load");
        }
        function add_to_list() {

            if ($("#tbl_list tbody").find("input[value='" + $("#cb_personel").val() + "']").length > 0) {
                alert_error("تکراری است");
                return;
            }
            reqsvr("get_personel_info", "prow:'" + $("#cb_personel").val() + "'",
                function (data) {
                    if (data.d[0] == "ok")
                        $("#tbl_list tbody").append(data.d[1]);
                    else
                        alert_error(data.d[0]);
                });
        }

        function delete_list(o) {
            $(o).closest('tr').remove();
        }

        function add_guest_over() {
            if ($("#tb_guest_over").val() == "") return;
            if ($("#div_guest_over").find("input[value='" + $("#tb_guest_over").val() + "']").length > 0) {
                alert_error("تکراری است");
                return;
            }
            add_guest($("#tb_guest_over").val());
            $("#tb_guest_over").val('');
        }
        function add_guest(guest) {

            $("#div_guest_over").append('<div class="row"> <input name="guest_over"   type="text" class="form-control " style="width: calc(100% - 33px);" value="' + guest + '" />' +
                ' <button onclick = "remove_guest_over(this)" type = "button" class= "btn btn-default red" title = "حذف" > ' +
                '<span class="glyphicon glyphicon-trash red"></span></button></div>');

        }
        function remove_guest_over(o) {
            $(o).closest('div').remove();
        }
    </script>
</head>
<body>
    <form class="panel">
        <div id="main" class="auto-height pad5">
            <div class="row ">
                <div class="col-sm-2">
                    <label>انتخاب میهمان :</label>
                </div>
                <div class="col-sm-10">
                    <select id="cb_guest" name="guest_id" class="selectpicker" data-width="calc(100% - 66px)" data-size="10" data-live-search="true">
                    </select>
                    <button onclick="list_guest()" type="button" class="btn btn-default" title="لیست میهمان ها"><span class="glyphicon glyphicon-option-horizontal"></span></button>
                    <button onclick="new_guest()" type="button" class="btn btn-info" title="تعریف میهمان جدید"><span class="glyphicon glyphicon-plus"></span></button>
                </div>

            </div>
            <div class="row ">
                <div class="row col-xs-6">

                    <div class="col-sm-4">
                        <label>زمان مراجعه :</label>
                    </div>
                    <div class="col-sm-8">
                        <input name="time" type="text" class="form-control time" value="08:00" />
                        <input name="date" id="date" type="text" class="form-control date" />
                    </div>
                </div>
                <div class="row col-xs-6">
                    <div class="col-sm-4">
                        <label>زمان تقریبی حضور :</label>
                    </div>
                    <div class="col-sm-8">
                        <input name="lenght" type="text" class="form-control time" value="01:00" />
                    </div>
                </div>

            </div>
            <div class="row ">
                <div class="col-xs-12">

                    <div class="col-sm-2">
                        <label>پذیرایی :</label>
                    </div>
                    <div class="col-sm-10">
                        <input name="food_reserve1" type="checkbox" class="form-control" /><label>صبحانه</label>
                        <input name="food_reserve2" type="checkbox" class="form-control" /><label>ناهار</label>
                        <input name="food_reserve3" type="checkbox" class="form-control" /><label>شام</label>
                        <input name="food_reserve4" type="checkbox" class="form-control" /><label>سحری</label>
                        <input name="food_reserve5" type="checkbox" class="form-control" /><label>افطاری</label>
                        <input name="food_reserve6" type="checkbox" class="form-control" /><label>پذیرایی ویژه</label>
                    </div>
                </div>

                <div class="col-xs-6 hide">

                    <div class="row ">
                        <div class="col-sm-2">
                            <label>نوع ملاقات :</label>
                        </div>
                        <div class="col-sm-10">
                            <select id="cb_meet_kind" name="meet_kind_id" class="form-control"></select>
                        </div>
                    </div>
                </div>

            </div>
            <div class="well well-sm">
                <div class="row ">
                    <div class="col-sm-2">
                        <label>نام همراه :</label>

                    </div>
                    <div class="col-sm-10">
                        <input id="tb_guest_over"   type="text" class="form-control" style="width: calc(100% - 33px);" />
                        <button onclick="add_guest_over()" type="button" class="btn btn-info" title="اضافه">
                            <span class="glyphicon glyphicon-plus"></span>
                        </button>
                        <div id="div_guest_over">
                        </div>

                    </div>

                </div>
            </div>
            <div class="well well-sm">
                <div class="row ">

                    <label>اطلاعات خودرو :</label>


                    <div class="row">

                        <div class="col-sm-6">
                            <label class="w-100">شماره پلاک  :</label>
                            <div class="  plate" style="font-size: 15px;">
                                <input name="car_plaque1" type="number" max="99" min="11" class="w-40 no-border align-center" />
                                <input name="car_plaque2" type="number" max="999" min="111" class="w-40 no-border align-center" />
                                <select name="car_plaque3" class="no-border align-center">
                                    <option value="   " selected="selected"></option>
                                    <option value="الف">الف</option>
                                    <option value="ب">ب</option>
                                    <option value="پ">پ</option>
                                    <option value="ت">ت</option>
                                    <option value="ث">ث</option>
                                    <option value="ر">ر</option>
                                    <option value="ز">ز</option>
                                    <option value="ج">ج</option>
                                    <option value="د">د</option>
                                    <option value="س">س</option>
                                    <option value="ش">ش</option>
                                    <option value="ص">ص</option>
                                    <option value="ط">ط</option>
                                    <option value="ف">ف</option>
                                    <option value="ق">ق</option>
                                    <option value="ک">ک</option>
                                    <option value="ع">ع</option>
                                    <option value="ل">ل</option>
                                    <option value="م">م</option>
                                    <option value="ن">ن</option>
                                    <option value="و">و</option>
                                    <option value="ه">ه</option>
                                    <option value="ی">ی</option>
                                    <option value="D">D</option>
                                    <option value="S">S</option>


                                </select>
                                <input name="car_plaque4" type="number" max="99" min="11" class="w-40 no-border align-center" />
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <label class="w-100">نوع خودرو  :</label>
                            <select id="cb_car_kind" name="car_kind_id" class="selectpicker" data-width="calc(100% - 33px)" data-size="10" data-live-search="true">
                            </select>
                            <button onclick="show_table('car_kind','نوع خودرو')" type="button" class="btn btn-default" title="لیست خودروها"><span class="glyphicon glyphicon-option-horizontal"></span></button>
                        </div>
                    </div>


                </div>
            </div>
            <div class="well well-sm">
                <div class="row">
                    <div class="col-sm-2">
                        <label>انتخاب ملاقات شونده :</label>
                    </div>
                    <div class="col-sm-10">
                        <select id="cb_personel" class="selectpicker" data-width="calc(100% - 33px)" data-size="10" data-live-search="true">
                        </select>
                        <button onclick="add_to_list()" type="button" class="btn btn-info" title="اضافه">
                            <span class="glyphicon glyphicon-plus"></span>
                        </button>
                    </div>
                </div>
                <div class="row">

                    <table id="tbl_list" class="table   table-striped table-bordered  ">
                        <thead>
                            <tr>
                                <th class="w-150">شماره پرسنلی</th>
                                <th>نام پرسنل</th>
                                <th>محل خدمت</th>
                                <th>سمت</th>
                                <th class="w-25"></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row ">
                <div class="col-sm-2">
                    <label>توضیحات :</label>
                </div>
                <div class="col-sm-10">
                    <input name="register_detail" type="text" class="form-control" />
                </div>
            </div>
        </div>

        <div class="toolbar-footer">
            <button onclick="save()" type="button" class="btn btn-success ">ذخیره</button>
        </div>
    </form>
</body>
</html>
