﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_request_time.aspx.cs"
    Inherits="TimeWork.page_request_time" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/timepicker/bootstrap-clockpicker.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../style/timepicker/bootstrap-clockpicker.min.js" type="text/javascript"></script>
    <script src="../../script/FncDate.js" type="text/javascript"></script>
    <script src="../../style/mask/jquery.mask.min.js" type="text/javascript"></script>
    <script src="../../script/FncTime.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script src="../../script/mail.js" type="text/javascript"></script>
    <script type="text/javascript">
        var uid;
        var edit_row;
        $(document).ready(function () {
            initial_date_ok = true;
            var arr = initial_page(450, 450);
            uid = arr[0];
            edit_row = arr[1];
            //initial_time_picker();
            load_mail_adv(6);
            reqsvr("load", "", function (data) {
                if (data.d[0] == "1")
                    $('#div_multi_time').removeClass("hide");
                else
                    $('#div_multi_time').addClass("hide");
            });

            if (edit_row == 0 || edit_row == -1 || edit_row == undefined) {
                if (edit_row == -1) {
                    selectpicker_disable('#cb_sender');
                }
                $('#tb_date').val(arr[2]);
                edit_row = 0;
                load_sender();
                //initial_cb_personel('#cb_sender', parent.uid);
                get_shift_date();
                change_one_two();
            }
            else {
                reqsvr("load_mail", "row:'" + edit_row + "'",
                    function (data) {
                        if (data.d[0] == "ok") {
                            var xml = XMLparse(data.d[1]);
                            var findrows = xml.find("mytable");
                            $.each(findrows, function () {
                                var prow = $(this).find('prow').text();
                                var pname = $(this).find('pname').text();
                                load_sender(prow, pname);
                                $('#tb_date').val($(this).find('sdate').text());
                                get_shift_date();
                                $('#tb_stime').val($(this).find('stime').text());
                                if ($(this).find('etime').text() != "") {
                                    $('#chb_multi_time').prop('checked', true);
                                    $('#tb_etime').val($(this).find('etime').text());
                                }
                                change_one_two();
                                $('#tb_detail').val($(this).find('detail').text());
                            });
                        } else {
                            alert_error(data.d[0]);
                            close();
                        }
                    });
            }
            $("#cb_sender").on('changed.bs.select',
                function (e, clickedIndex, newValue, oldValue) {
                    get_shift_date();
                });
            initial_date_mask();

            var objCal1 = new PesianDate.persianCalendar('tb_date', {
                onchange: function (date) {
                    if (date) {
                        get_shift_date();
                    } else {
                        //alert_error('تاریخ ابتدا وارد شده نادرست است');
                    }
                }
            });
            unwait_();
        });


        function change_one_two() {
            mul_time_info();
            if ($("#chb_multi_time")[0].checked) {
                $('#lb_stime').text('از ساعت :');
                $('#div_etime').removeClass('hide');
                $('#div_lenght').removeClass('hide');
                $('#tb_etime').attr('force', "1");
            }
            else {
                $('#lb_stime').text('ساعت :');
                $('#div_etime').addClass('hide');
                $('#div_lenght').addClass('hide');
                $('#tb_etime').attr('force', "0");
                $("#next_day_etime").addClass("hide");
            }
        }

        function mul_time_info_() {
            if ($("#chb_multi_time")[0].checked) {
                var l = BetweenTimeMin($("#tb_stime").val(), $("#tb_etime").val());

                if (l < 0) {
                    $("#next_day_etime").removeClass("hide");
                    $("#tb_lenght").val(Min2Time(1440 + l));
                }
                else {
                    $("#next_day_etime").addClass("hide");
                    $("#tb_lenght").val(BetweenTime($("#tb_stime").val(), $("#tb_etime").val()));

                }
            }
            else {
                $("#next_day_etime").addClass("hide");
            }

        }
    </script>

</head>
<body>
    <form>
        <div id="div_main" class="pad5    row">
            <input id="request_id" name="request_id" type="hidden" value="6" />

            <div class="col-sm-6" id="div_sender">
                <span>متقاضی : <span class="red_">*</span></span>
                <select id="cb_sender" name="sender" class="selectpicker" data-width="100%" data-size="10" data-live-search="true" force="1"></select>
            </div>
            <div class="row">
                <div class="col-xs-5">
                    <span>تاریخ : <span class="red_">*</span></span>
                    <br />
                    <input id="tb_date" name="sdate" type="text" class="form-control date" force="1" />
                </div>
                <div class="col-xs-7">
                    <span id="">وضعیت شیفت :</span>
                    <br />
                    <input id="lb_day_shift" type="text" class="form-control" readonly="readonly" />
                    <input id="tb_shift_id" type="hidden" name="shift_id" readonly="readonly" />

                </div>
            </div>
            <div id="div_multi_time" class="row hide">
                <div class="col-xs-12">

                    <input id="chb_multi_time" name="multi_time" type="checkbox" class="form-control  " value="تردد دوتایی " onchange="change_one_two()" />&nbsp;<span>تردد دوتایی  </span>

                </div>
            </div>
            <div class="row">
                <div class="col-xs-4">
                    <span id="lb_stime">ساعت : </span><span class="red_">*</span>
                    <input id="tb_stime" name="stime" type="text" class="form-control time" value="" force="1" onchange="mul_time_info_()" />
                </div>
                <div id="div_etime" class="col-xs-4 hide">
                    <span>تا ساعت : <span class="red_">*</span></span>
                    <input id="tb_etime" name="etime" type="text" class="form-control time" value="" force="1" onchange="mul_time_info_()" />
                </div>
                <div id="div_lenght" class="col-xs-4 hide">
                    <span>مدت : </span>
                    <br />
                    <input id="tb_lenght" type="text" class="form-control w-50" value="00:00" readonly />
                </div>
            </div>

            <div id="next_day_etime" class="col-sm-12 hide  align-center lbl_warn">
                <span>توجه : ساعت انتها در روز بعد ثبت میشود
                </span>

            </div>

            <div class="row col-sm-12  no-padding no-margin hide" id="div_adv" style="background-color: #e5f1f1; padding-bottom: 20px !important;"></div>

        </div>
        <div class="toolbar-footer">
            <button type="button" class="btn btn-success glyphicon glyphicon-send " onclick="save_mail_adv()"><span>ارسال</span></button>
        </div>
    </form>
</body>
</html>
