﻿<%@ Page Language="C#"
    AutoEventWireup="true"
    CodeBehind="page_monitoring.aspx.cs"
    Inherits="TimeWork.page_monitoring"
    EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>
        var first_row;
        var last_row;
        $(document).ready(function () {
            initial_tab();
            first_row = "0";
            last_row = "0";

            reqsvr("get_monitor", "first_row:'',last_row:''", function (data) {
                var xml = XMLparse(data.d);
                var findcolumns = xml.find("columns");
                var headers = [];
                var rows = [];
                //column
                headers.push("<thead><tr>");
                $.each(findcolumns, function () {
                    headers.push("<th style=\"width:" + $(this).find("width").text() + "\"  > " + $(this).find("caption").text() + " </th>");
                });
                headers.push("</tr></thead>");
                rows.push("<tbody>" + set_data(data, true, true) + "</tbody>");
                var top = "<table id='tbl_monitor' class='table-striped table-bordered table-hover table-condensed w-full'>";
                var bottom = "</table>";
                $('#div_monitor').html(top + headers.join("") + rows.join("") + bottom);
                refresh();
            });
        });

        function refresh() {
            update();
            reqsvr2("get_monitor", "first_row:'" + first_row + "',last_row:''"
                , function (data) {
                    $('#tbl_monitor tbody tr:first').before(set_data(data, true, false));
                    fix_header_only = true;
                    set_datatable('#tbl_monitor');
                    statusTimerID = setTimeout(function () { refresh(); }, 10000);
                    set_datatable('#tbl_monitor');
                });


        }


        function btn_add_10_onclick() {

            reqsvr2("get_monitor", "first_row:'', last_row:'" + last_row + "'",
                function (data) {
                    $('#tbl_monitor tbody tr:last').after(set_data(data, false, true));

                });
        }


        function set_data(data, set_first, set_last) {
            var xml = XMLparse(data.d);
            var findrows = xml.find("mytable");
            var findcolumns = xml.find("columns");
            var rows = [];

            if (findrows.length > 0 && set_first)
                first_row = "0";
            $.each(findrows, function () {
                var row_ = $(this);
                rows.push('<tr row="' + row_.find("mrow").text() + '">');
                if (first_row == "0" && set_first)
                    first_row = row_.find("mrow").text();
                if (set_last)
                    last_row = row_.find("mrow").text();
                $.each(findcolumns, function () {
                    var name = $(this).find("name").text();
                    switch (name) {

                        case "icon":
                            rows.push("<td title='" + row_.find("status").text() + "' class='align-center' ><span class='w3-xlarge " + row_.find(name).text() + "'></span> </td>");
                            break;
                        default:
                            rows.push("<td>" + row_.find(name).text() + "</td>");
                            break;
                    }
                });
                rows.push("</tr>");
            });
            return rows.join("");
        }

        function update() {
            reqsvr2("get_update", "first_row:'" + first_row + "', last_row:'" + last_row + "'",
                function (data) {
                    var xml = XMLparse(data.d);
                    var findrows = xml.find("mytable");

                    var rows = [];

                    $.each(findrows, function () {
                        var row_ = $(this);
                        $('#tbl_monitor tbody').find("[row=" + row_.find("mrow").text() + "]").each(function () {

                            $(this).find('td:eq(0)').html('<span class="w3-xlarge ' + row_.find("icon").text() + '"></span>');
                            $(this).find('td:eq(0)').attr('title' + row_.find("status").text());
                            $(this).find('td:eq(2)').html(row_.find("datetime_ack").text());
                            $(this).find('td:eq(4)').html(row_.find("name_reciver").text());

                        });

                    });

                });

        }
    </script>
</head>
<body>
    <form>
         
            <div id="div_monitor" class="w-full  auto-height ">
            </div>
        
        <div class="footer h-40">
            <input id="btn_add_10" type="button" style="margin: 5px" class="btn btn-primary" value="10 مورد قبلی"
                onclick="return btn_add_10_onclick()" />
        </div>
    </form>
</body>
</html>
