﻿<%@ Page Language="C#"
    AutoEventWireup="true"
    CodeBehind="page_cartabl_monitoring.aspx.cs"
    Inherits="TimeWork.page_cartabl_monitoring"
    EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script> 
        $(document).ready(function () {
            initial_page(800, 600);
            load();

        });



        function load() {

            if (check_access("020401")) {
                $("#div_accept").removeClass("hide");
            } else
                $("#div_accept").remove();

            reqsvr("load", "", function (data) {
                load_tbl(data.d, "monitor");
                $("#tbl_monitor tbody tr:first").addClass("selectedtr");

                $("#tbl_monitor tbody tr td").click(function () {
                    change_monitor($(this).closest("tr").attr('code'));
                });
                if ($('#tbl_monitor tbody').children('tr:first').length > 0)
                    change_monitor($('#tbl_monitor tbody').children('tr:first').attr('code'));
            });
        }

        function load_admin() {

            $("#tbl_monitor_sub  tbody tr").each(function () {
                if ($(this).find('input[type="checkbox"]').is(':checked')) {
                    var code = $(this).attr('code');
                    $("#tbl_monitor_sub tbody").find("tr[code=" + code + "]").remove();
                   
                }
            });

            reqsvr("load_admin", "prow:" + tbl_cur_row("#tbl_monitor"), function (data) {
                var tr = tbl_cur_tr("#tbl_monitor");
                if (data.d == "") { tr.remove(); }
                else { $(tr).find("td").eq(3).html(data.d); }
            });
        }
        function change_monitor(prow) {
            if (prow == undefined) return;
            reqsvr("get_list", "prow:" + prow, function (data) {
                if (check_access("020401"))
                    load_tbl_chb(data.d, "monitor_sub", "mrow");
                else load_tbl(data.d, "monitor_sub");
            });
        }

        function deny() {
            var mrow = "";
            $("#tbl_monitor_sub  tbody tr").each(function () {
                if ($(this).find('input[type="checkbox"]').is(':checked')) {
                    mrow = mrow + "," + $(this).attr('code');
                }
            });
            if (mrow == "") return;
            reqsvr("../../service/ws_mail.asmx/save_cancel_admin",
                "mrow:'" + mrow + "'",
                function (data) {
                    alert_message("پاسخ شما با موفقیت ارسال گردید");
                    load_admin();
                });
        }

        function accept() {
            var mrow = "";
            $("#tbl_monitor_sub  tbody tr").each(function () {
                if ($(this).find('input[type="checkbox"]').is(':checked')) {
                    mrow = mrow + "," + $(this).attr('code');
                }
            });

            if (mrow == "") return;
            reqsvr("../../service/ws_mail.asmx/save_accept_admin", "mrow:'" + mrow + "'",
                function (data) {
                    alert_success("پاسخ شما با موفقیت ارسال گردید");
                    load_admin();
                });
        }
    </script>
</head>
<body>
    <form>
        <div>
            <button type="button" title=" به روز رسانی " class="btn btn-primary glyphicon glyphicon-refresh" onclick="load()">
            </button>
        </div>
        <div class="row">

            <div class="col-xs-4 bg-gray">
                <div id="div_monitor" class=" auto-height no-scroll">
                </div>
            </div>
            <div class="col-xs-8">
                <div id="div_accept" class="btn-group  bg-menu hide">
                    <button class="btn btn-success" type="button" onclick="accept()"><span class=" glyphicon glyphicon-ok  ">&nbsp;</span>تائید نهایی</button>
                    <button class="btn btn-danger" type="button" onclick="deny()"><span class=" glyphicon glyphicon-remove  ">&nbsp;</span>عدم تایید</button>
                </div>
                <div id="div_monitor_sub" class=" auto-height  no-scroll ">
                </div>
            </div>

        </div>


    </form>
</body>
</html>
