﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_upsert_location.aspx.cs" Inherits="TimeWork.location.page_upsert_location" %>


<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script type="text/javascript" src="../../script/jquery.min.js"></script>
    <script type="text/javascript" src="../../style/bootstrap/bootstrap.min.js"></script>
    <script type="text/javascript" src="../../script/fnc.js"></script>
    <script type="text/javascript" src="../../script/jquery.validate.min.js"></script>


    <script type="text/javascript">
        var uid;
        var edit_row;
        let locationGuid_;
        let lat, lng;
        $(document).ready(function () {
            var ar = initial_page(400, 600);

            //console.log(ar);

            let location = $.parseJSON(ar);


            locationGuid_ = (location.locationGuid) ?? "";
            lat = (location.lat) ?.trim();
            lng = (location.lng) ?.trim();
            isMoveLocation = false;

            //isNewLocation = (location.isNewLocation) ?? false;


            $("#locationLat").val(lat);
            $("#locationLot").val(lng);



            switch (location.locationStatus) {

                case "0"://new

                    $('#chkEnableDiv').hide();
                    $("#selectDiv").hide();

                    break;

                case "1": //edit

                    $("#selectDiv").hide();

                    break;

                case "2": //move


                    isMoveLocation = true;

                    //$('#chkEnableDiv').css("display", "none");
                    //$('#locationDistanceDiv').css("display", "none");
                    //$('#locationTelDiv').css("display", "none");
                    //$('#locationLatDiv').css("display", "none");
                    //$('#locationLotDiv').css("display", "none");
                    //$('#locationAddressDiv').css("display", "none");


                    $('#chkEnableDiv').hide();
                    $('#locationDistanceDiv').hide();
                    $('#locationTelDiv').hide();
                    $('#locationLatDiv').hide();
                    $('#locationLotDiv').hide();
                    $('#locationAddressDiv').hide();
                    $('#locationDetailDiv').hide();

                    reqsvr("Load_locations", "",
                        function (data) {
                            if (data.d[0] === 'ok') {

                                //$("#selectLocations").find("option#1").attr("selected", true);

                                $("#selectLocations").select2(
                                    {
                                        data: $.parseJSON(data.d[1]),
                                        dir: 'rtl',
                                        placeholder: "جستجو",
                                        formatNoMatches: "هیچ موردی یافت نشد",
                                        formatAjaxError: "خطا در اطلاعات",
                                        multiple: false,
                                        width: '100%',
                                        selectOnBlur: false
                                    });

                                // $('#selectLocations').val('1'); // Select the option with a value of 'US'
                                $('#selectLocations').trigger('change'); // Notify any JS components that the value changed
                            };

                        });
                    break;

                default:
                    break;
            }

            // #region فعال/غیرفعال سازی موقعیت
            $('#chkLocationEnable').on('change', () => {
                if ($('#chkLocationEnable').is(":checked")) {
                    $('#lblLocationEnable').text('فعال');
                    locationEnable = '1';
                }
                else {
                    $('#lblLocationEnable').text('غیرفعال');
                    locationEnable = '0';
                }
            })

            // #endregion 



            // #region مقدار دهی در ویرایش موقعیت

            $('input[name="locationName"]').val((location.locationName) ?.trim());
            $('#locationDistance').val((location.locationDistance) ?.trim());
            $("#locationLat").val((location.lat) ?.trim());
            $("#locationLot").val((location.lng) ?.trim());
            $('input[name="locationTel"]').val((location.locationTel) ?.trim());
            $('textarea[name="locationAddress"]').val((location.locationAddress) ?.trim());
            $('textarea[name="locationDetail"]').val((location.locationDetail) ?.trim());

            if (location.locationEnable === '1') {
                $('#lblLocationEnable').text('فعال');
                $('#chkLocationEnable').attr("checked", true);
            } else {
                $('#lblLocationEnable').text('غیرفعال');
                $('#chkLocationEnable').attr("checked", false);
            }
            // #endregion



            unwait_();


        });


        function save() {

            // #region اعتبار سنجی فرم

            var locationModalFormValidate = $("#frmLocation").validate({
                rules: {
                    locationName: {
                        required: true,
                        minlength: 3,
                        maxlength: 32
                    },
                    locationDistance: {
                        required: true,
                        minlength: 1
                    },
                    locationTel: {
                        required: false,
                        minlength: 11,
                        maxlength: 11
                    },
                    locationDetail: {
                        required: false,
                        maxlength: 64
                    },
                    locationAddress: {
                        required: false,
                        maxlength: 256
                    }
                },
                messages: {
                    locationName: {
                        required: "لطفاً نام موقعیت را وارد کنید",
                        minlength: "حداقل 3 کاراکتر",
                        maxlength: "نام وارد شده بیش از حد مجاز است"
                    },
                    locationDistance: {
                        required: "لطفاً حدود شعاع را وارد کنید",
                        minlength: "حداقل یک عدد",
                    },
                    locationTel: {
                        required: "تلفن وارد شده اشتباه است",
                        minlength: "تلفن 11 رقم است",
                    },
                    locationDetail: {
                        maxlength: "توضیحات وارد شده بیش از حد مجاز است",
                    },
                    locationAddress: {
                        maxlength: "آدرس وارد شده بیش از حد مجاز است",
                    }
                },

                highlight: function (element) {
                    $(element).closest('.form-group').addClass('text-danger');
                },
                unhighlight: function (element) {
                    $(element).closest('.form-group').removeClass('text-danger');
                },
                errorElemen: 'span',
                errorClass: 'text-danger',
                errorPlacement: (error, element) => {
                    if (element.parent('.form-control').length) {
                        error.insertAfter(element.parent());
                    } else {
                        error.insertAfter(element);
                    }
                }



            });

            // #endregion



            if ($("#frmLocation").valid()) {

                let LocationEnable = $("#chkLocationEnable").prop('checked') ? 1 : 0;
                let locationName = $("#locationName").val();
                let locationDistance = $("#locationDistance").val();
                let locationTel = $("#locationTel").val();
                let locationAddress = $("#locationAddress").val();
                let locationDetail = $("#locationDetail").val();
                let locationLat = $("#locationLat").val();
                let locationLot = $("#locationLot").val();


                if (isMoveLocation)// = true;
                {
                    locationGuid_ = $("#selectLocations").val();
                }
                //location.locationEnableVisible === 'true'

                call_fnc("'" + locationName + "','" + locationDistance + "','" + locationTel + "','" + locationAddress + "','" + locationDetail + "','" + LocationEnable + "','" + locationGuid_ + "','" + locationLat + "','" + locationLot + "'");//+ "','" + isMoveLocation
                close();
            }

        }


    </script>

</head>
<body>

    <form class="needs-validation" id="frmLocation" novalidate="novalidate">

        <div id="div_main" class="row" style="padding: 5px">

            <div class="checkboxes custom-control custom-checkbox" id="chkEnableDiv">
                <label for="chkLocationEnable" class=" my-5 ">
                    <input type="checkbox" class="custom-control-input" name="chkLocationEnable" id="chkLocationEnable" value="" />
                    <span id="lblLocationEnable"></span>
                </label>
            </div>



            <div class="form-group mb-3">
                <label for="locationName">نام موقعیت</label>
                <input type="text" class="form-control" name="locationName" id="locationName" placeholder="نام موقعیت (اجباری)" value="" />
            </div>

            <div class="form-group mb-3">
                <label for="locationDistance">حدود شعاع (متر)</label>
                <input type="number" class="form-control ltr" name="locationDistance" id="locationDistance" placeholder="حدود شعاع (اجباری)" />
            </div>


            <div class="form-group mb-3">
                <label for="locationTel">تلفن</label>
                <input type="tel" class="form-control ltr" name="locationTel" id="locationTel" placeholder="تلفن (اختیاری) 09123456789" />
            </div>


            <div class="form-group mb-3" id="locationLatDiv">
                <label for="locationLat">عرض جغرافیایی (Lat)</label>
                <input type="number" min="0" value="0" step="0.000001" class="form-control ltr" name="locationLat" id="locationLat" placeholder="latitude مقدار" />
            </div>


            <div class="form-group mb-3" id="locationLotDiv">
                <label for="locationLot">طول جغرافیایی (Lon)</label>
                <input type="number" min="0" value="0" step="0.000001" class="form-control ltr" name="locationLot" id="locationLot" placeholder="longitude مقدار" />
            </div>


            <div class="form-group mb-3">
                <label for="locationAddress">آدرس</label>
                <textarea class="form-control" name="locationAddress" id="locationAddress" placeholder="آدرس (اختیاری)"></textarea>
            </div>

            <div class="form-group mb-3">
                <label for="locationDetail">توضیحات</label>
                <textarea class="form-control" name="locationDetail" id="locationDetail" placeholder="توضیحات (اختیاری)"></textarea>
            </div>


        </div>
        <div class="toolbar-footer">
            <button type="button" class="btn btn-success glyphicon glyphicon-save " onclick="save()"><span>ذخیره</span></button>
        </div>

    </form>

</body>
</html>
