﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_personnel_location_single.aspx.cs" Inherits="TimeWork.personnel_single.page_personnel_single" %>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link rel="stylesheet" href="../../style/select/bootstrap-select.css" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script type="text/javascript" src="../../script/jquery.min.js"></script>
    <script type="text/javascript" src="../../style/bootstrap/bootstrap.min.js"></script>
    <script type="text/javascript" src="../../style/calendar/js-persian-cal.min.js"></script>
    <script type="text/javascript" src="../../style/select/bootstrap-select.js"></script>
    <script type="text/javascript" src="../../script/FncDate.js"></script>
    <script type="text/javascript" src="../../script/fnc.js"></script>
    <script src="../../script/jquery.validate.min.js"></script>
    <script src="../../style/mask/jquery.mask.min.js"></script>
    <script type="text/javascript">

        var sep1 = '☺';
        var sep2 = '☻';
        let personnel_location_guid;
        let location_guid;
        $(document).ready(function () {

            let init = $.parseJSON(initial_page(600, 400));
            $('#personnel_Name').val(init[0].pname);
            $('#sdate').val((init[0].sdate) ?.trim());
            $('#edate').val((init[0].edate) ?.trim());
            $('#detail').val((init[0].detail) ?.trim());
            personnel_location_guid = (init[0].personnel_location_guid) ?.trim();
            location_guid = (init[0].location_guid) ?.trim();

            if (init[0].enable === 1) {
                $('#lblLocationEnable').text('فعال');
                $('#chkLocationEnable').attr("checked", true);
            } else {
                $('#lblLocationEnable').text('غیرفعال');
                $('#chkLocationEnable').attr("checked", false);
            }
            // #region فعال/غیرفعال سازی موقعیت
            $('#chkLocationEnable').on('change', () => {
                if ($('#chkLocationEnable').is(":checked")) {
                    $('#lblLocationEnable').text('فعال');
                    locationEnable = '1';
                }
                else {
                    $('#lblLocationEnable').text('غیرفعال');
                    locationEnable = '0';
                }
            })
            unwait_();
        });

        function save() {
            // #region اعتبار سنجی فرم
            var locationModalFormValidate = $("#frm_personnel_single").validate({
                rules: {
                    detail: {
                        required: false,
                        maxlength: 256
                    }
                },
                messages: {

                    detail: {
                        maxlength: "توضیحات وارد شده بیش از حد مجاز است",
                    }
                },

                highlight: function (element) {
                    $(element).closest('.form-group').addClass('text-danger');
                },
                unhighlight: function (element) {
                    $(element).closest('.form-group').removeClass('text-danger');
                },
                errorElemen: 'span',
                errorClass: 'text-danger',
                errorPlacement: (error, element) => {
                    if (element.parent('.form-control').length) {
                        error.insertAfter(element.parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });

            // #endregion

            // #region ذخیره اطلاعات
            if ($("#frm_personnel_single").valid()) {

                let LocationEnable = $("#chkLocationEnable").prop('checked') ? 1 : 0;
                let str = "value:'sdate" + sep1 + $("#sdate").val() + sep2 +
                    "edate" + sep1 + $("#edate").val() + sep2 +
                    "detail" + sep1 + $("#detail").val().trim() + sep2 +
                    "enable" + sep1 + LocationEnable + sep2 +
                    "personnel_location_guid" + sep1 + personnel_location_guid +
                    "'";
                reqsvr("page_personnel_location_single.aspx/setPersonnelSingle", "personnel_guid:'" + personnel_location_guid + "', sdate:'" + $("#sdate").val() + "', edate:'" + $("#edate").val() + "', enable:'" + LocationEnable + "', location_guid:'" + location_guid + "', detail:'" + $("#detail").val() + "'",
                    (data) => {
                        if (data.d[0] === 'ok') {

                            alert_success("ویرایش انجام شد", "ویرایش پرسنل");
                            call_fnc();
                            close();
                        }
                        else {
                            alert_error(data.d[0], "ویرایش پرسنل");
                            //close();
                        }
                    }
                );
            }
            else {
                alert_error("not valid");
            }
            // #endregion
        }
    </script>

</head>
<body>
    <form class="needs-validation pad5" id="frm_personnel_single" novalidate="novalidate">
        <div class="row">
            <span>نام پرسنل</span>
            <input type="text" class="form-control" name="personnel_Name" id="personnel_Name" readonly="readonly" />
        </div>
        <div class="row">
            <span>وضعیت : </span>
            <input type="checkbox" class="custom-control-input" name="chkLocationEnable" id="chkLocationEnable" value="" />
            <span id="lblLocationEnable"></span>

        </div>
        <div class="row  ">

            <div class="col-xs-6  ">
                <span>از تاریخ :</span>
                <input type="text" class="form-control date" name="sdate" id="sdate" />
            </div>


            <div class="col-xs-6">
                <span>تا تاریخ :</span>
                <input type="text" class="form-control date" name="edate" id="edate" />
            </div>

        </div>
        <div class="row">
            <span>توضیحات</span>
            <textarea class="form-control" name="detail" id="detail"maxlength="100" placeholder="توضیحات (اختیاری)"></textarea>
        </div>



        <div class="toolbar-footer">
            <button type="button" onclick="save()" class="btn btn-success">ذخیره</button>
        </div>

    </form>
</body>
</html>
