﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_person_map_point.aspx.cs" Inherits="TimeWork.page_person_map_point" %>

<!DOCTYPE html>
<html lang="fa" dir="rtl" xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/location/leaflet-search.css" rel="stylesheet" />
    <link href="../../style/location/leaflet.contextmenu.min.css" rel="stylesheet" />
    <link href="../../style/location/leaflet.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />


    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/location/leaflet.js"></script>
    <script src="../../style/location/leaflet.contextmenu.min.js"></script>
    <script src="../../style/location/leaflet-search.js"></script>

    <script src="../../script/fnc.js" type="text/javascript"></script>


    <script type="text/javascript">

        var Map;
        var data_;
        $(document).ready(function () {

            var ar = initial_page(800, 600);
            reqsvr("load", "prow:" + ar[0] + ",date:'" + ar[1] + "'", function (data) {
                data_ = data.d;
                load_tbl(data.d, 'result');

                var xml = XMLparse(data.d);
                var mytable = xml.find("mytable");
                let lat_;
                let lon_;
                var markerArray = [];
                var first = 0;
                $.each(mytable, function () {

                    let lat = parseFloat($(this).find("lat").text().replace("/", "."));
                    let lon = parseFloat($(this).find("lon").text().replace("/", "."));
                    let marker = L.marker([lat, lon]);
                    // marker.bindPopup($(this).find("row").text()  );
                    markerArray.push(marker);
                    if (first == 0) {
                        lat_ = lat;
                        lon_ = lon;
                    }
                    first = 1;
                });

                Map = L.map('map', {
                    center: new L.LatLng(lat_, lon_),
                    zoom: 20,
                    attributionControl: true,
                    keyboard: true,
                    preferCanvas: true, dragging: true, scrollWheelZoom: true
                });
                L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
                    attribution: ' <a href="http://www.sanscosoft.com/">سامانه آفرینان نیک اندیش کوشا</a>'
                }).addTo(Map);

                L.layerGroup(markerArray).addTo(Map); 
                $("#tbl_result tr td").click(function () {
                    tr_change($(this).closest("tr").attr('code'));
                });
                $("#tbl_result tbody tr:first").addClass("selectedtr");
                tr_change($("#tbl_result tbody tr:first").attr('code'));
            });
        });

        function tr_change(code) { 
            var r = search_xml(data_, code)
            let lat_ = parseFloat($(r).find("lat").text().replace("/", "."));
            let lon_ = parseFloat($(r).find("lon").text().replace("/", "."));
            let path_ = $(r).find("path").text();
            $('#_img').attr("src", path_);
            $('#lb_detail').html($(r).find("detail").text()); 
            Map.panTo([lat_, lon_]); 
        }
    </script>
</head>

<body>
    <form>
        <div class="row pad3 ">
            <div class="col-xs-4">
                <div id="div_result" class=" border " style="height: 290px"></div>
                <br />
                <img id="_img" class="border w-full" style="height: 250px" src="#" />
            </div>
            <div class="col-xs-8">

                <label id="lb_detail" class="border w-full h-40 pad5 bg-yellow-light"></label>
                <br />
                <div id="map" class="border" style="height: 510px"></div>
            </div>
        </div>
    </form>
</body>
</html>
