﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_location_event_view.aspx.cs" Inherits="TimeWork.page_location_event_view" %>

<!DOCTYPE html>
<html lang="fa" dir="rtl" xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/location/leaflet-search.css" rel="stylesheet" />
    <link href="../../style/location/leaflet.contextmenu.min.css" rel="stylesheet" />
    <link href="../../style/location/leaflet.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />


    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/location/leaflet.js"></script>
    <script src="../../style/location/leaflet.contextmenu.min.js"></script>
    <script src="../../style/location/leaflet-search.js"></script>

    <script src="../../script/fnc.js" type="text/javascript"></script>


    <script type="text/javascript">



        $(document).ready(function () {

            var ar = initial_page(800, 600);
            reqsvr("load", "row:" + ar[0], function (data) {

                set_XML_div("#div_main", data.d[0]);
                $('#location_image').attr('src', '../../' + data.d[1]);

                let lat_ = parseFloat(data.d[2].replace("/", "."));
                let lon_ = parseFloat(data.d[3].replace("/", "."));

                var Map = L.map('map', {
                    center: new L.LatLng(lat_, lon_),
                    zoom: 20,
                    attributionControl: false,
                    keyboard: false,
                    preferCanvas: false, dragging: false, scrollWheelZoom: null

                });
                L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
                    attribution: ' <a href="http://www.sanscosoft.com/">سامانه آفرینان نیک اندیش کوشا</a>'
                }).addTo(Map);
                let marker = L.marker([lat_, lon_]);
                var markerArray = [];

                markerArray.push(marker);
                L.layerGroup(markerArray).addTo(Map);




            });

        });


    </script>
</head>

<body>
    <form>
        <div class="row auto-height">
            <div id="div_main" class="col-sm-4">
                <label>کد پرسنل :</label>
                <input type="text" class="form-control bg-readonly" name="pid" disabled="disabled" />
                <br />
                <label>نام پرسنل :</label>
                <input type="text" class="form-control bg-readonly" name="pname" disabled="disabled" />
                <br />
                <label>زمان تردد :</label>
                <input type="text" class="form-control bg-readonly" name="date_time" disabled="disabled" />
                <br />
                <label>نام موقعیت :</label>
                <input type="text" class="form-control bg-readonly" name="name" disabled="disabled" />
                <br />
                <label>فاصله تا موقعیت (متر ):</label>
                <input type="text" class="form-control bg-readonly" name="distance" disabled="disabled" />
                <br />
                <label>تصویر :</label>
                <br />
                <img alt="" id="location_image" src="#" style="border: thin solid #C0C0C0; height: 270px; width: auto;" />
            </div>
            <div   class="col-sm-8 pad5" style="height: 100%">
                
                <label>موقعیت :</label>
                <br />
                 <div id="map" class="  " style="height: 95%"></div>
            </div>
        </div>
    </form>
</body>
</html>
