﻿
var Map, locations;
var markerArray = [];
var circleArray = [];
var searchArray = [];
var geoJSONArray = [];
var sep1 = '☺';
var sep2 = '☻';

function newLocation(e) {
    let latlng = (e.latlng).toString().replace('LatLng(', '').replace(')', '').split(',');

    let lat = latlng[0];
    let lng = latlng[1];

    let enable_latlng = '{"locationEnableVisible":"0", "lat":"' + lat + '", "lng":"' + lng + '"} ';
    open_form_("../../page/location/page_upsert_location.aspx", 'موقعیت جدید', enable_latlng, "add_ok");

}

function moveLocation(e) {

    //let locationStatus = 2;//move 
    let latlng = (e.latlng).toString().replace('LatLng(', '').replace(')', '').split(',');
    let lat = latlng[0];
    let lng = latlng[1];
    let enable_latlng = '{"locationStatus":"2", "lat":"' + lat + '", "lng":"' + lng + '"} ';//'", "isNewLocation":"' + isNewLocation + '"} ';
    open_form_("../../page/location/page_upsert_location.aspx", 'انتقال به موقعیت جدید', enable_latlng, "move_ok");
}

function move_ok(name_, dis_, tel_, add_, detail_, locationEnable_, locationGuid, lat, lng) {
    //let str = "value:'name" + sep1 + name_ + sep2 +        
    //    "guid" + sep1 + locationGuid_NULL + sep2 +
    //    "lat" + sep1 + lat + sep2 +
    //    "lon" + sep1 + lng + sep2  + "'"; 
    reqsvr('../../page/location/page_location.aspx/moveLocation', "name:'" + name_ + "',guid:'" + locationGuid + "',lat:'" + lat + "',lon:'" + lng + "'",
        (data) => {
            if (data.d[0] === 'ok') {
                //addNewLocation(data.d[1], name_, dis_, tel_, add_, detail_, lat, lng, 1);
                moveLayer(locationGuid, name_, lat, lng);//, lat_, lon_
            }
        });
}

function add_ok(name_, dis_, tel_, add_, detail_, locationEnable_, locationGuid_NULL, lat, lng) {
    let str = "value:'name" + sep1 + name_ + sep2 +
        "tel" + sep1 + tel_ + sep2 +
        "address" + sep1 + add_ + sep2 +
        "distance" + sep1 + dis_ + sep2 +
        "detail" + sep1 + detail_ + sep2 +
        "lat" + sep1 + lat + sep2 +
        "lon" + sep1 + lng + sep2 + "'";
    reqsvr('setLocation', str,
        (data) => {
            if (data.d[0] === 'ok') {
                addNewLocation(data.d[1], name_, dis_, tel_, add_, detail_, lat, lng, 1);
                load_location();
            }
        });
}
function edit_ok(name_, distance_, tel_, address_, detail_, locationEnable_, locationGuid, lat, lng) {

    let str = "value:'name" + sep1 + name_ + sep2 +
        "tel" + sep1 + tel_ + sep2 +
        "address" + sep1 + address_ + sep2 +
        "distance" + sep1 + distance_ + sep2 +
        "detail" + sep1 + detail_ + sep2 +
        "lat" + sep1 + lat + sep2 +
        "lon" + sep1 + lng + sep2 +
        "enable" + sep1 + locationEnable_ + sep2 +
        "guid" + sep1 + locationGuid + //timeworkGuid
        "'";

    reqsvr('editLocation', str,
        (data) => {
            if (data.d[0] === 'ok') {
                //editLayer(timeworkGuid, name_, distance_, tel_, address_, detail_, locationEnable_);//, lat_, lon_
                editLayer(locationGuid, name_, distance_, tel_, address_, detail_, locationEnable_);//, lat_, lon_
                load_location();
            }
        });
}


function moveLayer(guid, name, lat_, lng_) {

    //let _name = name.trim() ? '<strong>' + name.trim() + '</strong>' : '';
    //let _address;// = address.trim() ?  : '';
    //let _tel;// = tel.trim() ?  : '';
    //let _detail;// = detail.trim() ? '<br /><br />توضیحات: ' + detail.trim() : '';
    //let _distance;
    //let _distanceCircla;// = ' حدود شعاع: ' + distance + ' متر ';

    for (let i = 0; i < markerArray.length; i++) {

        //if (locations[i].guid === guid) {

        //    locations[i].name = name;
        //    locations[i].lat = lat_;
        //    locations[i].lon = lng_;
        //    _distance = locations[i].distance;
        //    _address = '<br /><br />آدرس: ' + locations[i].address.trim()
        //    _tel = '<br /><br />تلفن: ' + locations[i].tel.trim();
        //    _detail = '<br /><br />توضیحات: ' + locations[i].detail.trim();
        //    _distanceCircla = ' حدود شعاع: ' + locations[i].distance + ' متر ';
        //}

        if (markerArray[i].options.uniqueID === guid) {

            timeworkMap.removeLayer(markerArray[i]);
            timeworkMap.removeLayer(circleArray[i]);

            circleArray.splice(i, 1);
            markerArray.splice(i, 1);


            [distance, tel, address, detail, enable_] = [locations[i].distance, locations[i].tel, locations[i].address, locations[i].detail, locations[i].enable];

            locations.splice(i, 1);
            addNewLocation(guid, name, distance, tel, address, detail, lat_, lng_, enable_);


            //addNewLocation(guid, name, distance, tel, address, detail, lat_, lon_, enable) {

            /*
            markerArray[i].getPopup().setContent(_name + _address + _tel + _detail);
            markerArray[i].bindTooltip(name.trim());
            markerArray[i].options.title = name.trim();
            markerArray[i].getPopup().update();

            circleArray[i].setRadius(_distance);
            circleArray[i].getPopup().setContent(_distanceCircla);
            circleArray[i].getPopup().update();

            if (locations[i].enable.toString() === '1') {
                circleArray[i].setStyle({ fillColor: '#F03F03' });
            }
            else {
                circleArray[i].setStyle({ fillColor: '#000' });
            };
*/

            // 
            //circleArray[i].addTo(timeworkMap);
            ////timeworkMap.addLayer(markerArray[i]); 
            //L.layerGroup(circleArray[i]).addTo(timeworkMap);
            //L.layerGroup(markerArray[i]).addTo(timeworkMap);

            break;
        }

    }
}

function editLayer(guid, name, distance, tel, address, detail, locationEnable) {

    let _name = name.trim() ? '<strong>' + name.trim() + '</strong>' : '';
    let _address = address.trim() ? '<br /><br />آدرس: ' + address.trim() : '';
    let _tel = tel.trim() ? '<br /><br />تلفن: ' + tel.trim() : '';
    let _detail = detail.trim() ? '<br /><br />توضیحات: ' + detail.trim() : '';
    let _distanceCircla = ' حدود شعاع: ' + distance + ' متر ';

    for (var i = 0; i < markerArray.length; i++) {

        if (locations[i].guid === guid) {
            locations[i].name = name;
            locations[i].distance = distance;
            locations[i].address = address;
            locations[i].tel = tel;
            locations[i].detail = detail;

            if (locationEnable) {
                locations[i].enable = locationEnable;
            }

        }

        if (markerArray[i].options.uniqueID === guid) {
            markerArray[i].getPopup().setContent(_name + _address + _tel + _detail);
            //markerArray[i].bindTooltip(name.trim()); 
            //markerArray[i].options.title = name.trim(); 
            markerArray[i].getPopup().update();
            circleArray[i].setRadius(distance);
            circleArray[i].getPopup().setContent(_distanceCircla);
            circleArray[i].getPopup().update();

            if (locations[i].enable.toString() === '1') {
                circleArray[i].setStyle({ fillColor: '#F03F03' });
            }
            else {
                circleArray[i].setStyle({ fillColor: '#000' });
            };
            load_location();

            break;
        }
    }
}
function showMenu(i) {

    return [{
        index: 1,
        text: 'ویرایش',
        callback: function () {
            locationEnable = locations[i].enable.toString();
            let obj = '{"locationName":"' + locations[i].name +
                '", "locationDistance":"' + locations[i].distance +
                '", "locationTel":"' + locations[i].tel +
                '", "locationAddress":"' + locations[i].address +
                '", "locationDetail":"' + locations[i].detail +
                '", "lat": "' + locations[i].lat + '", "lng": "' + locations[i].lon + '", "locationGuid":"' + locations[i].guid +
                '", "locationEnable":"' + locations[i].enable.toString() + '"}';

            open_form_("../../page/location/page_upsert_location.aspx", 'ویرایش موقعیت', obj, "edit_ok");
        }
    }, {
        index: 2,
        text: 'حذف',
        callback: function () {
            confirm_alert(function () {

                reqsvr("deleteLocation", "guid:'" + locations[i].guid + "'",
                    (data) => {
                        alert_success("حذف مکان انجام شد");
                        markerArray[i].remove();
                        circleArray[i].remove();
                        load_location();
                    }
                );
            });
        }
    },
    {
        index: 3,
        text: 'پرسنل',
        callback: function () {
            open_form_("../../page/location/page_personnel_location.aspx", ' ویرایش گروهی پرسنل در موقعیت (' + locations[i].name + ")", "'" + locations[i].guid + "'", "");
        }
    }];

}
function addNewLocation(guid, name, distance, tel, address, detail, lat_, lon_, enable) {

    let newLocation = { guid, name, distance, tel, address, detail, lat: lat_, lon: lon_, enable };
    locations.push(newLocation);
    addLayerCircle(locations.length - 1, '#F03F03');
    markerArray[markerArray.length - 1].addTo(Map);
    ////اضافه کردن دایره شعاع
    circleArray[circleArray.length - 1].addTo(Map);
}

function addLayerCircle(i, fillColor = null) {

    let enable = parseInt(locations[i].enable);
    let name = locations[i].name.trim() ? '<strong>' + locations[i].name.trim() + '</strong>' : '';
    let address = locations[i].address.trim() ? '<br /><br />آدرس: ' + locations[i].address.trim() : '';
    let tel = locations[i].tel.trim() ? '<br /><br />تلفن: ' + locations[i].tel.trim() : '';
    let detail = locations[i].detail.trim() ? '<br /><br />توضیحات: ' + locations[i].detail.trim() : '';

    let marker = L.marker([locations[i].lat, locations[i].lon], {
        //title: locations[i].name.trim(),
        uniqueID: locations[i].guid,
        contextmenu: true,
        contextmenuItems: showMenu(i),

    });

    marker.bindPopup(name + address + tel + detail);
    // marker.bindTooltip(locations[i].name.trim());

    markerArray.push(marker);
    let circle = L.circle([locations[i].lat, locations[i].lon], parseInt(locations[i].distance), {
        color: '#' + (locations[i].color ??= 'F03F03'),
        fillColor: enable === 1 ? fillColor ?? '#770fff' : '#000',
        fillOpacity: 0.5
    }).bindPopup(' حدود شعاع: ' + locations[i].distance + ' متر ');

    circleArray.push(circle);
}


async function showLocations() {
    try {
        reqsvr('getLocations', '', function (data) {
            locations = $.parseJSON(data.d);
            let lat_ = locations[0] ? locations[0].lat : 32.65246;
            let lng_ = locations[0] ? locations[0].lon : 51.67462;

            Map = L.map('map', {
                center: new L.LatLng(lat_, lng_),
                zoom: 7,
                contextmenu: true,
                contextmenuWidth: 140,
                contextmenuItems: [
                    {
                        text: 'جدید',
                        //icon: 'images/zoom-out.png',
                        callback: newLocation
                    }, '-',
                    {
                        text: 'مرکز نمایی',
                        callback: centerMap
                    },
                    {
                        text: 'بزرگ نمایی',
                        //icon: 'images/zoom-in.png',
                        callback: zoomIn
                    },
                    {
                        text: 'کوچک نمایی',
                        //icon: 'images/zoom-out.png',
                        callback: zoomOut
                    }]
            });

            L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
                attribution: ' <a href="http://www.sanscosoft.com/">سامانه آفرینان نیک اندیش کوشا</a>'
            }).addTo(Map);
            for (let i = 0; i < locations.length; i++) {
                addLayerCircle(i, false);
            }
            L.layerGroup(circleArray).addTo(Map);
            L.layerGroup(markerArray).addTo(Map);//   let searchLayer = L.layerGroup(markerArray).addTo(Map);
            //Map.addControl(new L.Control.Search({ layer: searchLayer, textPlaceholder: 'جستجو', textErr: 'یافت نشد', textCancel: 'انصراف', position: 'topright', width: '300', }));

        });


    } catch (e) {
        alert_error(e);
    }


}

function showCoordinates(e) {
    alert_message(e.latlng);
}

function centerMap(e) {
    Map.panTo(e.latlng);
}

function zoomIn(e) {
    Map.zoomIn();
}

function zoomOut(e) {
    Map.zoomOut();
}




