﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_job_unit.aspx.cs" Inherits="TimeWork.page_job_unit" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/treeGrid/treeGrid.css" rel="stylesheet" />
    <link href="../../style/SelectTree/select2.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/treeGrid/treeGrid.js" type="text/javascript"></script>
    <script src="../../style/SelectTree/select2.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>

    <script> 
        $(document).ready(function () {
            initial_page(600, 600);
            load();

            $("#tb_search_tree").on("keyup", function () {
                var arr = $(this).val().toLowerCase().replace("  ", " ").split(' ');

                $("#tbl_job_unit tbody tr").filter(function () {
                    var toggled = true;
                    for (var i = 0; i < arr.length; i++) {
                        if (arr[i] == '') continue;
                        if ($(this).text().toLowerCase().indexOf(arr[i]) == -1) {
                            toggled = false;
                            break;
                        }
                    }
                    $(this).toggle(toggled);

                });
            });

        });

        var loading = false;
        function load() {
            last_id = "";
            reqsvr("load", "",
                function (data) {
                    $('#div_job_unit').html(data.d[0]);
                    if (!loading) {
                        $("#div_menu_job_unit").append(data.d[1]);
                        loading = true;
                    }
                    set_datatable('#tbl_job_unit');
                    $('.tree').treegrid({
                        enableMove: $("#chb_edit_chart")[0].checked
                    });
                    if ($("#chb_edit_chart")[0].checked) {
                        $('#tbl_job_unit').find(".treegrid-container").addClass("grab");
                    }

                    var c = $("#tbl_job_unit tbody tr:first").attr('code');
                    if (c !== undefined) {
                        $("#tbl_job_unit").find("[code=" + c + "]").addClass("selectedtr");
                        $("#tbl_job_unit").find("[code=" + c + "]").parents('tr').click();

                    }
                    $("#tbl_job_unit tbody tr").click(function () {
                        $("#tbl_job_unit tr").removeClass("selectedtr");
                        $(this).addClass("selectedtr");
                    });
                }
            );

        }
        var last_id;

        function refresh_personel() {

            var obj = $("#tbl_job_unit").find(".selectedtr");
            last_id = "";
            reqsvr("refresh_cnt", "",
                function (data) {
                    var xml = XMLparse(data.d);
                    xml.find("mytable").each(function () {

                        var o = $("#tbl_job_unit").find("tr[code=" + $(this).find('code').text() + "]");
                        if (o.length > 0) {
                            var cnt = $(this).find('cnt').text();
                            var max = $(this).find('cnt_max').text();
                            var st = "green-dark bg-green-light";
                            if (parseInt(cnt) > parseInt(max))
                                st = "yellow bg-yellow-light";
                            else
                                if (parseInt(cnt) < parseInt(max))
                                    st = "red bg-red-light";
                            if ($(this).find('job_unit_kind_id').text() == 4)
                                $(o).find("td").eq(3).replaceWith("<td class=\"center " + st + " ltr\">" + cnt + " / " + max + "</td>");
                            else $(o).find("td").eq(3).replaceWith("<td class=\"center ltr\">" + cnt + "</td>");

                            $(o).find("td").eq(4).html($(this).find('sum').text());
                        }
                    });
                });

            load_personel(obj.attr('code'));
        }
        function load_personel(id) {

            if (id != last_id) {

                if (id == "last") id = last_id;

                var ch = $("#chb_all")[0].checked ? 1 : 0;
                reqsvr("load_personel", "code:" + id + ",all:" + ch,
                    function (data) {
                        load_tbl_btn_chb(data.d, 'personel', 'row');
                        $("#div_personel").find("button[name=delete_multi]").remove();
                        $("#div_personel").find("button[name=delete]").remove();
                        $("#div_personel").find("button[name=new]").remove();
                    });
                last_id = id;
            }
        }

        function new_click() {
            var obj = $("#tbl_job_unit").find(".selectedtr");
            open_form_('../../page/job/page_job_unit_new.aspx', 'جدید', obj.attr('code') + '&-1', "tree_add");
        }

        function tree_add(mode, code) {

            var obj = $("#tbl_job_unit").find(".selectedtr");

            reqsvr("node_load",
                "code:" + code + ",cnt:'0', sum_cnt:'0'",
                function (data) {
                    $(obj).treegrid('add', ['<tr class="treegrid-' + code + '" code="' + code + '"cnt="0" sum-cnt="0" name="' + data.d[0] + '"><td title="' + data.d[1] + '">' + data.d[2] + '</td>' + data.d[3] + data.d[4] + data.d[5] + data.d[6] + '</tr>']);
                    tbl_select("#tbl_job_unit");
                });
        }

        function save_sort() {

            var data = "";
            $("#tbl_job_unit tbody").find("tr").each(function () {
                data = data + "," + $(this).attr("class");
            });
            reqsvr("save_sort", "data:'" + data + "'",
                function (data) {
                    if (data.d == "ok") {
                        refresh_personel();
                        alert_success("تغییرات ذخیره شد");

                    }
                    else
                        alert_error(data.d);
                });
        }


        function edit_click() {

            var obj = $("#tbl_job_unit").find(".selectedtr");
            if (obj == undefined || obj.attr('code') == '0' || obj.attr('code') == undefined) return;
            open_form_('../../page/job/page_job_unit_new.aspx', 'ویرایش', '-1&' + obj.attr('code') + '&' + obj.attr('name'), "tree_edit");
        }

        function tree_edit(mode, code) {
            if (mode == "load") load();
            else {
                var obj = $("#tbl_job_unit").find(".selectedtr");

                reqsvr("node_load",
                    "code:" + code + ", cnt:'" + $(obj).attr('cnt') + "', sum_cnt:'" + $(obj).attr('sum-cnt') + "'",
                    function (data) {
                        $(obj).attr('name', data.d[0]);
                        $(obj).find("td").eq(0).attr('title', data.d[1]);
                        $(obj).find("td").eq(0).find('.title').replaceWith(data.d[2]);
                        $(obj).find("td").eq(1).replaceWith(data.d[3]);
                        $(obj).find("td").eq(2).replaceWith(data.d[4]);
                        $(obj).find("td").eq(3).replaceWith(data.d[5]); 

                    });

            }
        }

        function delete_click() {
            var obj = $("#tbl_job_unit").find(".selectedtr");
            if (obj == undefined || obj.attr('code') == '0') return;
            if (obj.attr('code') == undefined) {
                alert_error('هیچ گزینه ای انتخاب نشده است');
                return;
            }
            var data_parent = obj.attr('data-parent');
            confirm_alert(function () {
                reqsvr("delete",
                    "code:" + obj.attr('code'),
                    function (data) {
                        if (data.d == "ok")
                            $(obj).treegrid('remove');
                        else
                            alert_error(data.d);
                    });
            });
        }


        function edit_chart_onchange() {
            if ($("#chb_edit_chart")[0].checked) {
                $("#btn_save_sort").removeClass("hide");
            }
            else {
                $("#btn_save_sort").addClass("hide");
            }
            load();
        }
    </script>
</head>
<body>
    <form>
        <div id="div_menu_job_unit" class="  bg-menu">
            <button type="button" class="btn btn-default " onclick="load()"><span class="fa fa-refresh"></span></button>
            <button type="button" class="btn btn-primary" onclick="window['new_click']()"><span class="fa fa-plus">&nbsp;</span>ایجاد</button>
            <button type="button" class="btn btn-info" onclick="window['edit_click']()"><span class="fa fa-edit">&nbsp;</span>ویرایش</button>
            <button type="button" class="btn btn-danger" onclick="window['delete_click']()"><span class="fa fa-trash">&nbsp;</span>حذف</button>
        </div>
        <div id="tbl_result_filter" class="dataTables_filter">
            <input type="search" class="form-control input-sm" placeholder="جستجو" id="tb_search_tree" />
        </div>
        <div id="div_job_unit" class="panel  auto-height">
        </div>


    </form>

    <p>
    </p>

</body>
</html>
