﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_job.aspx.cs" Inherits="TimeWork.page_job" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/treeGrid/treeGrid.css" rel="stylesheet" />
    <link href="../../style/SelectTree/select2.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/treeGrid/treeGrid.js" type="text/javascript"></script>
    <script src="../../style/SelectTree/select2.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>

    <script> 
        $(document).ready(function () {
            initial_tab();
            load();

            $("#tb_search_tree").on("keyup", function () {
                var arr = $(this).val().toLowerCase().replace("  ", " ").split(' ');

                $("#tbl_job tbody tr").filter(function () {
                    var toggled = true;
                    for (var i = 0; i < arr.length; i++) {
                        if (arr[i] == '') continue;
                        if ($(this).text().toLowerCase().indexOf(arr[i]) == -1) {
                            toggled = false;
                            break;
                        }
                    }
                    $(this).toggle(toggled);
                    load_personel("-1");
                });
            });

        });
        var loading = false;
        function load() {
            reqsvr("load", "",
                function (data) {

                    load_cb_tree("#cb_job_unit", data.d[0]);
                    $("#cb_job_unit").select2('val', data.d[3]);
                    load_job_unit();
                    if (!loading) {
                        $("#div_menu_job").append(data.d[1]);

                        loading = true;
                    }
                }
            );
        }
        function job_unit_list_click() {
            open_form_('../../page/job/page_job_unit.aspx', 'واحد های سازمانی', "");
        }
        function job_unit_changed() {
            edit_mode = false;
            last_id = "";
            $("#btn_new").removeClass("hide");
            $("#btn_edit").removeClass("hide");
            $("#btn_delete").removeClass("hide");
            $("#btn_save_sort").addClass("hide");
            $("#btn_cancel_sort").addClass("hide");
            if ($("#cb_job_unit").val() == "0") {

                $("#btn_edit_chart").removeClass("hide");
            }
            else {
                $("#btn_edit_chart").addClass("hide");

            }
            load_job_unit();
        }

        function load_job_unit() {

            reqsvr("load_job_unit", "unit_id:" + $("#cb_job_unit").val(),
                function (data) {

                    $('#div_job').html(data.d[0]);

                    set_datatable('#tbl_job');
                    $('.tree').treegrid({
                        enableMove: edit_mode
                    });
                    if (edit_mode) {
                        $('#tbl_job').find(".treegrid-container").addClass("grab");
                    }
                    $('#div_personel').html("...");
                    var c = $("#tbl_job tbody tr:first").attr('code');
                    if (c !== undefined) {
                        $("#tbl_job").find("[code=" + c + "]").addClass("selectedtr");
                        $("#tbl_job").find("[code=" + c + "]").parents('tr').click();
                        load_personel($("#tbl_job").find(".selectedtr").attr('code'));

                    }
                    $("#tbl_job tbody tr").click(function () {
                        $("#tbl_job tr").removeClass("selectedtr");
                        $(this).addClass("selectedtr");
                        load_personel($(this).attr('code'));
                    });
                }
            );

        }
        var last_id;

        function refresh_personel() {

            var obj = $("#tbl_job").find(".selectedtr");
            last_id = "";
            reqsvr("refresh_cnt", "",
                function (data) {
                    var xml = XMLparse(data.d);
                    xml.find("mytable").each(function () {

                        var o = $("#tbl_job").find("tr[code=" + $(this).find('code').text() + "]");
                        if (o.length > 0) {
                            var cnt = $(this).find('cnt').text();
                            var max = $(this).find('cnt_max').text();
                            var st = "green-dark bg-green-light";
                            if (parseInt(cnt) > parseInt(max))
                                st = "yellow bg-yellow-light";
                            else
                                if (parseInt(cnt) < parseInt(max))
                                    st = "red bg-red-light";
                            $(o).find("td").eq(3).replaceWith("<td class=\"center " + st + " ltr\">" + cnt + " / " + max + "</td>");
                            $(o).find("td").eq(4).html($(this).find('sum').text());
                        }
                    });
                });

            load_personel(obj.attr('code'));
        }
        function load_personel(id) {

            if (id != last_id) {

                if (id == "last") id = last_id;

                var ch = $("#chb_all")[0].checked ? 1 : 0;
                reqsvr("load_personel", "code:" + id + ",all:" + ch,
                    function (data) {
                        $("#div_personel").html(data.d);
                    });
                last_id = id;
            }
        }

        function tree_add(mode, code) {

            var obj = $("#tbl_job").find(".selectedtr");

            reqsvr("node_load",
                "code:" + code + ",cnt:'0', sum_cnt:'0'",
                function (data) {
                    $(obj).treegrid('add', ['<tr class="treegrid-' + code + '" code="' + code + '"cnt="0" sum-cnt="0" name="' + data.d[0] + '"><td title="' + data.d[1] + '">' + data.d[2] + '</td>' + data.d[3] + data.d[4] + data.d[5] + data.d[6] + '</tr>']);
                    tbl_select("#tbl_job");
                });
        }

        function save_sort() {

            var data = "";
            $("#tbl_job tbody").find("tr").each(function () {
                data = data + "," + $(this).attr("class");
            });
            reqsvr("save_sort", " data:'" + data + "'",
                function (data) {
                    if (data.d == "ok") {
                        $("#btn_new").removeClass("hide");
                        $("#btn_edit").removeClass("hide");
                        $("#btn_delete").removeClass("hide");
                        $("#btn_save_sort").addClass("hide");
                        $("#btn_cancel_sort").addClass("hide");
                        $("#btn_edit_chart").removeClass("hide");
                        edit_mode = false;
                        refresh_personel();
                        alert_success("تغییرات ذخیره شد");

                    }
                    else
                        alert_error(data.d);
                });
        }
        function cancel_sort() {

            $("#btn_new").removeClass("hide");
            $("#btn_edit").removeClass("hide");
            $("#btn_delete").removeClass("hide");
            $("#btn_save_sort").addClass("hide");
            $("#btn_cancel_sort").addClass("hide");
            $("#btn_edit_chart").removeClass("hide");
            edit_mode = false;
            load_job_unit();
        }
        function new_click() {
            var obj = $("#tbl_job").find(".selectedtr");

            open_form_('../../page/job/page_job_new.aspx', 'جدید', obj.attr('code') + '&-1' + '&' + $("#cb_job_unit").val(), "tree_add");
        }

        function edit_click() {

            var obj = $("#tbl_job").find(".selectedtr");
            if (obj == undefined || obj.attr('code') == '0' || obj.attr('code') == undefined) return;
            open_form_('../../page/job/page_job_new.aspx', 'ویرایش', '-1&' + obj.attr('code') + '&' + $("#cb_job_unit").val(), "tree_edit");
        }

        function delete_click() {
            var obj = $("#tbl_job").find(".selectedtr");
            if (obj == undefined || obj.attr('code') == '0') return;
            if (obj.attr('code') == undefined) {
                alert_error('هیچ گزینه ای انتخاب نشده است');
                return;
            }
            var data_parent = obj.attr('data-parent');
            confirm_alert(function () {
                reqsvr("delete",
                    "code:" + obj.attr('code'),
                    function (data) {
                        if (data.d == "ok")
                            $(obj).treegrid('remove');
                        else
                            alert_error(data.d);
                    });
            });
        }

        function tree_edit(mode, code) {
            if (mode == "load") load_job_unit();

            else {
                var obj = $("#tbl_job").find(".selectedtr");

                reqsvr("node_load",
                    "code:" + code + ", cnt:'" + $(obj).attr('cnt') + "', sum_cnt:'" + $(obj).attr('sum-cnt') + "'",
                    function (data) {
                        $(obj).attr('name', data.d[0]);
                        $(obj).find("td").eq(0).attr('title', data.d[1]);
                        $(obj).find("td").eq(0).find('.title').replaceWith(data.d[2]);

                        $(obj).find("td").eq(1).replaceWith(data.d[3]);
                        $(obj).find("td").eq(2).replaceWith(data.d[4]);
                        $(obj).find("td").eq(3).replaceWith(data.d[5]);
                        $(obj).find("td").eq(4).replaceWith(data.d[6]);
                        //$(obj).find("td").eq(5).replaceWith(data.d[7]);
                    });

            }
        }

        function view_chart() {
            var obj = $("#tbl_job").find(".selectedtr");
            open_form_('../../page/job/page_job_chart.aspx', obj.attr('name'), obj.attr('code'));
        }


        function add_personel() {
            var obj = $("#tbl_job").find(".selectedtr");
            parent.sel_prow = "";

            open_form_('../../page/job/page_job_person_add.aspx', 'اضافه کردن افراد در ' + obj.attr('name'), obj.attr('code'), "refresh_personel");
        }


        function edit_personel(obj) {
            open_form_('../../page/job/page_job_person_edit.aspx', $(obj).closest('tr').find('td:eq(1)').html() + " - " + $(obj).closest('tr').find('td:eq(2)').html(), $(obj).closest('tr').attr('code'));
        }

        var edit_mode = false;
        function edit_chart_click() {

            $("#btn_new").addClass("hide");
            $("#btn_edit").addClass("hide");
            $("#btn_delete").addClass("hide");
            $("#btn_edit_chart").addClass("hide");
            $("#btn_save_sort").removeClass("hide");
            $("#btn_cancel_sort").removeClass("hide");
            edit_mode = true;

            load_job_unit();
        }
        function change_personel() {
            var row = get_checked('#tbl_personel');
            if (row == null) return;
            var obj = $("#tbl_job").find(".selectedtr");
            parent.temp = row;
            open_form_('../../page/job/page_job_person_add.aspx', 'جابجایی افراد در ' + obj.attr('name'), obj.attr('code'), "refresh_personel");
        }
        function edit_person_click(e) {
            var row = $(e).closest('table').attr('row');
            if (row == null) return;

            open_form_('../../page/job/page_job_person_edit.aspx', 'ویرایش', row, "refresh_personel");

        }

        function delete_person_click(e) {
            var row = $(e).closest('table').attr('row');
            if (row == null) return;
            confirm_alert(function () {
                reqsvr("delete_personel",
                    "row:'" + row + "'",
                    function (data) {
                        if (data.d == "ok") {
                            var obj = $("#tbl_job").find(".selectedtr");

                            refresh_personel();
                        }
                        else
                            alert_error(data.d);
                    });
            });
        }
    </script>
</head>
<body>
    <form>
        <div class="row">
            <div class="col-xs-2 w-100"><span>واحد سازمانی:</span></div>
            <div class="col-xs-6">
                <input id="cb_job_unit" type="hidden" class="search-result-box" onchange="job_unit_changed()" />
            </div>
            <div class="col-xs-1">
                <button id="btn_job_unit_list" onclick="job_unit_list_click()" type="button" class="btn btn-default" title="لیست واحد سازمانی"><span class="glyphicon glyphicon-option-horizontal"></span></button>
            </div>
        </div>
        <div id="div_menu_job" class=" bg-menu">
            <button type="button" class="btn btn-default " onclick="job_unit_changed()"><span class="fa fa-refresh"></span></button>
            <button type="button" class="btn btn-default " onclick="view_chart()"><span class="fa fa-sitemap"></span></button>
        </div>


        <div class="row  auto-height no-scroll">
            <div class="col-xs-6">
                <div id="tbl_result_filter" class="dataTables_filter">
                    <input type="search" class="form-control input-sm" placeholder="جستجو" id="tb_search_tree" />
                </div>
                <div id="div_job" class="panel  auto-height">
                </div>
            </div>
            <div class="col-xs-6">
                <div id="div_menu_personel" class="btn-group w-full bg-menu">
                    <button name="" type="button" class="btn btn-primary" onclick="window['add_personel']()"><span class="fa fa-plus">&nbsp;</span>انتصاب افراد</button>
                    <%-- <button name="" type="button" class="btn btn-info" onclick="window['change_personel']()"><span class="fa fa-retweet">&nbsp;</span>انتقال افراد</button>--%>
                    &nbsp;&nbsp;
                    <input id="chb_all" type="checkbox" class="form-control" title="همه افراد" onchange="load_personel('last')" />&nbsp;<span>نمایش همه سوابق افراد در این شغل</span>
                </div>
                <div id="div_personel" class="auto-height"></div>
            </div>
        </div>
    </form>

    <p>
    </p>

</body>
</html>
