﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_food_reserve_group.aspx.cs" Inherits="TimeWork.page_food_reserve_group" EnableSessionState="True" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>

    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../script/jquery-ui.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../style/mask/jquery.mask.min.js" type="text/javascript"></script>
    <script src="../../script/FncTime.js" type="text/javascript"></script>
    <script src="../../script/FncDate.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>


    <script type="text/javascript">
        var code = "0";
        var dt_personnel;
        var dt_mihman;
        $(document).ready(function () {
            initial_date_ok = true;
            var ar = initial_page(800, 600);
            $('#tb_date').val(parent.fdate);
           
            var objCal1 = new PesianDate.persianCalendar('tb_date', {
                onchange: function (pdate) {
                    if (pdate) {
                        load_food();
                    } else {
                        //alert_error('تاریخ ابتدا وارد شده نادرست است');
                    }
                }
            });
            code = ar[0];
            load();

        });
        function load(de) {
            reqsvr("load", "code:" + code,
                function (data) {
                    load_cb("#cb_food_location", data.d[0]);
                    dt_personnel = data.d[3];
                    dt_mihman = data.d[4];
                    if (code !== "-1") {
                        $('#tb_date').disable();
                        $('#tb_date').next().hide();
                        $('#cb_food_meal').disable();
                        $('#tb_date').val(search_xml_by_name(data.d[5], "date"));
                        $("#cb_food_location").val(search_xml_by_name(data.d[5], "food_location_id"));
                        $('#cb_food_meal').val(search_xml_by_name(data.d[5], "food_meal_id"));
                        $('#tb_detail').val(search_xml_by_name(data.d[5], "detail"));

                       
                        var xml = XMLparse(data.d[6]);
                        var row = xml.find("mytable");
                        $.each(row, function () {
                            if ($(this).find('prow').text() == "0") {

                                $("#tbl_list tbody").append('<tr code="m' + $(this).find("mihman_id").text() + '" fd_id="' + $(this).find("food_day_sub_id").text() + '" detail="' + $(this).find("detail").text() + '" >' +
                                    '<td>' + $(this).find("mihman_name").text() + '(' + $(this).find("detail").text() + ')</td>' +
                                    '<td>' + $(this).find("food_name").text() + '</td>' +
                                    '<td><input class="center w-75" name="cnt" type="number" value="' + $(this).find("cnt").text() + '" /></td>' +
                                    '<td><button kind="delete" onclick="delete_list(this)" class="btn btn-default glyphicon glyphicon-trash red btn-delete" type="button" title="حذف"></button></td>' +
                                    '</tr>');
                            } else {
                                $("#tbl_list tbody").append('<tr code="p' + $(this).find("prow").text() + '" fd_id="' + $(this).find("food_day_sub_id").text() + '" detail="" >' +
                                    '<td>' + $(this).find("pname").text() + '</td>' +
                                    '<td>' + $(this).find("food_name").text() + '</td>' +
                                    '<td><input class="center w-75" name="cnt" type="number" value="' + $(this).find("cnt").text() + '" /></td>' +
                                    '<td><button kind="delete" onclick="delete_list(this)" class="btn btn-default glyphicon glyphicon-trash red btn-delete" type="button" title="حذف"></button></td>' +
                                    '</tr>');
                            }
                        });
                    } load_food();
                });
        }
        var dt_food = "";
        function load_food() {
            reqsvrS("load_food", "food_location_id:" + $('#cb_food_location').val() + ", date:'" + $('#tb_date').val() + "'",
                function (data) {
                    dt_food = data.d[0];
                    load_cb_not_select('#cb_food_meal', data.d[1]);
                });
        }

        function save() {
            if (check_force_error("#main")) return;
            var str = "";
            $('#tbl_list tbody tr').each(function () {
                str = str
                    + '☻' + $(this).attr("code")
                    + '☺' + $(this).attr("detail")
                    + '☺' + $(this).attr("fd_id")
                    + '☺' + $(this).find("input[name='cnt']").val();
            });
            if (str.length > 0) str = str.slice(1);
            else {

                alert_error('هیج شخصی درج نشده است');

            }
            reqsvr("save", "code:" + code + ",food_location_id:'" + $("#cb_food_location").val() + "',date:'" + $("#tb_date").val() + "',meal_id:'" + $("#cb_food_meal").val() + "',detail:'" + $("#tb_detail").val() + "',data:'" + str + "'",
                function (data) {
                    switch (data.d[0]) {
                        case "ok":
                            alert_success("ثبت رزرو انجام شد");
                            call_fnc();
                            close();
                            break;
                        case "error":
                            alert_error(data.d[1]);
                            break;

                        case "list":

                            tbl_set_result("#tbl_list", data.d[1]);
                            break;

                    }
                });
        }
        function change_person() {
            if ($("#person").is(":checked")) {
                $("#div_person").removeClass("hide");
                $("#div_mihman").addClass("hide");
                $("#mihman").prop('checked', false);
            }
        }
        function change_mihman() {
            if ($("#mihman").is(":checked")) {

                $("#div_mihman").removeClass("hide");
                $("#div_person").addClass("hide");
                $("#person").prop('checked', false);
            }
        }
        function new_list() {
            if (dt_food == "") {

                alert_error("هیچ منو غذایی در این تاریخ درج نشده است");
                return;
            }
            show_modal("اضافه کردن شخص جدید", "[name=div_add_person]");

            $("#person_id").addClass("selectpicker");
            $("#mihman_id").addClass("selectpicker");
            $("#food_id").addClass("selectpicker");

            load_cb("#person_id", dt_personnel);
            load_cb("#mihman_id", dt_mihman);

            $(dt_food).find("mytable").each(function () {
                if ($("#cb_food_meal").val() == $(this).find('food_meal_id').text())
                    $("#food_id").append('<option value="' + $(this).find('code').text() + '">' + $(this).find('fdname').text() + '  (' + $(this).find('count_reserved').text() + "/" + $(this).find('maximum').text() + ')' + '</option>');
            });
            $("#food_id").selectpicker('refresh');
        }
        function delete_list(o) {
            $(o).closest('tr').remove();
            if ($("#tbl_list tbody").find('tr').length == 0) {

                $('#tb_date').enable();
                $('#tb_date').next().show();
                $('#cb_food_meal').enable();

            }
        }
        function add_to_list() {

            if ($("#person").is(":checked")) {
                if ($("#tbl_list tbody").find("tr[code='p" + $("#person_id").val() + "']").length > 0) {
                    alert_error("این شخص قبلا در لیست اضافه شده است");
                    return;
                }
                $("#tbl_list tbody").append('<tr code="p' + $("#person_id").val() + '" fd_id="' + $("#food_id").val() + '" detail=""  >' +
                    '<td>' + $(search_xml(dt_personnel, $("#person_id").val())).find("name").text() + '</td>' +
                    '<td>' + $(search_xml(dt_food, $("#food_id").val())).find("fdname").text() + '</td>' +
                    '<td><input class="center w-75" name="cnt" type="number" value="' + $("#cnt").val() + '" /></td>' +
                    '<td><button kind="delete" onclick="delete_list(this)" class="btn btn-default glyphicon glyphicon-trash red btn-delete" type="button" title="حذف"></button></td>' +
                    '</tr>');
            } else {

                $("#tbl_list tbody").append('<tr code="m' + $("#mihman_id").val() + '" fd_id="' + $("#food_id").val() + '"   detail="' + $("#detail").val() + '" >' +
                    '<td>' + $(search_xml(dt_mihman, $("#mihman_id").val())).find("name").text() + '(' + $("#detail").val() + ')</td>' +
                    '<td>' + $(search_xml(dt_food, $("#food_id").val())).find("fdname").text() + '</td>' +
                    '<td ><input class="center w-75" name="cnt" type="number" value="' + $("#cnt").val() + '" /></td>' +
                    '<td><button kind="delete" onclick="delete_list(this)" class="btn btn-default glyphicon glyphicon-trash red btn-delete" type="button" title="حذف"></button></td>' +
                    '</tr>');
            }
            $('#tb_date').disable();
            $('#tb_date').next().hide();
            $('#cb_food_meal').disable();
        }

    </script>
</head>
<body>
    <form class="panel">
        <div id="main" class="auto-height pad5">
            <div class="row ">
                <div class="col-sm-2">
                    <label>مکان توزیع :</label>
                </div>
                <div class="col-sm-10">
                    <select id="cb_food_location" name="food_location_id" class="selectpicker" data-size="250" data-width="250" onchange="load_food()">
                    </select>
                </div>
            </div>
            <div class="row ">
                <div class="row col-xs-6">
                    <div class="col-sm-4">
                        <label>تاریخ رزرو :</label>
                    </div>
                    <div class="col-sm-8">
                        <input id="tb_date" name="date" type="text" class="form-control date" />
                    </div>
                </div>
                <div class="row col-xs-6">
                    <div class="col-sm-4">
                        <label>وعده غذایی :</label>
                    </div>
                    <div class="col-sm-8">
                        <select id="cb_food_meal" name="food_meal_id" class="selectpicker" data-size="10">
                        </select>
                    </div>
                </div>
            </div>
            <div class="row ">
                <div class="col-sm-2">
                    <label>توضیحات :</label>
                </div>
                <div class="col-sm-10">
                    <input id="tb_detail" name="detail" type="text" class="form-control" />
                </div>
            </div>
            <br />
            <div class="well well-sm row">
                <table id="tbl_list" class="table table-striped table-bordered  ">
                    <thead>
                        <tr>
                            <th>نام شخص</th>
                            <th>نام غذا</th>
                            <th class="w-75">تعداد</th>
                            <th class="w-25">
                                <button onclick="new_list()" class="btn btn-info glyphicon glyphicon-plus" type="button" title="جدید"></button>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="hide">
            <div name="div_add_person" class="panel  " style="width: 500px;">
                <div class="well well-sm">
                    <input name="person" type="radio" checked="checked" class="form-control" onchange="change_person()" />&nbsp;<span>پرسنل</span>
                    <input name="mihman" type="radio" class="form-control" onchange="change_mihman()" />&nbsp;<span>میهمان</span>
                </div>
                <div class="pad3">
                    <div name="div_person">
                        <label>انتخاب شخص :</label>
                        <select name="person_id" data-width="100%" data-size="10" data-live-search="true">
                        </select>
                    </div>
                    <div name="div_mihman" class="hide">
                        <label>انتخاب میهمان :</label>
                        <select name="mihman_id" data-width="100%" data-size="10" data-live-search="true">
                        </select>
                        <label>توضیحات :</label>
                        <input name="detail" type="text" class="form-control" />
                    </div>
                    <div>
                        <label>انتخاب غذا :</label>
                        <select name="food_id" data-width="100%" data-size="10" data-live-search="true">
                        </select>
                    </div>
                    <div>
                        <label>تعداد :</label>
                        <br />
                        <input name="cnt" class="form-control w-100" type="number" max="99" value="1" />
                    </div>
                    <div class="center">
                        <br />
                        <button onclick="add_to_list()" type="button" class="btn btn-info " title="اضافه به لیست">
                            <span class="glyphicon glyphicon-plus"></span>اضافه به لیست
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="toolbar-footer">
            <button onclick="save()" type="button" class="btn btn-success">ذخیره</button>
        </div>
    </form>
</body>
</html>
