﻿<%@ Page Language="C#" AutoEventWireup="true" ValidateRequest="false" CodeBehind="show_document_instruction.aspx.cs" Inherits="TimeWork.page.instructure.show_document_instruction" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link rel="icon" type="image/x-icon" href="../image/sanaco.png" />
    <style>
        .h_38 {
            min-height: 38px !important;
        }

        .auto-height {
            height: 100vh !important;
        }

        #comments, #div_files {
            max-height: 48vh !important; /* یا هر ارتفاع دلخواه دیگه */
            overflow-y: auto !important;
            border: 1px solid #ccc; /* فقط برای مشخص شدن مرز */
            padding: 10px !important;
            background-color: #fefefe;
        }

        #comments {
            box-shadow: 0 -1px 6px 1px rgba(0,0,0,0.1);
            background-color: #FFFFFF;
        }

            #comments form {
                margin-bottom: 30px;
            }

                #comments form fieldset {
                    clear: both;
                }

                #comments form textarea {
                    height: 100px;
                }

            #comments .media {
                border-top: 1px dashed #DDDDDD;
                padding: 20px 0;
                margin: 0;
            }

                #comments .media > .pull-left {
                    margin-right: 20px;
                }

                #comments .media img {
                    max-width: 100px;
                }

                #comments .media h4 {
                    margin: 0 0 10px;
                }

                    #comments .media h4 span {
                        font-size: 14px;
                        float: right;
                        color: #999999;
                    }

                #comments .media p {
                    margin-bottom: 15px;
                    text-align: justify;
                }

            #comments .media-detail {
                margin: 0;
            }

                #comments .media-detail li {
                    color: #AAAAAA;
                    font-size: 12px;
                    padding-right: 10px;
                    font-weight: 600;
                }

                #comments .media-detail a:hover {
                    text-decoration: underline;
                }

                #comments .media-detail li:last-child {
                    padding-right: 0;
                }

                #comments .media-detail li i {
                    color: #666666;
                    font-size: 15px;
                    margin-right: 10px;
                }

        .tagify__tag-text {
            text-align: center !important;
        }


        .photo {
            width: 80px;
            height: 85px;
            transform: scale(1);
            transition: transform .5s;
        }

            .photo:hover {
                transform: scale(1.15);
                cursor: pointer;
            }

        .div_info {
            background-color: #f4f4f4;
            padding: 8px 12px !important;
            color: #333;
            box-shadow: 0px -1px 5px 2px rgb(204 204 204);
        }

        .card-style {
            background-color: #fff;
            border-radius: 12px;
            border: 1px solid #e0e0e0; /* لبه خیلی لطیف */
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08); /* سایه ملایم */
            padding: 12px;
            margin-bottom: 15px;
            transition: box-shadow 0.3s ease;
        }

            .card-style:hover {
                box-shadow: 0 2px 12px rgba(0, 0, 0, .48); /* سایه بیشتر هنگام هاور */
            }

        .h_210 {
            height: 210px !important;
        }

        .card_container {
            display: grid;
            grid-template-columns: repeat(auto-fill, 130px);
            justify-content: space-between;
            box-sizing: border-box;
        }

        .hidden-div > * {
            opacity: 0;
            transform: translateY(-30px);
            filter: blur(8px);
        }

        .hidden-div.show > * {
            animation: softIn 0.4s ease-in forwards;
        }

            .hidden-div.show > *:nth-child(1) {
                animation-delay: 1.5s;
            }

            .hidden-div.show > *:nth-child(2) {
                animation-delay: 0.3s;
            }

            .hidden-div.show > *:nth-child(3) {
                animation-delay: 0.6s;
            }

            .hidden-div.show > *:nth-child(4) {
                animation-delay: 0.8s;
            }

            .hidden-div.show > *:nth-child(5) {
                animation-delay: 1s;
            }

        @keyframes softIn {
            to {
                opacity: 1;
                transform: translateY(0);
                filter: blur(0);
            }
        }
    </style>
    <link href="../../style/jquery-ui.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/tagify1/tagify.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js"></script>
    <script src="../../script/jquery-ui.min.js"></script>
    <script src="../../script/main.js"></script>
    <script src="../../style/tagify1/tagify.js"></script>
    <script src="../../style/tagify1/tagify.js"></script>
    <script src="../../style/tagify1/tagify.polyfills.min.js"></script>
    <script src="../../style/alert/sweetalert2@11.js"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>
        $(document).ready(function () {
            doc_code = initial_page(3000, 2000);
            reqsvr("load_data", "code:'" + doc_code + "'", function (data) {
                $('#sub_doc').val(data.d[0]);
                document.title = data.d[0];
                $("#slc_doc_topic").prepend(new Option(data.d[1], "0"));
                $("#slc_doc_topic").val("0");
                $("#doc_tags").val(data.d[2]);
                var input = document.querySelector('input[name="input-custom-dropdown"]'),
                    tagify = new Tagify(input);
                $("#div_description").html(data.d[3].replace(/\[bsl\]/g, '\\').replace(/\[sqt\]/g, "'").replace(/\[dqt\]/g, '"'));
                var files = data.d[4];
                var comments = data.d[5];
                if (comments) {
                    $("#comment_count").text(comments.split('*').length + " دیدگاه");
                    for (var i = 0; i < comments.split('*').length; i++)
                        $("#comments").append("<div class=\"media\" style=\"padding-top: 0px;padding-bottom: 0px;\"><div id=\"" + comments.split('*')[i].split(',')[0] + "\" class=\"media-body\"> \
                                <p class=\"list-unstyled list-inline media-detail pull-left\">"+ comments.split('*')[i].split(',')[3] + "<i style=\"margin-right: 5px;\" class=\"fa fa-calendar\"></i></p> \
                                <p class=\"media-heading\">"+ comments.split('*')[i].split(',')[1] + "</p><h4>" + comments.split('*')[i].split(',')[2] + "</h4></div></div>");
                } else {
                    $("#comments").parent().hide();
                    $("#comment_count").text(comments.split('*').length - 1 + " دیدگاه");
                }
                if (files) {
                    for (var i = 0; i < files.split('*').length; i++) {
                        var image_path = "";
                        switch (files.split('*')[i].split(',')[2]) {
                            case "jpg":
                            case "jpeg":
                            case "png":
                                image_path = "<img onclick=\"open_file(this,'perm')\" title=\"" + files.split('*')[i].split(',')[3] + "\" src = \"" + "\\files\\perm\\" + files.split('*')[i].split(',')[0] + "." + files.split('*')[i].split(',')[2] + "\" class= \"col-xs-12 photo\" alt = \"" + files.split('*')[i].split(',')[1] + "\" height = \"100\" />";
                                break;
                            case "mp4":
                            case "m4v":
                            case "mkv":
                            case "avi":
                            case "webm":
                            case "wmv":
                                image_path = "<img onclick=\"open_file(this,'perm')\" title=\"" + files.split('*')[i].split(',')[3] + "\" src = \"" + "\\image\\video.png" + "\" class= \"col-xs-12 photo\" alt = \"" + files.split('*')[i].split(',')[1] + "\"  />";
                                break;
                            case "txt":
                                image_path = "<img onclick=\"open_file(this,'perm')\" title=\"" + files.split('*')[i].split(',')[3] + "\" src = \"" + "\\image\\txt1.png" + "\" class= \"col-xs-12 photo\" alt = \"" + files.split('*')[i].split(',')[1] + "\"  />";
                                break;
                            case "pdf":
                                image_path = "<img onclick=\"open_file(this,'perm')\" title=\"" + files.split('*')[i].split(',')[3] + "\" src = \"" + "\\image\\pdf1.png" + "\" class= \"col-xs-12 photo\" alt = \"" + files.split('*')[i].split(',')[1] + "\"  />";
                                break;
                            case "":
                                image_path = "<img onclick=\"open_file(this,'perm')\" title=\"" + files.split('*')[i].split(',')[3] + "\" src = \"" + "\\image\\link1.png" + "\" class= \"col-xs-12 photo\" alt = \"" + files.split('*')[i].split(',')[1] + "\"  />";
                                break;
                            case "mp3":
                            case "aac":
                            case "wav":
                            case "wma":
                            case "ogg":
                                image_path = "<img onclick=\"open_file(this,'perm')\" title=\"" + files.split('*')[i].split(',')[3] + "\" src = \"" + "\\image\\audio1.png" + "\" class= \"col-xs-12 photo\" alt = \"" + files.split('*')[i].split(',')[1] + "\"  />";
                                break;
                            case "xlsx":
                            case "xlsb":
                            case "xlsm":
                                image_path = "<img onclick=\"open_file(this,'perm')\" title=\"" + files.split('*')[i].split(',')[3] + "\" src = \"" + "\\image\\excel1.png" + "\" class= \"col-xs-12 photo\" alt = \"" + files.split('*')[i].split(',')[1] + "\"  />";
                                break;
                            case "doc":
                            case "docx":
                                image_path = "<img onclick=\"open_file(this,'perm')\" title=\"" + files.split('*')[i].split(',')[3] + "\" src = \"" + "\\image\\word1.png" + "\" class= \"col-xs-12 photo\" alt = \"" + files.split('*')[i].split(',')[1] + "\"  />";
                                break;
                            default:
                                image_path = "<img onclick=\"open_file(this,'perm')\" title=\"" + files.split('*')[i].split(',')[3] + "\" src = \"" + "\\image\\other.png" + "\" class= \"col-xs-12 photo\" alt = \"" + files.split('*')[i].split(',')[1] + "\"  />";
                        }
                        is_link = "";
                        is_link_class = "col-xs-10";
                        if (files.split('*')[i].split(',')[3] == "link") {
                            is_link = "<a title=\"ارسال لینک\" onclick=\"copy_whats(this)\" class=\"btn btn-success col-xs-4\"><i class=\"fa fa-commenting-o\" aria-hidden=\"true\"></i></a><a title=\"کپی لینک\" onclick=\"copy_link(this)\" class=\"btn btn-primary col-xs-4\"><i class=\"fa fa-clipboard\" aria-hidden=\"true\"></i></a>";
                            is_link_class = "col-xs-4";
                        }
                        $("#div_files").append("<div class=\"card-style h_210\">" + image_path + " \
                    <div class=\"col-xs-12\" code=\""+ files.split('*')[i].split(',')[4] + "\" name=\"" + files.split('*')[i].split(',')[0] + "." + files.split('*')[i].split(',')[2] + "\"> \
                    <h6 class=\"col-xs-12 text-center\" style=\"overflow: hidden;overflow-wrap: anywhere;margin-top:0px;margin-bottom:0px !important;height: 72px;\">" + files.split('*')[i].split(',')[1] + "</h6> \
                    <div class=\"col-xs-12 \" style=\"display: flex; gap: 3px; padding: 0;justify-content: center;\">" + is_link + "\
                    <a title=\"حذف فایل\" onclick=\"delete_file(this)\" class=\"btn btn-danger "+ is_link_class + "\" style=\"display:none;\"><i class=\"fa fa-trash\"aria-hidden=\"true\"></i></a></div></div></div>");
                    }
                } else
                    $("#div_files").parent().hide();
                $(".hidden-div").addClass("show");
            });
        });
        let doc_code = "";
        function open_file(el, state) {
            switch ($(el).attr("title")) {
                case "تصویر":
                case "ویدئو":
                    window.open("\\files\\" + state + "\\" + $(el).nextAll("div").eq(0).attr("name"), $(el).nextAll("div").eq(0).attr("name"));
                    break;
                case "صدا":
                    window.open("\\files\\" + state + "\\" + $(el).next("div").attr("name"), $(el).next("div").attr("name"));
                    break;
                case "link":
                    window.open($(el).next("div").attr("name").substr(0, $(el).next("div").attr("name").length - 1), $(el).next("div").attr("name").substr(0, $(el).next("div").attr("name").length - 1));
                    break;
                case "فایل":
                    if (jQuery.inArray($(el).next("div").attr("name").split('.')[1], ["pdf", "txt"]) != -1)
                        window.open("\\files\\" + state + "\\" + $(el).next("div").attr("name"), $(el).next("div").attr("name"));
                    else
                        window.open("\\files\\" + state + "\\" + $(el).next("div").attr("name"), '_blank');
                    break;
            }
        }
        function submit_btn() {
            alert_success("موفق باشید");
            call_fnc();
            window.close();
        }
    </script>
</head>
<body>
    <form>
        <div class="col-xs-12 hidden-div auto-height">
            <div class="row center" id="btn_group">
                <button type="button" class="btn btn-success" onclick="submit_btn()">خوانده شد</button>
            </div>
            <div class="row">
                <div class="col-xs-4">
                    <p>عنوان :</p>
                    <input disabled="disabled" id="sub_doc" type="text" class="form-control h_38" />
                </div>
                <div class="col-xs-4">
                    <p>گروهبندی :</p>
                    <select id="slc_doc_topic" disabled="disabled" class='form-control h_38'></select>
                </div>
                <div class="col-xs-4">
                    <p>تگ ها :</p>
                    <input id="doc_tags" readonly name='input-custom-dropdown' class='w-full h_38' />
                </div>
            </div>
            <div class="row">
                <p>شرح داکیومنت :</p>
                <div class="col-xs-12">
                    <div id="div_description" class="div_info"></div>
                </div>
            </div>
            <div class="row">
                <p>فایل های داکیومنت :</p>
                <div id="div_files" class="card_container">
                </div>
            </div>
            <div class="row">
                <p>دیدگاه ها:</p>
                <p class="col-xs-1" id="comment_count"></p>
                <div id="comments" class="row">
                </div>
            </div>
        </div>
    </form>
</body>
</html>
