﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="set_document_person.aspx.cs" Inherits="TimeWork.page.set_document_person" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <style>
        .main_sty {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        #suggest_list {
            max-height: 200px;
            overflow-y: auto;
            z-index: 1000;
        }

            #suggest_list > li > a {
                display: block;
                padding: 8px 12px;
                color: #333;
                cursor: pointer;
            }

            #suggest_list > li.active > a {
                background-color: #337ab7;
                color: white;
            }

        #suggest_list {
            max-height: 350px;
            overflow-y: auto;
        }
    </style>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/alert/sweetalert2@11.js"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>
        $(document).ready(function () {
            initial_page(500, 600);
            let selectedIndex = -1;
            let debounceTimeout = null;
            let hideTimeout = null;
            const $input = $('#txt_search');
            const $suggest = $('#suggest_list');

            // ================================
            // تابع نمایش نتایج
            // ================================

            // سرچ بصورت داینامیک با طول 3 کاراکتر

            function renderSuggestions(data, query) {
                if (data.d === 'no') {
                    $suggest.html('<li class="list-group-item disabled">رکوردی وجود ندارد</li>').show();
                    selectedIndex = -1;
                    return;
                }
                const items = $.parseJSON(data.d);
                let html = items.map(item =>
                    `<li code="${item.row}" class="list-group-item">${highlight(item.name, query)} / ${highlight(item.mobile_1, query)},${highlight(item.mobile_2, query)},${highlight(item.mobile_3, query)}</li>`
                ).join('');
                $suggest.html(html).show();
                const $items = $suggest.children('li');
                if ($items.length > 0) {
                    selectedIndex = 0;
                    updateActive($items);  // فعال کردن آیتم اول
                } else {
                    selectedIndex = -1;
                }
            }

            //سرچ بصورت استاتیک با زدن اینتر

            //$("#txt_search").keydown(function (e) {
            //    if (skipNextEnter) {
            //        skipNextEnter = false;
            //        return; // جلوی اجرای دوباره جستجو رو بگیر
            //    }
            //    let query = $(this).val().trim();
            //    if (e.which === 13 && query.length >= 3) {
            //        reqsvr("search", "query:'" + query + "'", function (data) {
            //            if (data.d == "no") {
            //                $('#suggest_list').html("<br/><p style=\"margin-right:20px;\">رکوردی وجود ندارد</p><br/>").show();
            //                return;
            //            }
            //            let html = '';
            //            $.parseJSON(data.d).forEach(item => {
            //                html += '<li code="' + item.code + '" class="list-group-item">' + highlight(item.serial, query) + ' / ' + highlight(item.name, query) + ' / ' + highlight(item.name_org, query) + '</li>';
            //            });
            //            $('#suggest_list').html(html).show();
            //        });
            //    }
            //});

            // ================================
            // Debounce جستجو در keyup (غیر از کلیدهای ناوبری)
            // ================================
            $input.on('keyup', function (e) {
                const key = e.key;
                if (['ArrowUp', 'ArrowDown', 'Enter', 'Escape'].includes(key)) return;
                clearTimeout(debounceTimeout);
                const query = $(this).val().trim();
                if (query.length >= 2) {
                    debounceTimeout = setTimeout(() => {
                        reqsvr('search', `query:'${query}'`, function (data) {
                            renderSuggestions(data, query);
                        });
                    }, 300);
                } else {
                    clearTimeout(debounceTimeout);
                    $suggest.hide().empty();
                    selectedIndex = -1;
                }
            });

            // ================================
            // ناوبری با کلیدها (keydown)
            // ================================
            $input.on('keydown', function (e) {
                const $items = $suggest.children('li');
                if (!$items.length) return;
                clearTimeout(hideTimeout);
                switch (e.key) {
                    case 'ArrowDown':
                        e.preventDefault();
                        if (selectedIndex < $items.length - 1) selectedIndex++;
                        updateActive($items);
                        break;
                    case 'ArrowUp':
                        e.preventDefault();
                        if (selectedIndex > 0) selectedIndex--;
                        updateActive($items);
                        break;
                    case 'Enter':
                        if (selectedIndex >= 0) {
                            e.preventDefault();
                            selectItem($items.eq(selectedIndex));
                        }
                        break;
                    case 'Escape':
                        hideWithDelay();
                        clear_search();
                        break;
                }
            });

            // ================================
            // ماوس: hover روی آیتم‌ها
            // ================================
            $suggest.on('mouseenter', 'li', function () {
                clearTimeout(hideTimeout);
                const $items = $suggest.children('li');
                selectedIndex = $(this).index();
                updateActive($items);
            });

            // ================================
            // کلیک روی آیتم
            // ================================
            $suggest.on('click', 'li', function () {
                selectItem($(this));
            });

            // ================================
            // محو شدن لیست با تأخیر (blur و کلیک خارج)
            // ================================
            //$input.on('blur', hideWithDelay);
            //$(document).on('click', function (e) {
            //    if (!$(e.target).closest('#txt_search, #suggest_list').length) {
            //        hideWithDelay();
            //    }
            //});

            // ================================
            // توابع کمکی
            // ================================
            function updateActive($items) {
                $items.removeClass('active');
                if (selectedIndex >= 0) {
                    const $activeItem = $items.eq(selectedIndex);
                    $activeItem.addClass('active');
                    $activeItem[0].scrollIntoView({
                        block: 'nearest',   // وسط یا بالا یا پایین → 'nearest' بهتره
                        behavior: 'smooth'  // انیمیشن اسکرول
                    });
                }
            }
            function selectItem($li) {
                const code = $li.attr('row');
                const text = $li.text();
                $input.val(text).attr('row', code).blur();
                $suggest.hide().empty();
                $('#btn_x').show();
                $("#tbl_person tbody").html('');
                for (var i = 0; i < text.split('/')[1].split(',').length; i++) {
                    if ($.trim(text.split('/')[1].split(',')[i]) == '')
                        continue;
                    $("#tbl_person tbody").append("<tr><td><input checked code=\"" + code + "\" type=\"checkbox\" name=\"person\" value=\"" + text.split('/')[1].split(',')[i] + "\" class=\"form-control\" /></td><td name=\"person_name\">" + text.split('/')[0] + "</td><td>" + text.split('/')[1].split(',')[i] + "</td></tr>");
                }
                //var checkedValues = $('input[name="person"]:checked').map(function () {
                //    return $.trim(this.value);
                //}).get();
                //parent.temp = checkedValues.join(',');
                $("#" + code).prop("checked", true);
                selectedIndex = -1;
            }
            function hideSuggestions() {
                $suggest.hide().empty();
                $("#txt_search").val('');
                selectedIndex = -1;
            }
            function hideWithDelay() {
                clearTimeout(hideTimeout);
                hideTimeout = setTimeout(hideSuggestions, 300);
            }
            function highlight(text, keyword) {
                if ($.trim(text).length == 0)
                    return "";
                var pattern = new RegExp("(" + keyword + ")", "gi");
                return text.replace(pattern, "<span class='red'>$1</span>");
            }
            $("#txt_search").on("click", function () {
                if ($.trim($("#txt_search").val()) != '') {
                    $(this).select();
                }
            });

            $("#btn_x").click(function () {
                clear_search();
                hideWithDelay();
            });
            //$('#tbl_person').on('change', 'input[name="person"]', function () {
            //    var checkedValues = $('input[name="person"]:checked').map(function () {
            //        return $.trim(this.value);
            //    }).get();
            //    parent.temp = checkedValues.join(',');
            //});
            _unwait();
        });
        function clear_search() {
            $("#txt_search").val('');
            $("#btn_x").hide();
            $("#txt_search").focus();
        }
        function submit_btn() {
            var checkedValues = $('input[name="person"]:checked').map(function () {
                return $.trim(this.value);
            }).get();
            parent.temp = checkedValues.join(',');
            parent.temp += '&' + $('td[name="person_name"]').first().text();
            call_fnc();
            close();
        }
    </script>
</head>
<body>
    <form>
        <div class="dock-full container">
            <div class="col-xs-12 main_sty">
                <input style="height: 40px;" id="txt_search" type="text" placeholder="تایپ کنید ..." class="form-control" autocomplete="off" />
                <span id="btn_x" style="margin-top: -3px; font-size: 25px; color: lightcoral; position: absolute; margin-right: -35px; display: none;" onclick="clear_search()" title="جستجو جدید"><i class="fa fa-times fa-lg" aria-hidden="true"></i></span>
                <ul id="suggest_list" class="dropdown-menu" style="padding: 0px; width: 100%; left: 0; display: none; max-height: 300px;"></ul>
            </div>
            <div class="col-xs-12 main_sty">
                <table id="tbl_person" class="table table-bordered">
                    <thead>
                        <tr>
                            <th></th>
                            <th>نام</th>
                            <th>شماره</th>
                        </tr>
                    </thead>
                    <tbody>
                        <%--                            <tr>
                                <td>
                                    <input type="checkbox" name="person" value="1" class="form-control" /></td>
                                <td>علی حسینی</td>
                                <td>099477277273</td>
                                <td>باقالی پلو</td>
                            </tr>--%>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="toolbar-footer">
            <button type="button" class="btn btn-success" onclick="submit_btn()">ذخیره</button>
        </div>
    </form>
</body>
</html>
