﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_food.aspx.cs"
    Inherits="TimeWork.page_food" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>

    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../script/jquery-ui.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/sorter/RowSorter.js"></script>
    <script src="../../style/mask/jquery.mask.min.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>

    <script>
        var ecode;
        var dt_material;
        $(document).ready(function () {
            var a = initial_page(800, 600);
            ecode = a[0];
            reqsvr("loading", "code:" + ecode, function (data) {
                load_cb("#cb_food_kind", data.d[0]);
                dt_material = data.d[1];
                if (ecode != '0') {
                    set_XML_div("#div_main", data.d[2]);
                }
                fix_header_only = true;
                load_tbl_btn(data.d[3], "material");
                initial_sorter("#tbl_material");
                calc_price();
                initial_number();
            });
        });

        var row_index = -1;
        function new_material() {

            row_index = -1;
            show_modal("جدید", "#div_material_change");

            $("#cb_food_material").addClass("selectpicker");
            load_cb("#cb_food_material", dt_material);

            change_food_material();
        }
        function change_food_material() {

            var material_id = $("#cb_food_material").val();
            var row_material = search_xml(dt_material, material_id);
            $("#lb_measure").html($(row_material).find("measure").text());
            $("#tb_material_price").val((1 * $(row_material).find("price").text()).toLocaleString());

        }

        function edit_material(o) {
            show_modal("ویرایش", "#div_material_change");

            $("#cb_food_material").addClass("selectpicker");

            row_index = $(o).closest('tr').index();
            var material_id = $(o).closest('tr').attr("code");
            load_cb_not_select("#cb_food_material", dt_material, material_id);
            selectpicker_disable("#cb_food_material");
            $("#tb_material_cnt").val($(o).closest('tr').find("td").eq(2).html());
            var row_material = search_xml(dt_material, material_id);
            $("#lb_measure").html($(row_material).find("measure").text());
            $("#tb_material_price").val((1 * $(row_material).find("price").text()).toLocaleString());
        }
        function save_material() {


            if ($("#tb_material_cnt").val() == "" || $("#tb_material_cnt").val() == undefined) $("#tb_material_cnt").val(1);
            var material_id = $("#cb_food_material").val();

            var row_material = search_xml(dt_material, material_id);
            var cnt = $("#tb_material_cnt").val();
            var price = cnt * $(row_material).find("price").text();
            var i = 0;
            $('#tbl_material tbody tr').each(function () {
                if ($(this).attr('code') == material_id) {
                    row_index = i;

                }
                i = i + 1;
            });
            if (row_index == -1) {
                var tr = '<tr code="' + material_id + '">' +
                    '<td>' + ($("#tbl_material tbody").find('tr').length + 1) + '</td>' +
                    '<td>' + $(row_material).find("name").text() + '</td>' +
                    '<td>' + cnt + '</td>' +
                    '<td>' + $(row_material).find("measure").text() + '</td>' +
                    '<td>' + price.toLocaleString() + '</td>' +
                    '<td class="align-center"><button onclick="edit_material(this)" class="btn btn-default glyphicon glyphicon-pencil" type="button" title="ویرایش">' +
                    '</button><button onclick="delete_material(this)" class="btn btn-default glyphicon glyphicon-trash red" type="button" title="حذف"></button> </td>' +
                    '</tr>';
                $("#tbl_material").find('tbody').append(tr);
            }
            else {
                var row = $("#tbl_material tbody").find('tr').eq(row_index);
                row.attr("code", material_id);
                row.find("td").eq(1).html($(row_material).find("name").text());
                row.find("td").eq(2).html(cnt);
                row.find("td").eq(3).html($(row_material).find("measure").text());
                row.find("td").eq(4).html(price.toLocaleString());
            }
            calc_price();
            close_modal();
        }

        function save() {
            var material = "";
            $('#tbl_material tbody tr').each(function () {
                material = material + "☺" + $(this).attr('code') + "☻" + $(this).find('td:nth-child(3)').html();

            });
            if ($('#tb_cook_price').val() == "") $('#tb_cook_price').val('0');

            if (material.length > 0) material = material.slice(1);
            reqsvr("save",
                "code:" + ecode + ",name:'" + $('#tb_name').val() + "',price:'" + $('#tb_price').val().replaceAll(',', '') + "',cook_price:'" + $('#tb_cook_price').val().replaceAll(',', '') + "',food_kind:'" + $('#cb_food_kind').val() + "',material:'" + material + "',disable:'" + $("#chb_disable")[0].checked + "'",
                function (data) {
                    if (data.d == "ok") {
                        alert_success("ذخیره شد");
                        call_fnc();
                        close();
                    } else {
                        alert_error(data.d);

                    }
                });

        }
        function calc_price() {
            var sum_p = 0;
            if ($('#tb_cook_price').val() == "") $('#tb_cook_price').val('0');
            $('#tbl_material tbody tr').each(function () {
                var p = $(this).find('td:nth-child(5)').html();
                sum_p = sum_p + parseFloat(p.replaceAll(',', ''));
            });
            sum_p = sum_p + parseFloat($('#tb_cook_price').val().replaceAll(',', ''));

            $("#tb_price_sum").val(sum_p.toLocaleString());

        }
        function delete_material(o) {
            $(o).closest('tr').remove();
            initial_sorter("#tbl_material");
        }
        function show_material() {
            var old_val = $("#tb_material_cnt").val();
            open_form_("../../page/food/page_material_list.aspx", "مواد غذایی", "0", "", "load_material(" + old_val + ")");


        }
        function load_material(old_val) {
            reqsvr("load_material", "", function (data) {

                dt_material = data.d;
                load_cb_not_select("#cb_food_material", dt_material, old_val);
            });
        }
    </script>

</head>
<body>
    <form class="panel">
        <div id="div_main">
            <div class="row">
                <div class="col-xs-2">عنوان :</div>
                <div class="col-xs-5">
                    <input id="tb_name" name="name" type="text" class="form-control" />
                </div>
                <div class="col-xs-5">
                            <input id="chb_disable" name="disable"  class="form-control" type="checkbox" /><span>غیرفعال</span>

                </div>
            </div>
            <div class="row">
                <div class="col-xs-2">نوع غذا :</div>
                <div class="col-xs-4">
                    <select id="cb_food_kind" name="food_kind" class="form-control"></select>

                </div>
                <div class="col-xs-2">مبلغ پیش فرض :</div>
                <div class="col-xs-2">
                    <input id="tb_price" type="text" name="price" class="form-control num " value="0" />
                </div>
                <div class="col-xs-2">
                    <span>ریال</span>
                </div>
            </div>
        </div>
        <br />
        <div id="div_material" class="auto-height pad5">
        </div>

        <div class="footer" style="height: 90px">
            <div class="row">
                <div class="col-xs-6"></div>
                <div class="col-xs-2">قیمت طبخ و توزیع :</div>
                <div class="col-xs-2">
                    <input id="tb_cook_price" type="text" name="cook_price" class="form-control num" value="0" />
                </div>
                <div class="col-xs-1">
                    <span>ریال</span>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6"></div>
                <div class="col-xs-2">قیمت تمام شده مواد :</div>
                <div class="col-xs-2">
                    <input id="tb_price_sum" type="text" name="price_sum" class="form-control num" readonly="readonly" value="0" />
                </div>
                <div class="col-xs-1">
                    <span>ریال</span>
                </div>
            </div>
        </div>

        <div class="toolbar-footer">
            <button type="button" class="btn btn-success glyphicon glyphicon-floppy-disk " onclick="save()"><span>ذخیره</span></button>
        </div>
        <div class="hide">
            <div id="div_material_change" style="width: 500px;">
                <br />
                <div class="row">
                    <div class="col-xs-3">
                        <label>مواد غذایی :</label>
                    </div>
                    <div class="col-xs-9">
                        <select name="cb_food_material" class="" data-width="90%" data-size="10" data-live-search="true" onchange="change_food_material()">
                        </select>
                        <button onclick="show_material( )" type="button" class="btn btn-default" title="لیست مواد غذایی"><span class="glyphicon glyphicon-option-horizontal"></span></button>

                    </div>
                </div>
                <div class="row">
                    <div class="col-xs-3">
                        <label>مقدار :</label>
                    </div>
                    <div class="col-xs-9">
                        <input name="tb_material_cnt" type="text" class="form-control  w-50" />
                        <label name="lb_measure"></label>

                    </div>
                </div>
                <div class="row">
                    <div class="col-xs-3">
                        <label>قیمت واحد :</label>
                    </div>
                    <div class="col-xs-9">

                        <input name="tb_material_price" type="text" class="form-control num w-75" value="0" readonly="readonly" />
                        <label>ریال</label>

                    </div>
                </div>

                <br />
                <div class="toolbar-footer-modal">
                    <button type="button" class="btn btn-success glyphicon glyphicon-floppy-disk " onclick="save_material()"><span>ثبت</span></button>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
