﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_feedback_list.aspx.cs" Inherits="TimeWork.page_feedback_list" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js"></script>
    <script src="../../style/mask/jquery.mask.min.js"></script>
    <script src="../../style/select/bootstrap-select.js"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../script/fncDate.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>
        $(document).ready(function () {
            initial_page(1200, 600);
            reqsvr("load", "", function (data) {
                load_cb_not_select("#cb_feedback_kind", data.d[0]);
                $('#tb_sdate').val(data.d[1]);
                $('#tb_edate').val(data.d[2]);
                search();
            }
            );
        })

        function search() {
            const cb_feedback_kind = get_cb("#cb_feedback_kind");

            reqsvr("search", "sdate:'" + $("#tb_sdate").val() + "' ,edate:'" + $("#tb_edate").val() + "',feedback_kind:'" + cb_feedback_kind + "'", function (data) {
                load_tbl(data.d, "table");
                $("#div_filter").collapse('hide');

                $('#tbl_table tbody td[col_name=btn]').each(function () {
                    if ($(this).closest('tr').find('td[col_name=path]').text() != "")
                        $(this).append('<button class="btn btn-default fa fa-paperclip"  type="button" title="فایل پیوست" onclick="view_attch(this)" ></button>');
                    $(this).append('<button class="btn btn-default fa fa-envelope-o"   type="button" title="درج پاسخ" onclick="view_rep(this)" ></button>');
                });
            });
        }

        function view_attch(o) {
            
            file_download($(o).closest('tr').find('td[col_name="path"]').text(), "AttachFile");
        }
        function view_rep(o) {
            var el = $(o).closest('tr');
            show_input_alert("پاسخ", $(el).find('td[col_name="comment_ack"]').text(), function (v) {
                if (v.length > 100) {
                    alert_error("تعداد کاراکتر بیشتر از حد مجاز می باشد");
                    return;
                }
                reqsvr("reply_report", "code:" + $(el).attr("code") + " ,new_reply:'" + v + "'", function (data) {
                    if (data.d == "error_id") {
                        alert_error("شما مجوز تغییر پاسخ را ندارید");
                        return;
                    }
                    const arr = data.d.split("&")
                    $(el).find('td[col_name="ftime_ack"]').text(arr[0])
                    $(el).find('td[col_name="comment_ack"]').text(arr[1])
                    $(el).find('td[col_name="pname_ack"]').text(arr[2])
                });
            });
        }

    </script>
</head>
<body>
    <form>
        <div>
            <div class="btn-group bg-menu">
                <button type="button" class="btn btn-default block collapsed pull-right" data-toggle="collapse" data-target="#div_filter" aria-expanded="false"><span class="glyphicon glyphicon-filter">&nbsp;</span>فیلتر</button>
            </div>
            <div id="div_filter" class="filter collapse" aria-expanded="false" style="height: 20px;">
                <div class="row">
                    <div class="col-sm-6">
                        <div>تاریخ ابتدا :</div>
                        <input id="tb_sdate" type="text" class="form-control date" />
                    </div>
                    <div class="col-sm-6">
                        <div>تاریخ انتها :</div>
                        <input id="tb_edate" type="text" class="form-control date" />
                    </div>
                </div>
                <br />
                <div class="row">
                    <div>نوع بازخورد :</div>
                    <select id="cb_feedback_kind" class="selectpicker " data-width="100%" data-size="10" multiple="multiple" data-actions-box="true" multiple data-selected-text-format="count > 3">
                    </select>
                </div>
                <div class="row align-center" style="border-top: solid 1px; margin-top: 5px; padding-top: 5px;">
                    <button type="button" value=" " class="btn btn-primary" onclick="search(this)"><span class="glyphicon glyphicon-search">&nbsp;</span>جستجو</button>&nbsp;
                </div>
            </div>
            <div class="auto-height" id="div_table"></div>
        </div>
    </form>
</body>
</html>
