﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_table_fields.aspx.cs" Inherits="TimeWork.page_table_fields" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>

    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />

    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/sorter/RowSorter.js"></script>

    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>  
        $(document).ready(function () {
            var ar = initial_page(600, 600);

            load();

        });
        function load() {
            reqsvr("load", "", function (data) {
                load_cb("#cb_table", data.d);
                $("#cb_table").val($("#cb_table option:first").val());
                load_sub();
            });
        }

        function load_sub() {
            reqsvr("load_sub", "code:" + $('#cb_table').val(), function (data) {
                load_cb("#cb_table_sub", data.d[0]);
                $("#cb_table_sub").val($("#cb_table_sub option:first").val());
                $('#lb_table_sub').html(data.d[1]);
                load_field();
            });
        }

        function load_field() {

            reqsvr("load_field", "table_id:" + $("#cb_table").val() + ",table_sub_id:" + $("#cb_table_sub").val(), function (data) {
                var headers = [];
                headers.push('<thead ><tr>');
                headers.push('<th class="w-50" > </th>');
                headers.push('<th class="w-150"><span>نام</span></th>');
                headers.push('<th><span>عنوان نمایشی</span></th>');
                headers.push('<th class="w-100"><span>نوع</span></th>');
                headers.push('<th class="w-100"><span>طول متن</span></th>');
                headers.push('<th><span>گروه پارامتر</span></th>');
                headers.push('<th class="w-50"><span>مقدار پیش فرض</span></th>');
                headers.push('<th class="w-50"><span>حداقل</span></th>');
                headers.push('<th class="w-50"><span>حداکثر</span></th>');
                headers.push('<th class="w-50"><span>سیستمی</span></th>');
                headers.push('<th class="w-50"><span>ورود اجباری</span></th>');
                headers.push('<th class="w-50"><span>کنترل تکراری</span></th>');
                headers.push('<th class="w-50"><span>محاسباتی</span></th>');
                headers.push('<th class="w-50"><span>گزارشی</span></th>');
                headers.push('<th class="w-50"><span>تنظیم گروهی</span></th>');
                headers.push('<th class="w-50"><span>رنگ</span></th>');
                headers.push('<th class="w-75 "><button type="button" onclick="new_field()" class="btn btn-info glyphicon glyphicon-plus"  title="اضافه جدید"   /></button > </th>');
                headers.push('</tr></thead>');
                var rows = [];
                rows.push('<tbody>');

                var xml = XMLparse(data.d);
                var findrows = xml.find("mytable");
                var i = 0;
                $(findrows).each(function () {

                    i++;
                    rows.push('<tr  code="' + $(this).find('code').text() + '">');
                    rows.push('<td class="sorter">' + i.toString() + ' </td>');
                    rows.push('<td >' + $(this).find('name').text() + ' </td>');
                    rows.push('<td  >' + $(this).find('title').text() + ' </td>');
                    rows.push('<td  >' + $(this).find('field_type').text() + ' </td>');
                    rows.push('<td  >' + $(this).find('lenght').text() + ' </td>');
                    rows.push('<td  >' + $(this).find('item_group').text() + ' </td>');
                    rows.push('<td  >' + $(this).find('default_').text() + ' </td>');
                    rows.push('<td  >' + $(this).find('min_').text() + ' </td>');
                    rows.push('<td  >' + $(this).find('max_').text() + ' </td>');
                    if ($(this).find('system').text() == '1')
                        rows.push('<td  ><span class="glyphicon glyphicon-ok"  ></span></td>');
                    else rows.push('<td> </td>');

                    if ($(this).find('force').text() == '1')
                        rows.push('<td  ><span class="glyphicon glyphicon-ok"  ></span></td>');
                    else rows.push('<td> </td>');
                    if ($(this).find('duplicate').text() == '1')
                        rows.push('<td  ><span class="glyphicon glyphicon-ok"  ></span></td>');
                    else rows.push('<td> </td>');
                    if ($(this).find('calcute').text() == '1')
                        rows.push('<td  ><span class="glyphicon glyphicon-ok"  ></span></td>');
                    else rows.push('<td> </td>');
                    if ($(this).find('report').text() == '1')
                        rows.push('<td  ><span class="glyphicon glyphicon-ok"  ></span></td>');
                    else rows.push('<td> </td>');
                    if ($(this).find('group').text() == '1')
                        rows.push('<td  ><span class="glyphicon glyphicon-ok"  ></span></td>');
                    else rows.push('<td> </td>');
                    rows.push('<td style="color:' + $(this).find('color').text() + '; background-color:' + $(this).find('bg_color').text() + '; " >A</td>');
                    rows.push('<td>');
                    //rows.push('<button type="button" class="btn glyphicon glyphicon-menu-up"   onclick="field_up(this)  "></button>');
                    //rows.push('<button type="button" class="btn glyphicon glyphicon-menu-down" onclick="field_down(this)"></button>');
                    if ($(this).find('system').text() != '1') {

                        rows.push('<button type="button" class="btn glyphicon glyphicon-pencil" onclick="edit_field(this)  " title="ویرایش"></button>');
                        rows.push('<button type="button" class="btn glyphicon glyphicon-trash red"  onclick="delete_field(this)" title="حذف">  </button>');
                    }
                    rows.push('</td>');
                    rows.push('</tr>');
                });
                rows.push('</tbody>');
                var top = '<table  id="tbl_field"  class="table table-bordered table-hover tableFixHead ">';
                var bottom = '</table>';
                $('#div_field').html(top + headers.join("") + rows.join("") + bottom);
                initial_sorter("#tbl_field", function (old_index, new_index) {
                    var cc = "";
                    wait_();
                    $('#tbl_field  tbody tr').each(function () {
                        cc = cc + "," + $(this).attr('code');
                    });
                    if (cc != "") cc = cc.slice(1);
                    reqsvr("change_sort", "code:'" + cc + "'", function (data) { unwait_(); });

                    //alert('onDrop: row moved from ' + old_index + ' to ' + new_index);
                });



            });
        }
        function new_field() {
            open_form_('page/data/page_field_new.aspx', "جدید", "0&" + $('#cb_table').val() + "&" + $('#cb_table_sub').val(), "load_field");
        }

        function edit_field(th) {

            open_form_('page/data/page_field_new.aspx', "ویرایش", $(th).closest('tr').attr("code") + "&" + $('#cb_table').val() + "&" + $('#cb_table_sub').val(), "load_field");


        }
        function delete_field(th) {

            confirm_alert(function () {
                reqsvr("delete_field", "code:" + $(th).closest('tr').attr("code"),
                    function (data) {
                        if (data.d == "ok") {
                            $(th).closest('tr').remove();
                            alert_message("حذف انجام شد");
                        }
                        else
                            alert_error(data.d);
                    });
            });

        }
    </script>
</head>
<body>
    <form>
        <div class="h-40 bg-menu">
            <div class="inline">
                <span>انتخاب جدول : </span>
                <select id="cb_table" class="form-control w-200" onchange="load_sub()">
                </select>
            </div>
            <div id="div_table_sub" class="inline">
                <span id="lb_table_sub">انتخاب : </span>
                <select id="cb_table_sub" class="form-control w-200" onchange="load_field()">
                </select>
            </div>
            <button type="button" title="فراخوانی مجدد" class="btn glyphicon glyphicon-refresh" style="margin-top: -3px;" onclick="load()">
            </button>
        </div>
        <div id="div_field" class="auto-height">
        </div>

    </form>
</body>
</html>
