﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_table.aspx.cs" Inherits="TimeWork.page_table" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>

    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/bootstrap-color-picker/bootstrap-colorpicker.css" rel="stylesheet" />
    <link href="../../style/bootstrap-editable/bootstrap-editable.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/bootstrap-color-picker/bootstrap-colorpicker.js"></script>
    <script src="../../style/bootstrap-editable/bootstrap-editable.js" type="text/javascript"></script>
    <script src="../../style/sorter/RowSorter.js"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script> 


        var tbl_name = "";
        $(document).ready(function () {
            var ar = initial_page(800, 600);
            tbl_name = ar[0];
            load();
            $.fn.editable.defaults.mode = 'inline';
        });

        function load() {

            reqsvr("load", "tbl_name:'" + tbl_name + "'", function (data) {
                var headers = [];
                headers.push('<thead><tr>');
                headers.push('<th class="w-25"><span>ردیف</span></th>');
                headers.push('<th class="w-50"><span>کد</span></th>');
                headers.push('<th><span>عنوان</span></th>');
                headers.push('<th class="w-150"><span>وضعیت</span></th>');
                headers.push('<th class="w-175"><span>رنگ زمینه</span></th>');
                headers.push('<th class="w-25"><button onclick="new_()" class="btn btn-info glyphicon glyphicon-plus" type="button" title="اضافه جدید"/></button > </th>');
                headers.push('</tr></thead>');
                var rows = [];
                rows.push('<tbody>');

                var i = 1;
                $(data.d).find("mytable").each(function () {
                    var is_system = !($(this).find('system').text() == "" || $(this).find('system').text() == "0");
                    rows.push('<tr code="' + $(this).find('code').text() + '">');
                    rows.push('<td class="sorter">' + i + '</td>');
                    rows.push('<td class="center">' + $(this).find('code').text() + ' </td>');
                    var name = $(this).find('name').text();
                    if ($(this).find('code').text() == "0" || is_system)
                        rows.push('<td><span  name="name">' + name + '</span>&nbsp;<span class="badge ">سیستمی</span></td>');
                    else
                        rows.push('<td><a href="#" data-type="text" class="editable editable-click" name="name">' + name + '</a></td>');

                    if ($(this).find('disable').text() == "0")
                        rows.push('<td><a href="#" data-type="select" class="editable editable-click"name="disable" data-pk="1"style="color: green;" data-value="1"></a></td>');
                    else
                        rows.push('<td><a href="#" data-type="select" class="editable editable-click"name="disable" data-pk="1"style="color: gray;" data-value="2"></a></td>');
                    rows.push('<td><div class="row  no-padding"> <div class="col-xs-7 no-padding"> <div class="input-group colorpicker-component w-100"><input type="text" name="back_color" value_old ="' + $(this).find('back_color').text() + '" value ="' + $(this).find('back_color').text() + '" class="tahoma form-control ltr"/><span class="input-group-addon" style="padding: 3px 9px;"><i></i></span></div></div><div name="save" class="col-xs-5 no-padding center hide"> <button type="button" class="btn btn-success " onclick="save_color(this)"><i class="glyphicon glyphicon-ok"></i></button><button type="button" class="btn btn-primary" onclick="cancel_color(this)"><i class="glyphicon glyphicon-share-alt"></i></button></div></div></td>');
                    rows.push('<td style="padding: 1px; text-align: center;">');

                    if ($(this).find('code').text() != "0" && !is_system)
                        rows.push('<button onclick="delete_(this)" class="btn btn-danger glyphicon glyphicon-trash" type="button" title="حذف"/></button>');
                    rows.push('</td></tr>');
                    i = i + 1;
                });
                rows.push('</tbody>');
                var top = '<table id="tbl_items" class="table table-bordered table-hover">';
                var bottom = '</table>';
                $('#div_main').html(top + headers.join("") + rows.join("") + bottom);
                set_datatable('#div_main');
                $('.editable[name=name]').editable({
                    validate: function (value) {
                        if ($.trim(value) == '')
                            return 'عنوان را وارد کنید';
                    },
                    url: function (params) {
                        var d = new $.Deferred();

                        reqsvr("save", "tbl_name:'" + tbl_name + "',code:" + $(this).closest('tr').attr("code") + ",name:'name',value:'" + params.value + "' "
                            , function (data) {
                                if (data.d == "ok") {
                                    d.resolve();
                                    alert_message("ذخیره شد");
                                }
                                else {
                                    d.reject(data.d);
                                }
                            });
                        return d.promise();
                    }
                });
                $('.editable[name=disable]').editable({
                    //prepend: "خالی",
                    source: [
                        { value: 1, text: 'فعال' },
                        { value: 2, text: 'غیر فعال' }
                    ],
                    display: function (value, sourceData) {
                        var colors = { 1: "green", 2: "gray" },
                            elem = $.grep(sourceData, function (o) { return o.value == value; });

                        if (elem.length) {
                            $(this).text(elem[0].text).css("color", colors[value]);
                        } else {
                            $(this).empty();
                        }
                    },
                    url: function (params) {
                        var d = new $.Deferred();

                        reqsvr("save", "tbl_name:'" + tbl_name + "',code:" + $(this).closest('tr').attr("code") + ", name:'disable',value:'" + params.value + "'"
                            , function (data) {
                                if (data.d == "ok") {
                                    d.resolve();
                                    alert_message("ذخیره شد");
                                }
                                else {
                                    d.reject(data.d);
                                }
                            });
                        return d.promise();
                    }
                });
                initial_sorter("#tbl_items", function (old_index, new_index) {
                    var cc = "";
                    wait_();
                    $('#tbl_items  tbody tr').each(function () {
                        cc = cc + "," + $(this).attr('code');
                    });
                    if (cc != "") cc = cc.slice(1);
                    reqsvr("change_sort", "tbl_name:'" + tbl_name + "',code:'" + cc + "'", function (data) { unwait_(); });

                });
                initial_color();
                $('.colorpicker-component').on('changeColor', function (event) {
                    $(this).closest('tr').find('div[name=save]').removeClass('hide');
                });
            });
        }

        function new_() {

            show_input_alert('عنوان جدید', '',
                function (v) {
                    reqsvr("save", "tbl_name:'" + tbl_name + "',code:-1,name:'name',value:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {
                                load();
                            }
                            else
                                alert_error(data.d);
                        });
                });
        }

        function save_color(e) {
            var v = $(e).closest('tr').find('input[name=back_color]').val();
            reqsvr("save", "tbl_name:'" + tbl_name + "',code:" + $(e).closest('tr').attr('code') + ",name:'back_color',value:'" + v + "'",
                function (data) {
                    if (data.d == "ok") {


                        $(e).closest('tr').find('.colorpicker-element').colorpicker('setValue', v);
                        $(e).closest('tr').find('input[name=back_color]').attr('value_old', v);
                        $(e).closest('tr').find('div[name=save]').addClass('hide');
                    }
                    else
                        alert_error(data.d);
                });

        }
        function cancel_color(e) {
            var ov = $(e).closest('tr').find('input[name=back_color]').attr('value_old');

            $(e).closest('tr').find('.colorpicker-element').colorpicker('setValue', ov);
            $(e).closest('tr').find('div[name=save]').addClass('hide');

        }

        function delete_(obj) {

            confirm_alert(function () {
                reqsvr("delete", "tbl_name:'" + tbl_name + "',code:" + $(obj).closest('tr').attr("code"),
                    function (data) {
                        if (data.d == "ok") {
                            $(obj).closest('tr').remove();
                            alert_message("حذف انجام شد");
                        }
                        else
                            alert_error(data.d);
                    });
            });

        }

    </script>
</head>
<body>
    <form class="pad3">
        <div id="div_main" class="auto-height  ">
        </div>
    </form>
    <p>
</p>
</body>
</html>
