﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_items.aspx.cs" Inherits="TimeWork.page_items" EnableSessionState="True" %>

<!DOCTYPE html >
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>

    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/bootstrap-editable/bootstrap-editable.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/bootstrap-editable/bootstrap-editable.js" type="text/javascript"></script>
    <script src="../../style/sorter/RowSorter.js"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>  
        $(document).ready(function () {
            initial_page(600, 600);

            load_group();
            $.fn.editable.defaults.mode = 'inline';
        });
        function new_item() {
            var elt = document.getElementById('cb_group');
            if (elt.selectedIndex == -1)
                return "";
            show_input_alert('ایجاد آیتم جدید در ' + elt.options[elt.selectedIndex].text, '',
                function (v) {
                    reqsvr("save_item", "item_group_id:" + $('#cb_group').val() + ",name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {

                                load_item($('#cb_group').val());
                            }
                            else
                                alert_error(data.d);
                        });
                });
        }

        function new_group() {

            show_input_alert('ثبت عنوان گروه', '',
                function (v) {
                    reqsvr("save_group", "name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {

                                load_group();
                            }
                            else
                                alert_error(data.d);
                        });
                });
        }
        function edit_group() {
            var elt = document.getElementById('cb_group');
            if (elt.selectedIndex == -1)
                return "";

            show_input_alert('ویرایش عنوان گروه', elt.options[elt.selectedIndex].text,
                function (v) {
                    reqsvr("edit_group", "code:" + $('#cb_group').val() + ",name:'" + v + "'",
                        function (data) {
                            if (data.d == "ok") {

                                load_group();
                            }
                            else
                                alert_error(data.d);
                        });
                });
        }

        function delete_group() {

            confirm_alert(function () {

                reqsvr("delete_group", "code:" + $('#cb_group').val(),
                    function (data) {
                        if (data.d == "ok") {

                            alert_message("حذف انجام شد");
                        }
                        else
                            alert_error(data.d);
                    });
            });
        }

        function load_group() {
            reqsvr("load", "", function (data) {
                load_cb("#cb_group", data.d);
                document.getElementById("cb_group").options[0].selected = true;
                $('.selectpicker').selectpicker('render');
                $('.selectpicker').selectpicker('refresh');
                load_item($("#cb_group").val());

            });

            $("#cb_group").on('changed.bs.select',
                function (e, clickedIndex, newValue, oldValue) {
                    var code = $(e.currentTarget).val();
                    load_item(code);
                });
        }

        function delete_item(th) {

            confirm_alert(function () {
                reqsvr("delete_item", "code:" + $(th).attr("item_id"),
                    function (data) {
                        if (data.d == "ok") {
                            $(th).closest('tr').remove();
                            alert_message("حذف انجام شد");
                        }
                        else
                            alert_error(data.d);
                    });
            });

        }
        function load_item(code) {

            reqsvr("load_item", "code:" + code, function (data) {
                var headers = [];
                headers.push('<thead><tr>');
                headers.push('<th class="w-25"><span>ردیف</span></th>');
                headers.push('<th class="w-100"><span>کد</span></th>');
                headers.push('<th><span>عنوان</span></th>');
                headers.push('<th class="w-150"><span>وضعیت</span></th>');
                headers.push('<th class="w-25"><button onclick="new_item()" class="btn btn-info glyphicon glyphicon-plus" type="button" title="اضافه جدید"   /></button > </th>');
                headers.push('</tr></thead>');
                var rows = [];
                rows.push('<tbody>');
                var i = 1;
                $(data.d).find("items").each(function () {
                    rows.push('<tr code="' + $(this).find('code').text() + '">');
                    rows.push('<td class="sorter">' + i + '</td>');
                    rows.push('<td>' + $(this).find('code').text() + '</td>');
                    rows.push('<td><a href="#" data-type="text" class="editable editable-click" name="name">' + $(this).find('name').text() + '</a></td>');
                    if ($(this).find('disable').text()=="0")
                        rows.push('<td><a href="#" data-type="select" class="editable editable-click"name="disable" data-pk="1"style="color: green;" data-value="1"></a></td>');
                    else
                        rows.push('<td><a href="#" data-type="select" class="editable editable-click"name="disable" data-pk="1"style="color: gray;" data-value="2"></a></td>');
                    rows.push('<td style="padding: 1px; text-align: center;">');
                    rows.push('<button onclick="delete_item(this)" class="btn btn-danger glyphicon glyphicon-trash " type="button" title="حذف" item_id="' + $(this).find('code').text() + '" /></button >');
                    rows.push('</td></tr>');
                    i = i + 1;
                });
                rows.push('</tbody>');
                var top = '<table id="tbl_items" class="table table-bordered table-hover">';
                var bottom = '</table>';
                $('#dgv_items').html(top + headers.join("") + rows.join("") + bottom);

                $('.editable[name=name]').editable({
                    validate: function (value) {
                        if ($.trim(value) == '')
                            return 'عنوان را وارد کنید';
                    },
                    url: function (params) {
                        var d = new $.Deferred();

                        reqsvr("edit_item", "code:" + $(this).closest('tr').attr("code") + ",item_group_id:" + $("#cb_group").val() + ",name:'name',value:'" + params.value + "'"
                            , function (data) {
                                if (data.d == "ok") {
                                    d.resolve();
                                    alert_message("ذخیره شد");
                                }
                                else {
                                    d.reject(data.d);
                                }
                            });
                        return d.promise();
                    }
                });
                $('.editable[name=disable]').editable({
                    //prepend: "خالی",
                    source: [
                        { value: 1, text: 'فعال' },
                        { value: 2, text: 'غیر فعال' }
                    ],
                    display: function (value, sourceData) {
                        var colors = {  1: "green", 2: "gray" },
                            elem = $.grep(sourceData, function (o) { return o.value == value; });

                        if (elem.length) {
                            $(this).text(elem[0].text).css("color", colors[value]);
                         } else {
                             $(this).empty();
                         }
                    },
                    url: function (params) {
                        var d = new $.Deferred();

                        reqsvr("edit_item", "code:" + $(this).closest('tr').attr("code") + ",item_group_id:" + $("#cb_group").val() + ",name:'disable',value:'" + params.value + "'"
                            , function (data) {
                                if (data.d == "ok") {
                                    d.resolve();
                                    alert_message("ذخیره شد");
                                }
                                else {
                                    d.reject(data.d);
                                }
                            });
                        return d.promise();
                    }
                });    
                initial_sorter("#tbl_items", function (old_index, new_index) {
                    var cc = "";
                    wait_();
                    $('#tbl_items tbody tr').each(function () {
                        cc = cc + "," + $(this).attr('code');
                    });
                    if (cc != "") cc = cc.slice(1);
                    reqsvr("change_sort", "code:'" + cc + "'", function (data) { unwait_(); });

                });
            });
        }

    </script>
</head>
<body>
    <form>
        <div class="btn-group bg-menu">
            <div class="btn-group-div">
                <span>گروه ها : </span>
                <select id="cb_group" class="selectpicker " data-width="300px" data-size="10" data-live-search="true">
                </select>

            </div>
            <a href="#" onclick="new_group()" title="گروه جدید" class="btn btn-info">جدید</a>
            <a href="#" onclick="edit_group()" title="ویرایش گروه" class="btn btn-warning">ویرایش</a>
            <a href="#" onclick="delete_group()" title="حذف گروه" class="btn btn-danger">حذف</a>
        </div>

        <div id="dgv_items" class="auto-height pad3">
        </div>
    </form>
</body>
</html>
