﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_chart.aspx.cs" Inherits="TimeWork.page.page_chart" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <style>
    </style>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js"></script>
    <script src="../../style/chart/chart.js"></script>
    <script src="../../style/chart/html2canvas.min.js"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>
        $(document).ready(function () {
            initial_page(2000, 1000);
            //let d_json = JSON.parse(parent.temp_chart);
            reqsvrS("json_2_chart", "json_t:'" + parent.temp_chart + "'", function (data) {
                drawTable('tbl_data', data.d);
                drawChart('reportChart', data.d, 'bar');
            });
            $('#slc_type').on('changed.bs.select', function (e, clickedIndex, isSelected) {
                var $select = $(this);
                var $options = $select.find('option');
                var $clicked = $options.eq(clickedIndex);
                var isExclusive = $clicked.data('exclusive') === true;
                if (isExclusive && isSelected) {
                    $options.prop('selected', false);
                    $clicked.prop('selected', true);
                }
                if (!isExclusive && isSelected)
                    $options.filter('[data-exclusive="true"]').prop('selected', false);
                $select.selectpicker('refresh');
                const sv = $("#slc_type").val().toString();
                if (sv.length > 0)
                    drawChart('reportChart', tbl_2_chart(), sv);
            });
            $("#tbl_data").on("change", "#chk_all", function () {
                if (this.checked)
                    $("#tbl_data tbody input[type='checkbox']").prop("checked", true);
                else
                    $("#tbl_data tbody input[type='checkbox']").prop("checked", false);
                const sv = $("#slc_type").val().toString();
                if (sv.length > 0)
                    drawChart('reportChart', tbl_2_chart(), sv);
            });
            $("#tbl_data tbody").on("change", "input[type='checkbox']", function () {
                if (!this.checked)
                    $("#chk_all").prop("checked", false);
                if ($("#tbl_data tbody input[type='checkbox']").filter(':checked').length == $("#tbl_data tbody input[type='checkbox']").length)
                    $("#chk_all").prop("checked", true);
                const sv = $("#slc_type").val().toString();
                if (sv.length > 0)
                    drawChart('reportChart', tbl_2_chart(), sv);
            });
        });
        var colorPalette = [
            '#4e73df', // آبی
            '#e74a3b', // قرمز
            '#1cc88a', // سبز
            '#f6c23e', // زرد
            '#6f42c1', // بنفش
            '#fd7e14', // نارنجی
            '#20c997', // فیروزه‌ای
            '#d63384', // صورتی
        ];
        function drawChart(canvas_, data, chart_type) {
            let $canvas = $('#' + canvas_);
            if (!$canvas.length || !data || !data.length) return;

            // لیبل‌ها از اولین dataset
            var labels = Object.keys(data[0].data);

            // تحلیل ورودی: می‌تواند "bar,line" یا یک نوع باشد
            var types = chart_type ? chart_type.split(',').map(t => t.trim()) : ['bar'];
            var combined = types.includes('bar') && types.includes('line');

            var datasets = [];

            $.each(data, function (i, item) {
                var values = [];
                $.each(labels, function (_, key) {
                    values.push(item.data[key]);
                });

                // انتخاب رنگ از پالت
                var color = colorPalette[i % colorPalette.length];

                // نوع نمودار برای هر dataset
                var type = combined
                    ? types[i % types.length]  // اگر ترکیبی بود، می‌چرخیم بین line/bar
                    : types[0];               // یک نوع فقط

                datasets.push({
                    label: item.dataset,
                    data: values,
                    type: type,
                    backgroundColor: type === 'bar' ? color + '88' : 'transparent',
                    borderColor: color,
                    borderWidth: 2,
                    tension: 0.4,
                    fill: type == 'bar' ? true : false,
                    hoverBackgroundColor: type === 'bar' ? shadeColor(color, -15) + 'AA' : undefined,
                    hoverBorderColor: shadeColor(color, -20)
                });
            });

            // destroy قبلی
            if ($canvas.data('chart')) {
                $canvas.data('chart').destroy();
            }

            var chart = new Chart($canvas[0], {
                data: {
                    labels: labels,
                    datasets: datasets
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    interaction: {
                        mode: 'index',
                        intersect: false
                    },
                    plugins: {
                        legend: {
                            position: 'top', rtl: true, labels: { font: { family: 'Arial', size: 14 } },
                        },
                        tooltip: { enabled: true, mode: 'index', intersect: false, rtl: true, textDirection: 'rtl', }
                    }, animations: {
                        tension: {
                            duration: 1000,
                            easing: 'linear',
                            from: 1,
                            to: 0,
                            loop: false,
                        },
                    },
                    scales: types.includes('pie') || types.includes('doughnut')
                        ? {}
                        : {
                            y: {
                                position: 'right',
                                beginAtZero: true,
                                grid: { color: '#eee' }
                            },
                            x: { grid: { display: false }, reverse: true, }
                        }
                }
            });
            $canvas.data('chart', chart);
        }
        function shadeColor(color, percent) {
            var f = parseInt(color.slice(1), 16), t = percent < 0 ? 0 : 255, p = percent < 0 ? percent * -1 : percent;
            var R = f >> 16, G = f >> 8 & 0x00FF, B = f & 0x0000FF;
            return "#" + (0x1000000 + (Math.round((t - R) * p / 100) + R) * 0x10000 + (Math.round((t - G) * p / 100) + G) * 0x100 + (Math.round((t - B) * p / 100) + B)).toString(16).slice(1);
        }
        function drawTable(tbl_name, json) {

            if (!json || !json.length) return;

            var $table = $('#' + tbl_name);
            var $thead = $table.find('thead').empty();
            var $tbody = $table.find('tbody').empty();

            // ساخت هدر جدول
            var headerRow = '<tr><th>عنوان</th><th><input type="checkbox" class="form-control" id="chk_all" checked /></th>';

            $.each(json[0].data, function (key) {
                headerRow += '<th>' + key + '</th>';
            });

            headerRow += '</tr>';
            $thead.append(headerRow);

            // ساخت ردیف‌ها
            $.each(json, function (_, item) {

                var row = '<tr>';
                row += '<td>' + item.dataset + '</td><td class="center"><input type="checkbox" class="form-control" checked /></td>';

                $.each(item.data, function (_, value) {
                    row += '<td class="center">' + value + '</td>';
                });

                row += '</tr>';
                $tbody.append(row);
            });
        }
        function tbl_2_chart() {
            var result = [];
            $('#tbl_data tbody tr').each(function () {
                var $row = $(this);
                var $checkbox = $row.find('input[type="checkbox"]');
                // فقط اگر تیک خورده باشد
                if ($checkbox.prop('checked')) {
                    var rowData = {};
                    var dataObj = {};
                    // ستون اول = dataset / Title
                    rowData.dataset = $row.find('td').eq(0).text().trim();
                    // بقیه ستون‌ها (از ستون 2 به بعد) = data
                    $row.find('td').slice(2).each(function (index) {
                        var key = $('#tbl_data thead th').eq(index + 2).text().trim(); // نام ماه از header
                        var value = $(this).text().trim();
                        dataObj[key] = isNaN(value) ? value : parseFloat(value); // اگر عدد است تبدیل به number
                    });
                    rowData.data = dataObj;
                    result.push(rowData);
                }
            });
            return result;
        }
        function download_chart() {
            html2canvas(document.querySelector("#reportChart")).then(canvas => {
                var imgData = canvas.toDataURL('image/png');
                // دانلود مستقیم
                var a = document.createElement('a');
                a.href = imgData;
                a.download = 'Sanaco_Chart.png';
                a.click();
            });
        }
    </script>
</head>
<body>
    <div class="container-fluid w-full">
        <div class="row auto-height" style="max-height: 40vh">
            <div class="col-xs-12">
                <table class="table table-bordered table-responsive" id="tbl_data">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-2 col-xs-push-3">
                <p>نوع نمودار : </p>
            </div>
            <div class="col-xs-3 col-xs-push-3">
                <select id="slc_type" class="selectpicker" data-width="100%" data-size="4" multiple="multiple" multiple>
                    <option value="bar" selected="selected">نمودار میله ای</option>
                    <option value="line">نمودار خطی</option>
                    <option value="pie" data-exclusive="true">نمودار دایره ای</option>
                    <option value="doughnut" data-exclusive="true">نمودار حلقه ای</option>
                </select>
            </div>
            <div class="col-xs-1 col-xs-push-3 left"><span onclick="download_chart()" class="btn glyphicon glyphicon-cloud-download"></span></div>
        </div>
        <div class="row auto-height">
            <div class="col-xs-12" style="height: 50vh;">
                <canvas id="reportChart"></canvas>
            </div>
        </div>
    </div>
</body>
</html>
