﻿<%@ Page Title="" Language="C#" AutoEventWireup="true"
    CodeBehind="page_cardex_leave.aspx.cs" Inherits="TimeWork.page_cardex_leave" EnableSessionState="True" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>

        $(document).ready(function () {
            initial_tab();
            initial_cb_personel("#cb_personel", parent.uid);
            $("#cb_personel").on('changed.bs.select',
                function (e, clickedIndex, newValue, oldValue) {
                    refresh();
                });
            reqsvr2("load", "", function (data) {
                var y = parseInt(data.d[1]);
                for (var i = y; i >= 1390; i--) {
                    var option = document.createElement("option");
                    option.value = i;
                    option.text = i;
                    document.getElementById("cb_year").add(option);
                }
                $("#cb_year").val(y);
                refresh();
            });
        });

        function year_change() {
            refresh();
        }
        function refresh() {
            wait_();
            $("#btn_print").addClass("hide");
            reqsvr("search", "prow:" + $("#cb_personel").val() + ",year:" + $("#cb_year").val()
                , function (data) {
                    if (data.d[0] == "error") {
                        alert(data.d[1]);
                        return;
                    }
                    load_tbl(data.d[0], "cardex");

                    load_element(data.d[1]);
                    $("#day_time").html(data.d[2]);
                    if (check_access("011001")) {
                        load_tbl(data.d[3], "incdec");
                        if (data.d[4] == "1")
                            $(".incdec-spare").removeClass("hide");
                        else
                            $(".incdec-spare").addClass("hide");
                        $("#li_incdec").removeClass("hide");
                    }
                    $("#btn_print").removeClass("hide");
                });
        }
        function print_click() {
            if ($("#li_cardex").hasClass("active"))
                ToPrint('#div_cardex_print');    // print_div('div_cardex_', 'گزارش کاردکس سالانه <br />' + $('#cb_personel option:selected').text(), '');
            else
                ToPrint('#div_incdec');
        }

    </script>
</head>
<body>
    <div class="bg-menu pad3  row">
        <div class="col-sm-6  " style="max-width: 388px;">
            <div style="display: inline; width: calc(100% - 110px);">
                <label for="cb_personel" class="w-60">پرسنل :</label>
                <select id="cb_personel" class="selectpicker  " data-width="300px" data-size="10" data-actions-box="true" data-live-search="true">
                </select>
            </div>
        </div>
        <div class="col-sm-3 w-200">
            <label for="cb_year" class="w-60">دوره :</label>
            <select id="cb_year" class="form-control w-100 btn" onchange="year_change()">
            </select>
        </div>
        <button type="button" class="btn glyphicon glyphicon-refresh   hide-xs" onclick="refresh()"></button>
        <button id="btn_print" type="button" title="چاپ گزارش" class="btn glyphicon glyphicon-print hide-xs hide" onclick="print_click()"></button>
    </div>
    <div class="panel">

        <div class="w-full">
            <ul id="tab_item" class="nav nav-tabs">
                <li id="li_cardex" class="active"><a data-toggle="tab" href="#div_cardex_">کاردکس ماهانه</a></li>
                <li id="li_incdec" class="hide"><a data-toggle="tab" href="#div_incdec_">افزایش/کاهش استحقاقی</a></li>
            </ul>
            <div id="div_item" class="tab-content " style="overflow: scroll">
                <div id="div_cardex_" class="tab-pane fade in active">
                    <div id="div_cardex_print" class="auto-height pad5">
                        <div id="div_cardex" style="border: thin solid #C0C0C0; width: 800px;">
                        </div>

                        <div>
                            وضعیت دوره 
                            <label id="day_time" class="pad5"></label>
                        </div>
                        <table class="dgv table-striped table-bordered" style="width: 800px;">
                            <thead>
                                <tr>
                                    <th style="width: 120px"></th>
                                    <th style="width: 120px">مانده سال قبل</th>
                                    <th style="width: 120px">مجموع استحقاقی امسال</th>
                                    <th style="width: 120px">استفاده شده امسال</th>
                                    <th style="width: 120px" class="incdec-spare hide">بخشیده شده</th>
                                    <th style="width: 120px">مانده امسال</th>
                                    <th style="width: 120px">مانده نهایی</th>
                                    <th style="width: 120px">سقف قابل انتقال</th>
                                    <th style="width: 120px">قابل انتقال</th>
                                    <th style="width: 120px">سوخته</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td class="bg-info text-center">ساعت</td>
                                    <td class="text-center" id="last_year"></td>
                                    <td class="text-center" id="incdec_inc_year"></td>
                                    <td class="text-center" id="incdec_dec_year"></td>
                                    <td class="text-center incdec-spare hide" id="incdec_spare"></td>
                                    <td class="text-center" id="incdec_mande"></td>
                                    <td class="text-center" style="font-weight: 900" id="incdec_mande_sum"></td>
                                    <td class="text-center" id="save_leave_year"></td>
                                    <td class="text-center" id="incdec_next_year"></td>
                                    <td class="text-center" id="incdec_del"></td>
                                </tr>
                                <tr>
                                    <td class="bg-info text-center">روز</td>
                                    <td class="text-center" id="last_year_day"></td>
                                    <td class="text-center" id="incdec_inc_year_day"></td>
                                    <td class="text-center" id="incdec_dec_year_day"></td>
                                    <td class="text-center incdec-spare hide" id="incdec_spare_day"></td>
                                    <td class="text-center" id="incdec_mande_day"></td>
                                    <td class="text-center" style="font-weight: 900" id="incdec_mande_sum_day"></td>
                                    <td class="text-center" id="save_leave_year_day"></td>
                                    <td class="text-center" id="incdec_next_year_day"></td>
                                    <td class="text-center" id="incdec_del_day"></td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
                <div id="div_incdec_" class="tab-pane fade rel no-scroll">
                    <div id="div_incdec" class="auto-height "></div>
                </div>
            </div>
        </div>





    </div>
</body>
</html>
