﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="set_alarm.aspx.cs" Inherits="TimeWork.set_alarm" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <style>
        .no-rlpadding {
            padding-right: 0px !important;
            padding-left: 0px !important;
        }

        .rl12-padding {
            padding-right: 12px !important;
            padding-left: 12px !important;
        }

        ::-webkit-scrollbar {
            display: none;
        }

        .clockpicker-popover {
            z-index: 999999 !important;
        }

        .select2-drop {
            z-index: 999999 !important;
        }

        .br8 {
            border-radius: 8px;
        }

        .h32 {
            height: 32px !important;
        }

        .h60 {
            height: 60px !important;
        }

        .f22 {
            font-size: 22px !important;
        }

        .mh50 {
            min-height: 50px !important;
        }

        .mh40 {
            min-height: 40px !important;
        }

        .h100 {
            height: 100px !important;
        }

        .h300 {
            height: 350px !important;
        }

        .w-full {
            width: 100% !important;
        }

        .v-center {
            display: flex !important;
            align-items: center;
            justify-content: center;
        }

        .sv-center {
            display: flex !important;
            align-items: center;
            justify-content: space-between;
        }

        .btn_add {
            height: 30px !important;
            max-width: 45px !important;
        }

        .bg-darkgray {
            background-color: #b6b6b6 !important;
        }

        .dropdown-toggle {
            height: 32px !important;
        }

        .calendar-table td {
            text-align: center;
            vertical-align: middle;
            height: 80px !important;
        }

        .calendar-table th {
            text-align: center;
            vertical-align: middle;
            height: 60px !important;
            table-layout: fixed !important;
            width: 14.28571428571429% !important;
        }

        .active-td {
            background-color: #fbfbfb;
            transition: background-color 0.3s ease-in-out;
        }

            .active-td:hover {
                background-color: darkslategrey;
            }

        .panel-info > .panel-heading {
            background-color: #f8f8f8 !important;
            border: none !important;
        }

        .panel-group {
            margin: 0px !important;
        }

        .custom-card, .inner-card {
            border-radius: 10px;
            overflow: hidden;
            margin-bottom: 10px;
            transition: all 0.3s ease-in-out;
        }

            .custom-card .panel-heading, .inner-card .panel-heading {
                background-color: #f8f8f8;
                cursor: pointer;
                position: relative;
                transition: background-color 0.3s ease-in-out;
            }

                .custom-card .panel-heading:hover, .inner-card .panel-heading:hover {
                    background-color: #e6f0ff;
                }

        .p-title {
            margin: 0;
            font-size: 16px;
            line-height: 1.8;
        }

        .inner-body {
            font-size: 14px;
            line-height: 1.7;
            background: #fff;
            border-top: 1px solid #ddd;
            padding: 10px 15px;
            color: #333;
        }

        .toggle-icon {
            transition: transform 0.3s ease-in-out;
            margin-right: 5px;
        }

        .panel-heading.collapsed .toggle-icon {
            transform: rotate(-90deg);
        }

        .panel-body.p-0 {
            padding: 0;
        }

        .panel-info {
            border: none !important;
        }

        @media (min-width: 768px) {
            .sm-btn {
                height: 40px !important;
                font-size: 20px !important;
            }

            .form-control {
                font-size: 20px !important;
            }

            .btn {
                font-size: 17px !important;
            }
        }
    </style>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="../../style/clock/bootstrap-clockpicker.min.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/mask/jquery.mask.min.js"></script>
    <script src="../../style/alert/sweetalert.js"></script>
    <script src="../../style/alert/sweetalert2@11.js"></script>
    <script src="../../style/clock/bootstrap-clockpicker.min.js" type="text/javascript"></script>
    <script src="../../style/select/bootstrap-select.js" type="text/javascript"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../script/fncDate.js" type="text/javascript"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script>
    <script>
        $(document).ready(function () {
            initial_page(2000, 1000);
            reqsvr("get_date", '', function (data) {
                full_date = data.d;
                year = parseInt(data.d.split('/')[0]);
                month = parseInt(data.d.split('/')[1]);
                day = parseInt(data.d.split('/')[2]);
                $('#cb_month').val(month);
                for (let i = year - 5; i <= year + 5; i++)
                    $('#cb_year').append($('<option>', { value: i, text: i }));
                $('#cb_year').val(year);
                c_date();
            });
        });
        $(document).on('mouseenter', 'td > div', function () {
            $(this).find('.btn_add').fadeIn(150); // با افکت ظاهر بشه
        });

        $(document).on('mouseleave', 'td > div', function () {
            $(this).find('.btn_add').fadeOut(100); // با افکت محو بشه
        });
        $(document).on('show.bs.collapse', '.panel-collapse', function (e) {
            e.stopPropagation();
            $(this).prev('.panel-heading').find('.toggle-icon').css('transform', 'rotate(0deg)');
        });

        $(document).on('hide.bs.collapse', '.panel-collapse', function (e) {
            e.stopPropagation();
            $(this).prev('.panel-heading').find('.toggle-icon').css('transform', 'rotate(-90deg)');
        });
        let full_date, year, month, day;
        const html_ = '<div class="h300"><p>عنوان یادآور : </p><input id="txt_title" type="text" class="form-control h32" placeholder="موضوع را وارد کنید" /><p>متن یادآور : </p><textarea id="txt_message" class="form-control no-resize h100" placeholder="متن یادآور را وارد کنید"></textarea> \
            <p>نوع پیغام دهی : </p><select class="form-contorl w-full selectpicker" id="slc_type" multiple="multiple"></select><p>زمان یادآور : </p>\
            <div class="input-group clockpicker" data-autoclose="true"><input type="text" id="txt_time" class="form-control h32" placeholder="زمان یادآور را انتخاب کنید" /><span class="input-group-addon"><span class="glyphicon glyphicon-time"></span></span></div></div>';
        function show_html_alert(title_, html_, fnc_open, fnc_pre, fnc) {
            (async () => {
                const { value: formValues } = await Swal.fire({
                    title: title_,
                    html: html_,
                    allowEscapeKey: false,
                    allowOutsideClick: false,
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'تائید',
                    cancelButtonText: 'انصراف',
                    position: "top",
                    focusConfirm: false,
                    didOpen: () => {
                        fnc_open();
                    },
                    preConfirm: fnc_pre
                });
                if (formValues)
                    fnc(formValues);
            })()
        }
        function c_month(sign) {
            if (sign == '+')
                if ($('#cb_month').val() == '12') {
                    $('#cb_month').val('1');
                    $('#cb_year').val(parseInt($('#cb_year').val()) + 1);
                } else
                    $('#cb_month').val(parseInt($('#cb_month').val()) + 1);
            else
                if ($('#cb_month').val() == '1') {
                    $('#cb_month').val('12');
                    $('#cb_year').val(parseInt($('#cb_year').val()) - 1);
                } else
                    $('#cb_month').val(parseInt($('#cb_month').val()) - 1);
            c_date();
        }
        function c_date() {
            if (window.innerWidth > 768)
                render_desktop();
            else
                render_mobile();
        }
        function month_now() {
            $("#cb_year").val(year);
            $("#cb_month").val(month);
            c_date();
        }
        function load_type() {
            reqsvr("load_type", "", function (data) {
                $.each(JSON.parse(data.d), function (index, item) {
                    $("#slc_type").append("<option value='" + item.code + "'>" + item.name + "</option>")
                });
                $('#slc_type').selectpicker();
            });
        }
        function render_mobile() {
            let c_month = $('#cb_month').val();
            if ($('#cb_month').val() < 10)
                c_month = '0' + $('#cb_month').val();
            reqsvr("render_mobile", "year:'" + $('#cb_year').val() + "',month:'" + c_month + "'", function (data) {
                $("#div_data").html(data.d);
                scroll_today();
            });
        }
        function render_desktop() {
            $("#spn_all").addClass("disabled").removeAttr("onclick");
            let c_month = $('#cb_month').val();
            if ($('#cb_month').val() < 10)
                c_month = '0' + $('#cb_month').val();
            reqsvr("render_desktop", "year:'" + $('#cb_year').val() + "',month:'" + c_month + "'", function (data) {
                $("#div_data").html(data.d);
            });
        }
        function only_reminders(btn) {
            var $btn = $(btn);
            var isReminders = $btn.text().indexOf('یادآور') !== -1;

            if (isReminders) {
                // تغییر به حالت همه موارد
                $btn.html('همه موارد &#128221;');
                $('#div_data > .row').show();
            } else {
                // برگشت به حالت یادآورها
                $btn.html('یادآور ها &#128226;');

                // فقط اونایی که row دومشون (bg-green-light) محتوای واقعی دارن بمونن
                $('#div_data > .row').each(function () {
                    var $rows = $(this).find('.row');
                    var $reminders = $rows.eq(1); // دومین div.row
                    var hasContent = $reminders.hasClass('bg-green-light') && $.trim($reminders.text()).length > 0;

                    if (hasContent)
                        $(this).show();
                    else
                        $(this).hide();
                });
            }
            scroll_today();
        }
        function scroll_today(delay = 500) {
            var $container = $('#div_data');
            var $target = $container.find('.bg-darkgray').first();
            $container.stop().animate({ scrollTop: 0 }, 0);
            if ($target.length) {
                setTimeout(function () {
                    var targetPos = $target.position().top;
                    var offset = 80;
                    $container.stop().animate(
                        {
                            scrollTop: $container.scrollTop() + targetPos - offset
                        },
                        {
                            duration: 1500,
                            easing: 'swing',
                            queue: false
                        }
                    );
                }, delay);
            }
        }
        function fnc_alarm_d(o, e) {
            e.stopPropagation();

            if ($(o).hasClass('btn-info'))
                show_html_alert($(o).closest('td').attr('code'), html_, function () {
                    $('.clockpicker').clockpicker();
                    load_type();
                }, function () {
                    if ($.trim($("#txt_title").val()).length == 0 || $.trim($("#txt_message").val()).length == 0 || $("#slc_type").val().length == 0 || $.trim($("#txt_time").val()).length == 0) {
                        Swal.showValidationMessage("موارد لازم را وارد کنید");
                        return false;
                    }
                }, function () {
                    reqsvr("submit_reminder", "title:'" + $.trim($("#txt_title").val()) + "',message:'" + $.trim($("#txt_message").val()) + "',type:'" + $("#slc_type").val() + "',date:'" + $(o).closest('td').attr('code') + "',time:'" + $.trim($("#txt_time").val()) + "'", function (data) {
                        if (data.d[0] == "ok") {
                            let c_month = $('#cb_month').val();
                            if ($('#cb_month').val() < 10)
                                c_month = '0' + $('#cb_month').val();
                            reqsvr("reload_rem", "year:'" + $('#cb_year').val() + "',month:'" + c_month + "'", function (data) {
                                $("#accordion").html(data.d);
                                if ($.trim($(o).parent().parent().children().eq(1).text()).length == 0)
                                    $(o).parent().parent().children().eq(1).html('<span class="f20 text-success">1 یادآور</span>')
                                else {
                                    const num = parseInt($(o).parent().parent().children().eq(1).text().split(' ')[0]) + 1
                                    $(o).parent().parent().children().eq(1).html('<span class="f20 text-success">' + num + ' یادآور</span>');
                                }
                            });

                            alert_success("یادآور با موفقیت ذخیره شد");
                        }
                    });
                });
            else
                show_html_alert($(o).closest('div.custom-card').children().eq(0).children('span').eq(0).text(), html_, function () {
                    $('.clockpicker').clockpicker();
                    load_type();
                    reqsvr("load_reminder", "code:'" + $(o).closest('div').parent().attr('code') + "'", function (data) {
                        $("#txt_title").val(data.d[0]);
                        $("#txt_message").val(data.d[1]);
                        $("#txt_time").val(data.d[2]);
                        $("#slc_type").selectpicker('val', data.d[3].split(','));
                    })
                }, function () {
                    if ($.trim($("#txt_title").val()).length == 0 || $.trim($("#txt_message").val()).length == 0 || $("#slc_type").val().length == 0 || $.trim($("#txt_time").val()).length == 0) {
                        Swal.showValidationMessage("موارد لازم را وارد کنید");
                        return false;
                    }
                }, function () {
                    reqsvr("update_reminder", "code:'" + $(o).closest('div').parent().attr('code') + "',title:'" + $.trim($("#txt_title").val()) + "',message:'" + $.trim($("#txt_message").val()) + "',type:'" + $("#slc_type").val() + "',time:'" + $.trim($("#txt_time").val()) + "'", function (data) {
                        if (data.d == "ok") {
                            $(o).closest('div').children('span').eq(0).text(" - " + $.trim($("#txt_title").val()));
                            $(o).closest('div').children('span').eq(1).text($.trim($("#txt_time").val()));
                            $(o).closest('div.inner-card').find('div.inner-body:first').text($.trim($("#txt_message").val()));
                            alert_success("یادآور با موفقیت تغییر یافت");
                        }
                    });
                });
        }
        function fnc_alarm_m(o) {
            if ($(o).hasClass('btn-info'))
                show_html_alert($(o).closest('div.mh50').children('div').eq(1).text(), html_, function () {
                    $('.clockpicker').clockpicker();
                    load_type();
                }, function () {
                    if ($.trim($("#txt_title").val()).length == 0 || $.trim($("#txt_message").val()).length == 0 || $("#slc_type").val().length == 0 || $.trim($("#txt_time").val()).length == 0) {
                        Swal.showValidationMessage("موارد لازم را وارد کنید");
                        return false;
                    }
                }, function () {
                    reqsvr("submit_reminder", "title:'" + $.trim($("#txt_title").val()) + "',message:'" + $.trim($("#txt_message").val()) + "',type:'" + $("#slc_type").val() + "',date:'" + $(o).closest('div.mh50').children('div').eq(1).text() + "',time:'" + $.trim($("#txt_time").val()) + "'", function (data) {
                        if (data.d[0] == "ok") {
                            $(o).closest('div.row').parent().children().eq(1).append('<div code="' + data.d[1] + '" class="v-center" ><span class=\"col-xs-5 f17 text-right\"> - ' + $.trim($("#txt_title").val()) + '</span><span class=\"col-xs-5 f17\">' + $.trim($("#txt_time").val()) + '</span><span class=\"btn btn-warning\" onclick=\"fnc_alarm(this)\"><i class=\"fa fa-pencil\" aria-hidden=\"true\"></i></span><span class=\"btn btn-danger\" onclick=\"reminder_delete(this,event)\"><i class=\"fa fa-trash-o\" aria-hidden=\"true\"></i></span></div>');
                            alert_success("یادآور با موفقیت ذخیره شد");
                        }
                    });
                });
            else
                show_html_alert($(o).closest('div.row').parent().children().eq(0).children('div').eq(1).text(), html_, function () {
                    $('.clockpicker').clockpicker();
                    load_type();
                    reqsvr("load_reminder", "code:'" + $(o).closest('div').attr('code') + "'", function (data) {
                        $("#txt_title").val(data.d[0]);
                        $("#txt_message").val(data.d[1]);
                        $("#txt_time").val(data.d[2]);
                        $("#slc_type").selectpicker('val', data.d[3].split(','));
                    })
                }, function () {
                    if ($.trim($("#txt_title").val()).length == 0 || $.trim($("#txt_message").val()).length == 0 || $("#slc_type").val().length == 0 || $.trim($("#txt_time").val()).length == 0) {
                        Swal.showValidationMessage("موارد لازم را وارد کنید");
                        return false;
                    }
                }, function () {
                    reqsvr("update_reminder", "code:'" + $(o).closest('div').attr('code') + "',title:'" + $.trim($("#txt_title").val()) + "',message:'" + $.trim($("#txt_message").val()) + "',type:'" + $("#slc_type").val() + "',time:'" + $.trim($("#txt_time").val()) + "'", function (data) {
                        if (data.d == "ok") {
                            $(o).parent().children('span').eq(0).text(" - " + $.trim($("#txt_title").val()));
                            $(o).parent().children('span').eq(1).text($.trim($("#txt_time").val()));
                            alert_success("یادآور با موفقیت تغییر یافت");
                        }
                    });
                });
        }
        function select_date(el) {
        }
        function reminder_delete(el, e) {
            e.stopPropagation();
            let code = "";
            if (window.innerWidth > 768)
                code = $(el).closest('div').parent().attr('code')
            else
                code = $(el).closest('div').attr('code')
            confirm_alert(function () {
                reqsvr("delete_reminder", "code:'" + code + "'", function (data) {
                    if (data.d == "ok") {
                        if (window.innerWidth > 768)
                            if ($(el).closest('div.panel-group').children().length == 1) {
                                $(el).closest('div.custom-card').remove();
                                $("table").find("td[code='" + $(el).closest('div.custom-card').children().eq(0).children().eq(0).text() + "']").children().eq(0).children().eq(1).html('');
                            }
                            else {
                                const num = parseInt($("table").find("td[code='" + $(el).closest('div.custom-card').children().eq(0).children().eq(0).text() + "']").children().eq(0).children().eq(1).text().split(' ')[0]) - 1;
                                $("table").find("td[code='" + $(el).closest('div.custom-card').children().eq(0).children().eq(0).text() + "']").children().eq(0).children().eq(1).html('<span class="f20 text-success">' + num + ' یادآور</span>');
                                $(el).closest('div.inner-card').remove();
                            }
                        else
                            $(el).closest('div').remove();
                        alert_success("حذف یادآور با موفقیت انجام شد");
                    }
                })
            }, function () { });
        }
    </script>
</head>
<body>
    <form>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xs-3 col-sm-2 col-sm-offset-2"><span class="sm-btn btn btn-block btn-primary v-center" onclick="c_month('+')">ماه بعد &#9193;</span></div>
                <div class="col-xs-3 col-sm-2 no-rlpadding">
                    <select id="cb_month" class="sm-btn form-control center" onchange="c_date()">
                        <option value="1">فروردین</option>
                        <option value="2">اردیبهشت</option>
                        <option value="3">خرداد</option>
                        <option value="4">تیر</option>
                        <option value="5">مرداد</option>
                        <option value="6">شهریور</option>
                        <option value="7">مهر</option>
                        <option value="8">آبان</option>
                        <option value="9">آذر</option>
                        <option value="10">دی</option>
                        <option value="11">بهمن</option>
                        <option value="12">اسفند</option>
                    </select>
                </div>
                <div class="col-xs-3 col-sm-2 no-rlpadding">
                    <select id="cb_year" class="sm-btn form-control center" onchange="c_date()">
                    </select>
                </div>
                <div class="col-xs-3 col-sm-2"><span class="sm-btn btn btn-block btn-primary v-center" onclick="c_month('-')">ماه قبل &#9194;</span></div>
            </div>
            <div class="row">
                <div class="col-xs-4 col-xs-offset-2 col-sm-2 col-sm-offset-4" id="div_">
                    <span class="sm-btn btn btn-block btn-success v-center" id="spn_all" onclick="only_reminders(this)">همه موارد &#128226;</span>
                </div>
                <div class="col-xs-4 col-sm-2"><span class="sm-btn btn btn-block btn-info v-center" onclick="month_now()">روز جاری &#128197;</span></div>
            </div>
        </div>
        <div class="row">
            <div id="div_data" class="auto-height"></div>
            <%--            <div class="auto-height col-sm-4" id="">
                <div class="panel-group" id="accordion">--%>
            <!-- کارت اصلی -->
            <%--                    <div class="panel panel-default custom-card">
                        <div class="panel-heading h60 sv-center bg-gray" data-toggle="collapse" data-parent="#accordion" href="#collapseDate">
                            <span class="p-title f25">1404/08/21</span>
                            <i class="fa fa-chevron-down toggle-icon pull-left f20"></i>
                        </div>
                        <div id="collapseDate" class="panel-collapse collapse in">
                            <div class="panel-body p-0">
                                <div class="panel-group" id="subAccordion">
                                    <!-- کارت داخلی -->
                                    <div class="panel panel-info inner-card">
                                        <div class="panel-heading" data-toggle="collapse" data-parent="#subAccordion" href="#collapseInner2">
                                            <div class="p-title mh40 f20 v-center" code="1">
                                                <span class="col-sm-6">- موضوع 1</span>
                                                <span class="col-sm-4">14:12</span>
                                                <div class="col-sm-1">
                                                    <i class="fa fa-chevron-down toggle-icon"></i>
                                                    <div class="clearfix"></div>
                                                </div>
                                                <span class="col-sm-1 btn btn-warning" onclick="fnc_alarm_d(this,event)"><i class="fa fa-pencil f20" aria-hidden="true"></i></span>
                                            </div>
                                        </div>
                                        <div id="collapseInner2" class="panel-collapse collapse in">
                                            <div class="panel-body inner-body">
                                                شسیشسشیسیتشیسشنیتشهیتخشت
                                <br>
                                                یخنشسیخنششیخنشیخنی
                                            </div>
                                        </div>
                                    </div>
                                    <!-- پایان کارت داخلی -->
                                </div>
                            </div>
                        </div>
                    </div>
                        </div>
            </div>
                        <div class="col-sm-8" id="div_data"></div>--%>
        </div>

    </form>
</body>
</html>
