﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="page_set_alarm.aspx.cs" Inherits="TimeWork.page.page_set_alarm" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <style>
        .calendar-desktop.calendar-mobile {
            display: none;
        }

        @media only screen and (min-width: 750px) {
            .calendar-desktop {
                display: block;
            }

            .form_head {
                height: 10vh;
            }

            .form_container {
                height: 95vh;
            }


            h3 {
                font-size: 2rem !important;
            }

            h4 {
                font-size: 2rem !important;
            }

            h6 {
                font-size: 1.25rem !important;
            }

            .btn_vw {
                width: 5rem !important;
                height: 5rem !important;
            }

            .input_vw {
                height: 5rem !important;
                width: 10rem !important;
                font-size: 1.5rem !important;
            }
        }

        @media only screen and (max-width: 749px) {
            .form_head {
                height: 5vh;
            }

            .form_container {
                height: 95vh;
            }

            .calendar-mobile {
                display: block;
            }

            h3 {
                font-size: 1.25rem !important;
            }

            h4 {
                font-size: 1.25rem !important;
            }

            h5 {
                font-size: 1.5rem !important;
            }

            .btn_vw {
                width: 2.3rem !important;
                height: 2.3rem !important;
            }

            .input_vw {
                height: 2.3rem !important;
                width: 5rem !important;
                font-size: .8rem !important;
            }

            .label_vw {
                font-size: 1.25rem !important;
            }
        }

        .calendar-table th, .calendar-table td {
            text-align: center;
            vertical-align: middle;
            height: 60px;
        }

        .example::-webkit-scrollbar {
            display: none;
        }

        .switch {
            position: relative;
            display: inline-block;
        }

            .switch input {
                opacity: 0;
                width: 0;
                height: 0;
            }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

            .slider:before {
                position: absolute;
                content: "";
                height: 1rem;
                width: 1rem;
                left: .3rem;
                bottom: .25rem;
                background-color: white;
                -webkit-transition: .4s;
                transition: .4s;
            }

        input:checked + .slider {
            background-color: #2196F3;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(2rem);
            -ms-transform: translateX(2rem);
            transform: translateX(2rem);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

            .slider.round:before {
                border-radius: 50%;
            }
    </style>
    <link href="../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/spinner/jquery-spinner.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />
     
    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/bootstrap/bootstrap.min.js" type="text/javascript"></script>
    <script src="../../style/datatable/dataTables.min.js"></script>
    <script src="../../style/datatable/dataTables.bootstrap.min.js"></script>
    <script src="../../style/mask/jquery.mask.min.js"></script>
    <script src="../../style/select/bootstrap-select.js"></script>
    <script src="../../style/spinner/jquery-spinner.js" type="text/javascript"></script>
    <script src="../../style/calendar/js-persian-cal.min.js" type="text/javascript"></script>
    <script src="../../script/fncDate.js" type="text/javascript"></script>
    <script src="../../style/alert/sweetalert.js"></script>
    <script src="../../script/fnc.js" type="text/javascript"></script> 
    <script>
        var f_date;
        var f_message;
        var times = 0;
        var resizeTimer = false;
        var f_data;
        var f_size;
        let triggered = false;
        $(document).ready(function () {
            initial_page(700, 600);
            initial_stepper();
            setTimeout(function () {
                f_size = window.innerWidth;
            }, 150);
            reqsvr("get_date", "", function (data) {
                f_date = data.d;
                $('[data-toggle="tooltip"]').tooltip();
                $("#cb_year").val(data.d.substr(0, 4));
                $("#cb_month").val(data.d.substr(5, 2));
                set_cal_req($("#cb_year").val(), $("#cb_month").val());
                scroll_today();
            });
            setTimeout(function () {
                $('#div_mob').on('scroll', function () {

                    let el = this;
                    let scrollTop = el.scrollTop;
                    let scrollHeight = el.scrollHeight;
                    let clientHeight = el.clientHeight;
                    if (!triggered && scrollTop + clientHeight >= scrollHeight - 10) {
                        triggered = true;
                        scroll_page();
                    }
                    console("scrollTop:" + scrollTop);
                });
            }, 250);

            $(window).on('resize', function (e) {
                resizeTimer = setTimeout(function () {
                    resizeTimer = false;
                    $(window).trigger('resizeend');
                }, 350);
            }).on('resizeend', function () {
                set_cal();
            });
        });
        function show_input_alert(title_, value_, fnc, fnc_deny) {
            Swal.fire({
                title: title_,
                input: 'text',
                position: "top",
                inputValue: value_,
                inputPlaceholder: 'عنوان',
                inputAttributes: {
                    autocapitalize: 'off'
                },
                showCancelButton: true,
                showDenyButton: true,
                returnInputValueOnDeny: true,
                confirmButtonText: 'ذخیره',
                denyButtonText: 'حذف',
                cancelButtonText: 'انصراف',
                showLoaderOnConfirm: true,
                preDeny: () => {
                },
                preConfirm: (txt) => {
                    if (txt === '') {
                        swal.showValidationMessage('لطفا عنوان را وارد نمائید');
                    }
                },
                allowOutsideClick: false,
            }).then((result) => {
                if (result.isConfirmed) {
                    fnc(result.value);
                } else if (result.isDenied) {
                    fnc_deny(result.value);
                }
            })
        }
        function confirm_alert_msg(title, msg, btn_txt, fnc_ok) {
            Swal.fire({
                title: title,
                text: msg,
                position: "top",
                showLoaderOnConfirm: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: btn_txt,
                allowOutsideClick: false
            }).then((result) => {
                if (result.value) {
                    fnc_ok();
                }
            });
        }
        function show_html_alert(title_, html_, fnc, fnc_pre, fnc_open) {
            (async () => {
                const { value: formValues } = await Swal.fire({
                    title: title_,
                    html: html_,
                    position: "top",
                    focusConfirm: false,
                    didOpen: () => {
                        fnc_open();
                    },
                    preConfirm: fnc_pre
                });
                if (formValues)
                    fnc(formValues);
            })()
        }
        function scroll_page() {
            var m = parseInt($("[name=month]").val());
            var bbm;
            if (m == 12) {
                $("[name=month]").val("01");
                var y = parseInt($("[name=year]").val());
                $("[name=year]").val((y + 1).toString());
            }
            else {
                m++;
                if (m < 10)
                    m = '0' + m;
                $("[name=month]").val(m.toString());
            }
            if ($('#div_mob').find('h5:last').attr("id") == undefined)
                bbm = "msg_0101";
            else
                bbm = $('#div_mob').find('h5:last').attr("id");
            reqsvr("load_calendar_scroll", "year:" + $("#cb_year").val() + ", month:" + $("#cb_month").val() + ",l_day:'" + bbm + "'", function (data) {
                for (var i = 0; i < 15; i++) {
                    $('#div_mob').find('div:first').remove();
                }
                $("#div_mob").append(data.d);
                for (var i = 0; i < 15; i++) {
                    $('#div_mob').find('div.row:last').remove();
                }
                f_message = $("#msg_" + f_date.split('/')[1] + f_date.split('/')[2]).text();
                triggered = false;
            });
        };
        function set_cal() {
            $("#chk_toggle").prop("checked", false);
            if (f_size < 750) {
                if (window.innerWidth > 750)
                    set_cal_req($("#cb_year").val(), $("#cb_month").val());
            }
            else if (f_size > 750) {
                if (window.innerWidth < 750)
                    set_cal_req($("#cb_year").val(), $("#cb_month").val());
            }
            f_size = window.innerWidth;
        }
        function set_cal_req(year, month) {
            if (year == '' || month == '') {
                year = f_date.split('/')[0];
                month = f_date.split('/')[1];
                $("#cb_year").attr("value", f_date.split('/')[0]);
                $("#cb_month").prop("value", f_date.split('/')[1]);
            }
            reqsvr("load_calendar", "year:" + year + ", month:" + month, function (data) {
                f_data = data.d;
                if (window.innerWidth > 750) {
                    $("#div_btn").removeClass("col-xs-8");
                    $("#div_btn_mob").css("display", "none");
                    $("#div_toggle").css("display", "none");
                    $("#div_btn").css("display", "flex");
                    $("#div_container").empty();
                    $("#div_container").append(data.d[0]);
                } else {
                    $("#div_btn").addClass("col-xs-8");
                    $("#div_toggle").css("display", "flex");
                    $("#div_btn_mob").css("display", "flex");
                    $("#div_btn").css("display", "none");
                    $("#div_container").empty();
                    $("#div_container").append(data.d[1]);
                    $("body").css("padding", "0px 5px 0px 3px");
                }
                f_message = $("#msg_" + f_date.split('/')[1] + f_date.split('/')[2]).text();
            });
        }
        function fnc_alarm(o, y) {
            show_input_alert(" یادآور  " + o, $("#msg_" + o.split('/')[1] + o.split('/')[2]).text(), function (v) {
                if (v.length > 100) {
                    alert_error("تعداد کاراکتر بیشتر از حد مجاز");
                    return;
                }
                reqsvr("save_alarm", "date:'" + o + "' ,message:'" + v + "'", function (data) {
                    if (data.d != "inserted" && data.d != "updated") {
                        alert_error("یادآور ذخیره نشد");
                        return;
                    }
                    alert_success("یادآور با موفقیت ذخیره شد");
                    $("#msg_" + o.split('/')[1] + o.split('/')[2]).text(v);
                    if (f_size < 750)
                        $("#msg_" + o.split('/')[1] + o.split('/')[2]).closest("div").css("height", "4rem");
                    $(y).attr("title", v);
                    return;
                });
            }, function (r) {
                if (r == "") {
                    alert_error("روز مورد نظر دارای یادداشت نمی باشد");
                    return;
                }
                reqsvr("delete_alarm", "date:'" + o + "'", function () {
                    alert_success("یادآور با موفقیت حذف شد");
                    $("#msg_" + o.split('/')[1] + o.split('/')[2]).text("");
                    if (f_size < 750)
                        $("#msg_" + o.split('/')[1] + o.split('/')[2]).closest("div").css("height", "0rem");
                    $(y).attr("title", "");
                    $("#icn_" + o.split('/')[1] + o.split('/')[2]).remove();
                    return;
                });
            });
        }
        function scroll_today() {
            if ($("#cb_month").val() == f_date.substr(5, 2)) {
                setTimeout(function () {
                    $("#div_mob").animate({ scrollTop: ($(".bg-green-light").position().top + $("#div_mob").scrollTop()) }, 2000, "swing");
                }, 500);
            }
        }
        function fnc_toggle() {
            $('h5').each(function () {
                if ($("#chk_toggle").is(":checked")) {
                    if ($(this).text() == "")
                        $(this).closest("div").parent("div").hide();
                } else
                    $(this).closest("div").parent("div").show();
            });
        }
        function show_alarm() {
            if (f_message == "") {
                alert_error("در روز جازی یادداشت قابل مشاهده ندارید");
                return;
            }
            confirm_alert_msg(f_date, f_message, "مشاهده کردم", function () {
                reqsvr("set_isread", "date:'" + f_date + "'", function () {
                });
                $("#icn_" + f_date.split('/')[1] + f_date.split('/')[2]).removeClass("fa-eye-slash");
                $("#icn_" + f_date.split('/')[1] + f_date.split('/')[2]).addClass("fa-eye");
                $("#icn_" + f_date.split('/')[1] + f_date.split('/')[2]).css("color", "green");
            });
        }
        function month_change(sign) {
            var m = parseInt($("[name=month]").val());
            switch (sign) {
                case "+":
                    if (m == 12) {
                        $("[name=month]").val("01");
                        var y = parseInt($("[name=year]").val());
                        $("[name=year]").val((y + 1).toString());
                    }
                    else {
                        m++;
                        if (m < 10)
                            m = '0' + m;
                        $("[name=month]").val(m.toString());
                    }
                    break;
                case "-":
                    if (m == 1) {
                        $("[name=month]").val("12");
                        var y = parseInt($("[name=year]").val());
                        $("[name=year]").val((y - 1).toString());
                    }
                    else {
                        m--;
                        if (m < 10)
                            m = '0' + m;
                        $("[name=month]").val(m.toString());
                    }
                    break;
            }
            set_cal_req($("#cb_year").val(), $("#cb_month").val());
            scroll_today();
        }
        function today_fnc() {
            set_cal_req('', '');
            triggered = false;
            $("#cb_year").val(f_date.substr(0, 4));
            $("#cb_month").val(f_date.substr(5, 2));
            scroll_today();
        }
        function show_btnbar() {
            var html_tag = '<div class="col-sm-12"> \
                  <input id="tb_date" readonly type="text" class="form-control date"/></div>';
            show_html_alert("برو به تاریخ", html_tag, function (v) {
                set_cal_req(v.substr(0, 4), v.substr(5, 2));
                setTimeout(function () {
                    $("#div_" + v.substr(5, 2) + v.substr(8, 2)).removeClass("bg-gray");
                    $("#div_" + v.substr(5, 2) + v.substr(8, 2)).addClass("bg-yellow-light");
                    $("#div_mob").animate({ scrollTop: $("#div_" + v.substr(5, 2) + v.substr(8, 2)).position().top + $("#div_mob").scrollTop() }, 2000, "swing");
                }, 500);
            }, function () {
                return $("#tb_date").val();
            }, function () {
                $("#tb_date").mask('0000/00/00', { placeholder: "____/__/__" });
                new PesianDate.persianCalendar($("#tb_date").attr('id'));
                $('.date').attr("autocomplete", "off");
            });
        }
        function input_change() {
            set_cal_req($("#cb_year").val(), $("#cb_month").val());
        }
    </script>
</head>
<body>
    <form class="" id="main-form">
        <div class="form-head" style="display: flex; justify-content: center; align-items: center;">
            <div id="div_btn_mob" class="col-xs-8 btn-group" role="group" aria-label="Basic example" style="display: flex; justify-content: center; align-items: center;">
                <button onclick="show_btnbar()" type="button" class="col-xs-6 btn btn-secondary">برو به تاریخ</button>
                <button onclick="today_fnc()" type="button" class="col-xs-6 btn btn-secondary">امروز</button>
            </div>
            <div id="div_btn" class="col-xs-8" style="display: none; justify-content: center; align-items: center; margin-top: .5rem;">
                <button type="button" title="مشاهده یادآور" class="btn_vw text-right btn glyphicon glyphicon-bell" style="border-bottom-right-radius: 0; border-top-right-radius: 0; top: 0px"
                    onclick="show_alarm()">
                </button>
                <button type="button" title="ماه بعد" class="btn_vw btn glyphicon glyphicon-chevron-right" style="top: 0px;"
                    onclick="month_change('+')">
                </button>
                <select onchange="input_change()" id="cb_month" name="month" class="input_vw">
                    <option value="01">فروردین</option>
                    <option value="02">اردیبهشت</option>
                    <option value="03">خرداد</option>
                    <option value="04">تیر</option>
                    <option value="05">مرداد</option>
                    <option value="06">شهریور</option>
                    <option value="07">مهر</option>
                    <option value="08">آبان</option>
                    <option value="09">آذر</option>
                    <option value="10">دی</option>
                    <option value="11">بهمن</option>
                    <option value="12">اسفند</option>
                </select>
                <input onchange="input_change()" id="cb_year" name="year" type="number" readonly style="text-align: right;"
                    class="input_vw" min="1380" max="1480" step="1" />
                <button type="button" title="ماه قبل" class="btn_vw btn glyphicon glyphicon-chevron-left" style="top: 0px;"
                    onclick="month_change('-')">
                </button>
                <button type="button" title="ماه جاری" class="btn_vw btn glyphicon glyphicon-refresh" style="top: 0px;"
                    onclick="today_fnc()">
                </button>
            </div>
            <div id="div_toggle" class=" col-xs-4" style="display: none; justify-content: center; align-items: center;">
                <label class="switch" style="margin-top: .85rem;">
                    <input id="chk_toggle" type="checkbox" onchange="fnc_toggle()" />
                    <span style="width: 3.5rem; height: 1.5rem;" class="slider round"></span>
                </label>
                <span class="label_vw" style="padding-right: 2rem; vertical-align: super;">فقط یادآور ها</span>
            </div>
        </div>
        <div id="div_container" class="row col-xs-12 form_container">
        </div>
    </form>
</body>
</html>
