﻿
<%@ WebHandler Language="C#" Class="docUploader" %>
using System;
using System.Web;
using System.IO;
using System.Globalization;
public class docUploader : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {

        context.Response.ContentType = "text/plain";
        try
        {
            string extension = string.Empty;
            string allText = string.Empty;
            string dirFullPath = HttpContext.Current.Server.MapPath("~/files/temp/");
            if (!Directory.Exists(dirFullPath))
            {
                Directory.CreateDirectory(dirFullPath);
            }

            string fullFileName = string.Empty;
            foreach (string s in context.Request.Files)
            {
                HttpPostedFile file = context.Request.Files[s];
                string fileName = file.FileName;

                if (!string.IsNullOrEmpty(fileName))
                {
                    extension = Path.GetExtension(fileName).ToLower();
                    // To specify the name of the document added
                    fullFileName = string.Format("{0}{1}", DateTime.Now.Ticks, extension);
                    string filePath = string.Format("{0}{1}", dirFullPath, fullFileName);
                    file.SaveAs(filePath);
                    if (extension.Contains("txt"))
                    {
                        using (StreamReader sr = File.OpenText(filePath))
                        {
                            allText = sr.ReadToEnd();
                            allText = allText.Trim();
                        }
                    }
                    else
                    {
                        using (C1.C1Excel.C1XLBook c1 = new C1.C1Excel.C1XLBook())
                        {
                            c1.Load(filePath);
                            if (c1.Sheets[0].Rows.Count > 0)
                            {
                                string sellValue = string.Empty;
                                for (int i = 0; i < c1.Sheets[0].Rows.Count; i++)
                                {
                                    if (c1.Sheets[0][i, 0].Value != null)
                                    {
                                        try
                                        {
                                            sellValue = string.Format("{0}",c1.Sheets[0][i, 0].Value);
                                            if (string.IsNullOrWhiteSpace(sellValue)) continue;
                                            allText = string.Format("{0}{1}{2}", allText, (allText.Length > 0) ? "," : string.Empty, sellValue);
                                        }
                                        catch (Exception) { }
                                    }
                                }
                            }
                        }
                    }
                    File.Delete(filePath);
                }
            }
            context.Response.Write(allText);
        }
        catch (Exception ex)
        {
            bool result = ex.Message.Length == 0;
        }

    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
}